/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.tidy.AbsChecker;
import com.hp.hpl.jena.ontology.tidy.CNodeI;
import com.hp.hpl.jena.ontology.tidy.CategorySet;
import com.hp.hpl.jena.ontology.tidy.Levels;
import com.hp.hpl.jena.ontology.tidy.MinimalSubGraph;
import com.hp.hpl.jena.ontology.tidy.NodeAction;
import com.hp.hpl.jena.ontology.tidy.Q;
import com.hp.hpl.jena.ontology.tidy.SubCategorize;
import com.hp.hpl.jena.ontology.tidy.SyntaxProblem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import java.util.Vector;

public class Checker
extends AbsChecker {
    private GraphMaker gf;
    private Vector monotoneProblems = new Vector();
    private Vector warnings = new Vector();
    private Vector nonMonotoneProblems = null;
    private int nonMonotoneLevel;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$RDFNode;

    public Iterator getErrors() {
        this.nonMonotoneLevel = 1;
        if (this.monotoneProblems.size() > 0) {
            return this.monotoneProblems.iterator();
        }
        this.snapCheck();
        return this.nonMonotoneProblems.iterator();
    }

    public Iterator getProblems() {
        return new ConcatenatedIterator(this.getErrors(), this.warnings.iterator());
    }

    private void snapCheck() {
        if (this.nonMonotoneProblems == null) {
            this.nonMonotoneProblems = new Vector();
            this.nonMonotoneLevel = 1;
            Model model = ModelFactory.createModelForGraph(this.asGraph());
            this.check(CategorySet.untypedSets, new NodeAction(){

                public void apply(Node node) {
                    Checker.this.nonMonProblem("Untyped node", node);
                }
            }, model);
            this.check(CategorySet.orphanSets, new NodeAction(){

                public void apply(Node node) {
                    Checker.this.nonMonProblem("Orphaned rdf:List or owl:OntologyProperty node", node);
                }
            }, model);
            if (this.wantLite) {
                this.check(CategorySet.dlOrphanSets, new NodeAction(){

                    public void apply(Node node) {
                        Checker.this.nonMonProblem("Orphaned blank owl:Class or owl:Restriction is in OWL DL", node, 1);
                    }
                }, model);
            }
            this.check(CategorySet.structuredOne, new NodeAction(){

                public void apply(Node node) {
                    if (Checker.this.getCNode(node).asOne().incomplete()) {
                        Checker.this.nonMonProblem("Incomplete blank owl:Class or owl:AllDifferent", node);
                    }
                }
            }, model);
            this.check(CategorySet.structuredTwo, new NodeAction(){

                public void apply(Node node) {
                    if (Checker.this.getCNode(node).asTwo().incomplete()) {
                        Checker.this.nonMonProblem("Incomplete rdf:List or owl:Restriction", node);
                    }
                }
            }, model);
        }
    }

    private void check(Q q, NodeAction nodeAction, Model model) {
        Query query = q.asRDQL();
        query.setSource(model);
        QueryEngine queryEngine = new QueryEngine(query);
        QueryResults queryResults = queryEngine.exec();
        while (queryResults.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)queryResults.next();
            RDFNode rDFNode = (RDFNode)resultBinding.get("x");
            nodeAction.apply(rDFNode.asNode());
        }
    }

    private void nonMonProblem(String string, Node node) {
        this.nonMonProblem(string, node, 2);
    }

    private void nonMonProblem(String string, Node node, int n) {
        Model model = ModelFactory.createDefaultModel();
        Graph graph = model.getGraph();
        if (this.nonMonotoneLevel <= n) {
            this.nonMonotoneLevel = n + 1;
        }
        if (n == 1 && !this.wantLite) {
            return;
        }
        EnhNode enhNode = ((EnhGraph)((Object)model)).getNodeAs(node, class$com$hp$hpl$jena$rdf$model$RDFNode == null ? (class$com$hp$hpl$jena$rdf$model$RDFNode = Checker.class$("com.hp.hpl.jena.rdf.model.RDFNode")) : class$com$hp$hpl$jena$rdf$model$RDFNode);
        ExtendedIterator extendedIterator = this.hasBeenChecked.find(node, null, null);
        while (extendedIterator.hasNext()) {
            graph.add((Triple)extendedIterator.next());
        }
        this.nonMonotoneProblems.add(new SyntaxProblem(string, enhNode, n));
    }

    public Checker(boolean bl, GraphMaker graphMaker) {
        super(bl, graphMaker);
        this.gf = graphMaker;
    }

    public Checker() {
        this(false);
    }

    public Checker(boolean bl) {
        this(bl, new SimpleGraphMaker());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Graph graph) {
        ExtendedIterator extendedIterator = null;
        try {
            extendedIterator = graph.find(null, null, null);
            while (extendedIterator.hasNext()) {
                this.add((Triple)extendedIterator.next(), true);
            }
        }
        finally {
            if (extendedIterator != null) {
                extendedIterator.close();
            }
        }
    }

    public void load(String string) {
        OntModel ontModel = ModelFactory.createOntologyModel(new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, "http://www.w3.org/2002/07/owl#"), null);
        ontModel.getDocumentManager().setProcessImports(true);
        ontModel.read(string);
        this.add(ontModel.getGraph());
    }

    void addProblem(int n, Triple triple) {
        super.addProblem(n, triple);
        if (n == 1 && !this.wantLite) {
            return;
        }
        Graph graph = new MinimalSubGraph(n == 1, triple, this).getContradiction();
        this.addProblem(new SyntaxProblem("Not a " + Levels.toString(n) + " subgraph", graph, n));
    }

    void addProblem(SyntaxProblem syntaxProblem) {
        super.addProblem(syntaxProblem);
        switch (syntaxProblem.level) {
            case 0: {
                this.warnings.add(syntaxProblem);
            }
            case 1: {
                if (this.wantLite) break;
                return;
            }
        }
        this.monotoneProblems.add(syntaxProblem);
    }

    public String getSubLanguage() {
        int n;
        if (this.monotoneLevel < 3 && this.monotoneProblems.size() == 0) {
            this.snapCheck();
        }
        int n2 = n = this.monotoneLevel < this.nonMonotoneLevel ? this.nonMonotoneLevel : this.monotoneLevel;
        if (this.wantLite && n == 2) {
            return "DL or Full";
        }
        return Levels.toString(n);
    }

    void actions(long l, CNodeI cNodeI, CNodeI cNodeI2, Triple triple) {
        if (SubCategorize.tripleForObject(l)) {
            cNodeI2.asBlank().addObjectTriple(triple);
        }
        switch (SubCategorize.action(l)) {
            case 4: {
                cNodeI.asOne().first(triple);
                break;
            }
            case 8: {
                cNodeI.asTwo().first(triple);
                break;
            }
            case 12: {
                cNodeI.asTwo().second(triple);
            }
        }
    }

    public static void main(String[] stringArray) {
        GraphMaker graphMaker = ModelFactory.createMemModelMaker().getGraphMaker();
        OntModel ontModel = ModelFactory.createOntologyModel(new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, "http://www.w3.org/2002/07/owl#"), null);
        ontModel.getDocumentManager().setProcessImports(true);
        ontModel.read(stringArray[0]);
        Graph graph = ontModel.getGraph();
        Checker checker = new Checker(stringArray.length == 2 && stringArray[1].equalsIgnoreCase("Lite"), graphMaker);
        checker.add(graph);
        String string = checker.getSubLanguage();
        System.out.println(string);
        if (stringArray.length > 1) {
            if (stringArray[1].equals(string)) {
                return;
            }
            if (stringArray[1].equalsIgnoreCase("Full") || string.equals("Lite")) {
                System.err.println("All constructs were in OWL " + string + ".");
                return;
            }
        }
        Iterator iterator = checker.getProblems();
        while (iterator.hasNext()) {
            SyntaxProblem syntaxProblem = (SyntaxProblem)iterator.next();
            System.err.println(syntaxProblem.longDescription());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

