/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.DefaultErrorHandler;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.WrappedException;
import java.io.IOException;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.NodeFactory;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.syntax.RDFConsumer;
import org.w3c.rdf.syntax.RDFParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StanfordImpl
implements RDFParser {
    private ARP arp;
    ErrorHandler errorHandler = new DefaultErrorHandler();

    public StanfordImpl() {
        this.arp = new ARP();
    }

    public synchronized void parse(InputSource inputSource, RDFConsumer rDFConsumer) throws SAXException {
        this.arp.setStatementHandler(new StanfordStatementHandler(rDFConsumer));
        try {
            this.arp.load(inputSource);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.arp.setErrorHandler(errorHandler);
    }

    private class StanfordStatementHandler
    implements StatementHandler {
        RDFConsumer consumer;
        NodeFactory nodeFactory;
        boolean started = false;

        StanfordStatementHandler(RDFConsumer rDFConsumer) throws SAXException {
            this.consumer = rDFConsumer;
            try {
                this.nodeFactory = rDFConsumer.getNodeFactory();
            }
            catch (ModelException modelException) {
                throw new SAXException((Exception)((Object)modelException));
            }
        }

        void end() throws SAXException {
            if (this.started) {
                try {
                    this.consumer.endModel();
                }
                catch (ModelException modelException) {
                    throw new SAXException((Exception)((Object)modelException));
                }
            }
            this.started = false;
        }

        private Resource translate(AResource aResource) throws ModelException {
            Resource resource = (Resource)aResource.getUserData();
            if (resource != null) {
                return resource;
            }
            resource = aResource.isAnonymous() ? this.nodeFactory.createUniqueResource() : this.nodeFactory.createResource(aResource.getURI());
            aResource.setUserData(resource);
            return resource;
        }

        private Literal translate(ALiteral aLiteral) throws ModelException {
            return this.nodeFactory.createLiteral(((Object)aLiteral).toString());
        }

        void addStatement(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
            if (!this.started) {
                this.consumer.startModel();
                this.started = true;
            }
            this.consumer.addStatement(this.nodeFactory.createStatement(resource, resource2, rDFNode));
        }

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
            try {
                this.addStatement(this.translate(aResource), this.translate(aResource2), (RDFNode)this.translate(aResource3));
            }
            catch (ModelException modelException) {
                throw new WrappedException((Exception)((Object)modelException));
            }
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
            try {
                this.addStatement(this.translate(aResource), this.translate(aResource2), (RDFNode)this.translate(aLiteral));
            }
            catch (ModelException modelException) {
                throw new WrappedException((Exception)((Object)modelException));
            }
        }
    }
}

