/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.test.WGTestSuite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class MoreTests
extends TestCase
implements RDFErrorHandler,
ARPErrorNumbers {
    private int[] expected;

    public static Test suite() {
        TestSuite testSuite = new TestSuite("ARP Plus");
        testSuite.addTest((Test)new MoreTests("testEncodingMismatch1"));
        testSuite.addTest((Test)new MoreTests("testEncodingMismatch2"));
        testSuite.addTest((Test)new MoreTests("testNullBaseParamOK"));
        testSuite.addTest((Test)new MoreTests("testNullBaseParamError"));
        testSuite.addTest((Test)new MoreTests("testEmptyBaseParamOK"));
        testSuite.addTest((Test)new MoreTests("testEmptyBaseParamError"));
        return testSuite;
    }

    MoreTests(String string) {
        super(string);
    }

    public void testEncodingMismatch1() throws IOException {
        ModelMem modelMem = new ModelMem();
        RDFReader rDFReader = modelMem.getReader();
        FileReader fileReader = new FileReader("testing/wg/rdfms-syntax-incomplete/test001.rdf");
        if (fileReader.getEncoding().startsWith("UTF")) {
            System.err.println("WARNING: Encoding mismatch tests not executed on platform with default UTF encoding.");
            return;
        }
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{129};
        rDFReader.read((Model)modelMem, fileReader, "http://example.org/");
        this.checkExpected();
    }

    public void testEncodingMismatch2() throws IOException {
        ModelMem modelMem = new ModelMem();
        RDFReader rDFReader = modelMem.getReader();
        FileReader fileReader = new FileReader("testing/wg/rdf-charmod-literals/test001.rdf");
        if (fileReader.getEncoding().startsWith("UTF")) {
            return;
        }
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{129, 210};
        rDFReader.read((Model)modelMem, fileReader, "http://example.org/");
        this.checkExpected();
    }

    public void testNullBaseParamOK() throws IOException {
        ModelMem modelMem = new ModelMem();
        ModelMem modelMem2 = new ModelMem();
        RDFReader rDFReader = modelMem.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[0];
        rDFReader.read((Model)modelMem, fileInputStream, "http://example.org/");
        fileInputStream.close();
        fileInputStream = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rDFReader.read((Model)modelMem2, fileInputStream, null);
        fileInputStream.close();
        MoreTests.assertTrue((String)"Base URI should have no effect.", (boolean)modelMem.isIsomorphicWith(modelMem2));
        this.checkExpected();
    }

    public void testNullBaseParamError() throws IOException {
        ModelMem modelMem = new ModelMem();
        RDFReader rDFReader = modelMem.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/wg/rdfms-difference-between-ID-and-about/test1.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{211};
        rDFReader.read((Model)modelMem, fileInputStream, null);
        fileInputStream.close();
        this.checkExpected();
    }

    public void testEmptyBaseParamOK() throws IOException {
        ModelMem modelMem = new ModelMem();
        ModelMem modelMem2 = new ModelMem();
        RDFReader rDFReader = modelMem.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[0];
        rDFReader.read((Model)modelMem, fileInputStream, "http://example.org/");
        fileInputStream.close();
        fileInputStream = new FileInputStream("testing/wg/rdfms-identity-anon-resources/test001.rdf");
        rDFReader.read((Model)modelMem2, fileInputStream, "");
        fileInputStream.close();
        MoreTests.assertTrue((String)("Empty base URI should have no effect.[" + ((Object)modelMem2).toString() + "]"), (boolean)modelMem.isIsomorphicWith(modelMem2));
        this.checkExpected();
    }

    public void testEmptyBaseParamError() throws IOException {
        ModelMem modelMem = new ModelMem();
        RDFReader rDFReader = modelMem.getReader();
        FileInputStream fileInputStream = new FileInputStream("testing/wg/rdfms-difference-between-ID-and-about/test1.rdf");
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{130};
        rDFReader.read((Model)modelMem, fileInputStream, "");
        fileInputStream.close();
        ModelMem modelMem2 = new ModelMem();
        modelMem2.createResource("#foo").addProperty(RDF.value, "abc");
        MoreTests.assertTrue((String)("Empty base URI should produce relative URI.[" + ((Object)modelMem).toString() + "]"), (boolean)modelMem.isIsomorphicWith(modelMem2));
        this.checkExpected();
    }

    private void checkExpected() {
        for (int i = 0; i < this.expected.length; ++i) {
            if (this.expected[i] == 0) continue;
            MoreTests.fail((String)("Expected error: " + JenaReader.errorCodeName(this.expected[i]) + " but it did not occur."));
        }
    }

    public void warning(Exception exception) {
        this.error(0, exception);
    }

    public void error(Exception exception) {
        this.error(1, exception);
    }

    public void fatalError(Exception exception) {
        this.error(2, exception);
    }

    private void error(int n, Exception exception) {
        if (exception instanceof ParseException) {
            int n2 = ((ParseException)exception).getErrorNumber();
            this.onError(n, n2);
        } else {
            MoreTests.fail((String)("Not expecting an Exception: " + exception.getMessage()));
        }
    }

    private void println(String string) {
        System.err.println(string);
    }

    void onError(int n, int n2) {
        for (int i = 0; i < this.expected.length; ++i) {
            if (this.expected[i] != n2) continue;
            this.expected[i] = 0;
            return;
        }
        String string = "Parser reports unexpected " + WGTestSuite.errorLevelName[n] + ": " + JenaReader.errorCodeName(n2);
        this.println(string);
        MoreTests.fail((String)string);
    }
}

