/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelMakerCreator;
import com.hp.hpl.jena.rdf.model.ModelMakerCreatorRegistry;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.ModelSpecCreator;
import com.hp.hpl.jena.rdf.model.ModelSpecCreatorRegistry;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.BadDescriptionException;
import com.hp.hpl.jena.vocabulary.JMS;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashMap;
import java.util.Map;

public abstract class ModelSpecImpl
implements ModelSpec {
    protected ModelMaker maker;
    private static Map values = new HashMap();

    public ModelSpecImpl(ModelMaker modelMaker) {
        this.maker = modelMaker == null ? ModelFactory.createMemModelMaker() : modelMaker;
        this.maker = this.maker;
    }

    public ModelSpecImpl(Model model) {
        this(ModelSpecImpl.createMaker(model));
    }

    public abstract Model createModel();

    public abstract Model createModelOver(String var1);

    public abstract Property getMakerProperty();

    public static ModelSpec create(Model model) {
        Resource resource;
        Model model2 = ModelSpecImpl.withSchema(model);
        Resource resource2 = ModelSpecImpl.findSpecificType(model2, resource = ModelSpecImpl.findRootByType(model2, JMS.ModelSpec), JMS.ModelSpec);
        ModelSpecCreator modelSpecCreator = ModelSpecCreatorRegistry.findCreator(resource2);
        if (modelSpecCreator == null) {
            throw new BadDescriptionException("neither ont nor inf nor mem", model);
        }
        return modelSpecCreator.create(model);
    }

    static Resource findSpecificType(Model model, Resource resource, Resource resource2) {
        StmtIterator stmtIterator = model.listStatements(resource, RDF.type, (RDFNode)null);
        while (stmtIterator.hasNext()) {
            Resource resource3 = stmtIterator.nextStatement().getResource();
            if (!model.contains(resource3, RDFS.subClassOf, resource2)) continue;
            resource2 = resource3;
        }
        return resource2;
    }

    public ModelMaker getModelMaker() {
        return this.maker;
    }

    public Model getDescription() {
        return this.getDescription(ResourceFactory.createResource());
    }

    public Model getDescription(Resource resource) {
        return this.addDescription(ModelFactory.createDefaultModel(), resource);
    }

    public Model addDescription(Model model, Resource resource) {
        Resource resource2 = model.createResource();
        model.add(resource, this.getMakerProperty(), resource2);
        this.maker.addDescription(model, resource2);
        return model;
    }

    public static Model withSchema(Model model) {
        return ModelFactory.createRDFSModel(JMS.schema, model);
    }

    public static Resource createValue(Object object) {
        Resource resource = ResourceFactory.createResource();
        values.put(resource, object);
        return resource;
    }

    public static Object getValue(RDFNode rDFNode) {
        return values.get(rDFNode);
    }

    public static Resource findRootByType(Model model, Resource resource) {
        Model model2 = ModelSpecImpl.withSchema(model);
        ResIterator resIterator = model2.listSubjectsWithProperty(RDF.type, resource);
        if (resIterator.hasNext()) {
            return resIterator.nextResource();
        }
        throw new BadDescriptionException("no " + resource + " thing found", model);
    }

    public static ModelMaker createMaker(Model model) {
        Resource resource;
        Model model2 = ModelSpecImpl.withSchema(model);
        Resource resource2 = ModelSpecImpl.findSpecificType(model2, resource = ModelSpecImpl.findRootByType(model2, JMS.MakerSpec), JMS.MakerSpec);
        ModelMakerCreator modelMakerCreator = ModelMakerCreatorRegistry.findCreator(resource2);
        if (modelMakerCreator == null) {
            throw new RuntimeException("no maker type");
        }
        return modelMakerCreator.create(model2, resource);
    }
}

