/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.impl.FileGraphMaker;
import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelMakerCreator;
import com.hp.hpl.jena.rdf.model.ModelMakerCreatorRegistry;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.ModelSpecCreator;
import com.hp.hpl.jena.rdf.model.ModelSpecCreatorRegistry;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.rdf.model.impl.PlainModelSpec;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.vocabulary.JMS;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestModelSpec
extends ModelTestBase {
    protected Model aModel = ModelFactory.createDefaultModel();
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestModelSpec;
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$impl$SimpleGraphMaker;
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$impl$FileGraphMaker;

    public TestModelSpec(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$rdf$model$test$TestModelSpec == null ? (class$com$hp$hpl$jena$rdf$model$test$TestModelSpec = TestModelSpec.class$("com.hp.hpl.jena.rdf.model.test.TestModelSpec")) : class$com$hp$hpl$jena$rdf$model$test$TestModelSpec);
    }

    protected Resource resource(String string) {
        return this.aModel.createResource(string);
    }

    public void testNotFindMaker() {
        Resource resource = this.resource("jms:xyz");
        TestModelSpec.assertSame(null, (Object)ModelMakerCreatorRegistry.findCreator(resource));
    }

    public void testFindMakerChoice() {
        Resource resource = this.resource("jms:type1");
        Resource resource2 = this.resource("jms:type2");
        ModelMakerCreator modelMakerCreator = new ModelMakerCreator(){

            public ModelMaker create(Model model, Resource resource) {
                return null;
            }
        };
        ModelMakerCreator modelMakerCreator2 = new ModelMakerCreator(){

            public ModelMaker create(Model model, Resource resource) {
                return null;
            }
        };
        ModelMakerCreatorRegistry.register(resource, modelMakerCreator);
        ModelMakerCreatorRegistry.register(resource2, modelMakerCreator2);
        TestModelSpec.assertSame((Object)modelMakerCreator, (Object)ModelMakerCreatorRegistry.findCreator(resource));
        TestModelSpec.assertSame((Object)modelMakerCreator2, (Object)ModelMakerCreatorRegistry.findCreator(resource2));
    }

    public void testFindStandardMakers() {
        TestModelSpec.assertNotNull((Object)ModelMakerCreatorRegistry.findCreator(JMS.FileMakerSpec));
        TestModelSpec.assertNotNull((Object)ModelMakerCreatorRegistry.findCreator(JMS.MemMakerSpec));
        TestModelSpec.assertNotNull((Object)ModelMakerCreatorRegistry.findCreator(JMS.RDBMakerSpec));
    }

    public void testNotFindCreator() {
        Resource resource = this.resource("jms:SomeType");
        TestModelSpec.assertSame(null, (Object)ModelSpecCreatorRegistry.findCreator(resource));
    }

    public void testFindCreator() {
        Resource resource = this.resource("jms:SomeType");
        ModelSpecCreator modelSpecCreator = new ModelSpecCreator(){

            public ModelSpec create(Model model) {
                return null;
            }
        };
        ModelSpecCreatorRegistry.register(resource, modelSpecCreator);
        TestModelSpec.assertSame((Object)modelSpecCreator, (Object)ModelSpecCreatorRegistry.findCreator(resource));
    }

    public void testFindCreatorChoice() {
        Resource resource = this.resource("jms:SomeType1");
        Resource resource2 = this.resource("jms:SomeType2");
        ModelSpecCreator modelSpecCreator = new ModelSpecCreator(){

            public ModelSpec create(Model model) {
                return null;
            }
        };
        ModelSpecCreator modelSpecCreator2 = new ModelSpecCreator(){

            public ModelSpec create(Model model) {
                return null;
            }
        };
        ModelSpecCreatorRegistry.register(resource, modelSpecCreator);
        ModelSpecCreatorRegistry.register(resource2, modelSpecCreator2);
        TestModelSpec.assertSame((Object)modelSpecCreator, (Object)ModelSpecCreatorRegistry.findCreator(resource));
        TestModelSpec.assertSame((Object)modelSpecCreator2, (Object)ModelSpecCreatorRegistry.findCreator(resource2));
    }

    public void testHasStandardCreators() {
        TestModelSpec.assertNotNull((Object)ModelSpecCreatorRegistry.findCreator(JMS.InfModelSpec));
        TestModelSpec.assertNotNull((Object)ModelSpecCreatorRegistry.findCreator(JMS.PlainModelSpec));
        TestModelSpec.assertNotNull((Object)ModelSpecCreatorRegistry.findCreator(JMS.OntModelSpec));
    }

    public void testNamedCreatePlain() {
        ModelSpec modelSpec = ModelSpecImpl.create(TestModelSpec.createPlainModelDesc());
        Model model = modelSpec.createModelOver("aName");
        TestModelSpec.assertTrue((boolean)(model.getGraph() instanceof GraphMem));
    }

    public void testNamedCreateInf() {
        String string = "http://jena.hpl.hp.com/2003/DAMLMicroReasonerFactory";
        ModelSpec modelSpec = ModelSpecImpl.create(TestModelSpec.createInfModelDesc(string));
        Model model = modelSpec.createModelOver("iName");
        TestModelSpec.assertTrue((boolean)(model.getGraph() instanceof InfGraph));
    }

    public void testOntModeSpecIsaModelSpec() {
        TestModelSpec.assertTrue((boolean)(OntModelSpec.DAML_MEM_RULE_INF instanceof ModelSpec));
    }

    public void testOntModelSpecCreatesOntModels() {
        Model model = OntModelSpec.DAML_MEM_RULE_INF.createModel();
        TestModelSpec.assertTrue((boolean)(model instanceof OntModel));
    }

    public void testOntModelSpecDescription() {
        OntModelSpec ontModelSpec = OntModelSpec.DAML_MEM_RULE_INF;
        Model model = ontModelSpec.getDescription();
        String string = "http://www.daml.org/2001/03/daml+oil#";
        TestModelSpec.assertTrue((String)"", (boolean)model.listStatements(null, JMS.ontLanguage, string).hasNext());
        StmtIterator stmtIterator = model.listStatements(null, JMS.docManager, (RDFNode)null);
        Resource resource = stmtIterator.nextStatement().getResource();
        TestModelSpec.assertSame((Object)ontModelSpec.getDocumentManager(), (Object)ModelSpecImpl.getValue(resource));
    }

    public void testOntModelSpecMaker() {
        OntModelSpec ontModelSpec = OntModelSpec.DAML_MEM_RULE_INF;
        Model model = ontModelSpec.getDescription();
        Statement statement = model.getRequiredProperty(null, JMS.importMaker);
        Model model2 = ontModelSpec.getModelMaker().getDescription();
        TestModelSpec.assertNotNull((Object)statement);
        this.assertIsoModels(model2, this.subModel(model, statement.getObject()));
    }

    public void testOntModelReasoner() {
        OntModelSpec ontModelSpec = OntModelSpec.DAML_MEM_RULE_INF;
        Model model = ontModelSpec.getDescription();
        Resource resource = model.createResource(ontModelSpec.getReasonerFactory().getURI());
        Statement statement = model.getRequiredProperty(null, JMS.reasonsWith);
        Model model2 = ModelFactory.createDefaultModel().add(model.createResource(), JMS.reasoner, resource);
        this.assertIsoModels(model2, this.subModel(model, statement.getObject()));
    }

    public Model subModel(Model model, RDFNode rDFNode) {
        Model model2 = ModelFactory.createDefaultModel();
        if (rDFNode instanceof Resource) {
            model2.add(model.listStatements((Resource)rDFNode, null, (RDFNode)null));
        }
        return model2;
    }

    public void testCreateOntSpec() {
        OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM_RULE_INF;
        Model model = ModelFactory.createDefaultModel();
        String string = ontModelSpec.getLanguage();
        Resource resource = ResourceFactory.createResource();
        Resource resource2 = model.createResource(ontModelSpec.getReasonerFactory().getURI());
        model.add(resource, JMS.ontLanguage, string);
        Resource resource3 = model.createResource();
        model.add(resource3, JMS.reasoner, resource2);
        model.add(resource, JMS.reasonsWith, resource3);
        Resource resource4 = model.createResource();
        Model model2 = ModelFactory.createDefaultModel();
        model2.add(resource4, RDF.type, JMS.MemMakerSpec);
        model2.add(resource4, JMS.reificationMode, JMS.rsStandard);
        model.add(resource, JMS.importMaker, resource4);
        model.add(model2);
        OntDocumentManager ontDocumentManager = ontModelSpec.getDocumentManager();
        Resource resource5 = ModelSpecImpl.createValue(ontDocumentManager);
        model.add(resource, JMS.docManager, resource5);
        OntModelSpec ontModelSpec2 = new OntModelSpec(model);
        TestModelSpec.assertEquals((String)string, (String)ontModelSpec2.getLanguage());
        TestModelSpec.assertEquals((String)resource2.getURI(), (String)ontModelSpec2.getReasonerFactory().getURI());
        this.assertIsoModels(model2, ontModelSpec2.getModelMaker().getDescription());
        TestModelSpec.assertSame((Object)ontDocumentManager, (Object)ontModelSpec2.getDocumentManager());
    }

    public void testCreateFailingMaker() {
        try {
            ModelSpecImpl.createMaker(TestModelSpec.modelWithStatements(""));
            TestModelSpec.fail((String)"oops");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCreateMemModelMaker() {
        Resource resource = JMS.MemMakerSpec;
        this.testCreateModelMaker(JMS.rsStandard, resource, class$com$hp$hpl$jena$graph$impl$SimpleGraphMaker == null ? (class$com$hp$hpl$jena$graph$impl$SimpleGraphMaker = TestModelSpec.class$("com.hp.hpl.jena.graph.impl.SimpleGraphMaker")) : class$com$hp$hpl$jena$graph$impl$SimpleGraphMaker);
        this.testCreateModelMaker(JMS.rsMinimal, resource, class$com$hp$hpl$jena$graph$impl$SimpleGraphMaker == null ? (class$com$hp$hpl$jena$graph$impl$SimpleGraphMaker = TestModelSpec.class$("com.hp.hpl.jena.graph.impl.SimpleGraphMaker")) : class$com$hp$hpl$jena$graph$impl$SimpleGraphMaker);
        this.testCreateModelMaker(JMS.rsConvenient, resource, class$com$hp$hpl$jena$graph$impl$SimpleGraphMaker == null ? (class$com$hp$hpl$jena$graph$impl$SimpleGraphMaker = TestModelSpec.class$("com.hp.hpl.jena.graph.impl.SimpleGraphMaker")) : class$com$hp$hpl$jena$graph$impl$SimpleGraphMaker);
    }

    public void testCreateFileModelMaker() {
        Resource resource = JMS.FileMakerSpec;
        this.testCreateModelMaker(JMS.rsStandard, resource, class$com$hp$hpl$jena$graph$impl$FileGraphMaker == null ? (class$com$hp$hpl$jena$graph$impl$FileGraphMaker = TestModelSpec.class$("com.hp.hpl.jena.graph.impl.FileGraphMaker")) : class$com$hp$hpl$jena$graph$impl$FileGraphMaker);
        this.testCreateModelMaker(JMS.rsMinimal, resource, class$com$hp$hpl$jena$graph$impl$FileGraphMaker == null ? (class$com$hp$hpl$jena$graph$impl$FileGraphMaker = TestModelSpec.class$("com.hp.hpl.jena.graph.impl.FileGraphMaker")) : class$com$hp$hpl$jena$graph$impl$FileGraphMaker);
        this.testCreateModelMaker(JMS.rsConvenient, resource, class$com$hp$hpl$jena$graph$impl$FileGraphMaker == null ? (class$com$hp$hpl$jena$graph$impl$FileGraphMaker = TestModelSpec.class$("com.hp.hpl.jena.graph.impl.FileGraphMaker")) : class$com$hp$hpl$jena$graph$impl$FileGraphMaker);
    }

    public void testCreateFileModelMakerRooted() {
        String string = "/somewhere";
        Resource resource = ResourceFactory.createResource();
        Model model = ModelFactory.createDefaultModel().add(resource, RDF.type, JMS.FileMakerSpec).add(resource, JMS.fileBase, string);
        ModelMaker modelMaker = ModelSpecImpl.createMaker(model);
        FileGraphMaker fileGraphMaker = (FileGraphMaker)modelMaker.getGraphMaker();
        TestModelSpec.assertEquals((String)string, (String)fileGraphMaker.getFileBase());
        Model model2 = ModelFactory.createModelForGraph(fileGraphMaker.getDescription());
        TestModelSpec.assertTrue((boolean)model2.listStatements(null, JMS.fileBase, string).hasNext());
    }

    public void testCreateModelMaker(Resource resource, Resource resource2, Class clazz) {
        Resource resource3 = ResourceFactory.createResource();
        Reifier.Style style = JMS.findStyle(resource);
        Model model = TestModelSpec.modelWithStatements("").add(resource3, RDF.type, resource2).add(resource3, JMS.reificationMode, resource);
        ModelMaker modelMaker = ModelSpecImpl.createMaker(model);
        TestModelSpec.assertTrue((boolean)clazz.isInstance(modelMaker.getGraphMaker()));
        TestModelSpec.assertEquals((Object)style, (Object)modelMaker.getGraphMaker().getReificationStyle());
    }

    public void testCreatePlainMemModel() {
        Resource resource = ResourceFactory.createResource();
        Model model = TestModelSpec.modelWithStatements("").add(resource, RDF.type, JMS.MemMakerSpec).add(resource, JMS.reificationMode, JMS.rsStandard);
        PlainModelSpec plainModelSpec = new PlainModelSpec(model);
        ModelMaker modelMaker = plainModelSpec.getModelMaker();
        Model model2 = modelMaker.getDescription(resource);
        TestModelSpec.assertTrue((boolean)model2.contains(resource, RDF.type, JMS.MemMakerSpec));
        TestModelSpec.assertTrue((boolean)model2.contains(resource, JMS.reificationMode, JMS.rsStandard));
        TestModelSpec.assertTrue((boolean)(modelMaker.getGraphMaker() instanceof SimpleGraphMaker));
        TestModelSpec.assertEquals((Object)Reifier.Standard, (Object)modelMaker.getGraphMaker().getReificationStyle());
    }

    public void testCreatePlainFileModel() {
        Resource resource = ResourceFactory.createResource();
        Model model = TestModelSpec.modelWithStatements("").add(resource, RDF.type, JMS.FileMakerSpec).add(resource, JMS.reificationMode, JMS.rsMinimal);
        PlainModelSpec plainModelSpec = new PlainModelSpec(model);
        ModelMaker modelMaker = plainModelSpec.getModelMaker();
        Model model2 = modelMaker.getDescription(resource);
        TestModelSpec.assertTrue((boolean)model2.contains(resource, RDF.type, JMS.FileMakerSpec));
        TestModelSpec.assertTrue((boolean)model2.contains(resource, JMS.reificationMode, JMS.rsMinimal));
        TestModelSpec.assertTrue((boolean)(modelMaker.getGraphMaker() instanceof FileGraphMaker));
        TestModelSpec.assertEquals((Object)Reifier.Minimal, (Object)modelMaker.getGraphMaker().getReificationStyle());
    }

    public static Model createPlainModelDesc() {
        Resource resource = ResourceFactory.createResource();
        Resource resource2 = ResourceFactory.createResource();
        return ModelFactory.createDefaultModel().add(resource, JMS.maker, resource2).add(resource2, RDF.type, JMS.MemMakerSpec).add(resource2, JMS.reificationMode, JMS.rsMinimal);
    }

    public static Model createInfModelDesc(String string) {
        Resource resource = ResourceFactory.createResource();
        Resource resource2 = ResourceFactory.createResource();
        Resource resource3 = ResourceFactory.createResource();
        Resource resource4 = ResourceFactory.createResource(string);
        return ModelFactory.createDefaultModel().add(resource, JMS.reasonsWith, resource3).add(resource3, JMS.reasoner, resource4).add(resource, JMS.maker, resource2).add(resource2, RDF.type, JMS.MemMakerSpec).add(resource2, JMS.reificationMode, JMS.rsMinimal);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

