/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rdfsReasoner1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.BRWRule;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSInfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ResourceBRWRule
extends BRWRule {
    private static Node TYPE = RDF.type.getNode();
    private static Node RESOURCE = RDFS.Resource.getNode();

    public ResourceBRWRule() {
        super(new TriplePattern(null, RDF.type.getNode(), RDFS.Resource.getNode()), new TriplePattern(null, null, null));
    }

    public ExtendedIterator execute(TriplePattern triplePattern, InfGraph infGraph, Finder finder, HashSet hashSet) {
        RDFSInfGraph rDFSInfGraph = (RDFSInfGraph)infGraph;
        if (triplePattern.getSubject().isVariable()) {
            return new ResourceRewriteIterator(rDFSInfGraph.findRawWithContinuation(this.body, finder));
        }
        Node node = triplePattern.getSubject();
        TriplePattern triplePattern2 = new TriplePattern(node, null, null);
        String string = "s";
        ExtendedIterator extendedIterator = rDFSInfGraph.findRawWithContinuation(triplePattern2, finder);
        if (!extendedIterator.hasNext()) {
            triplePattern2 = new TriplePattern(null, null, node);
            string = "o";
            extendedIterator = rDFSInfGraph.findRawWithContinuation(triplePattern2, finder);
            if (!extendedIterator.hasNext()) {
                triplePattern2 = new TriplePattern(null, node, null);
                string = "p";
                extendedIterator = rDFSInfGraph.findRawWithContinuation(triplePattern2, finder);
            }
        }
        BRWRule bRWRule = new BRWRule(new TriplePattern(Node.createVariable(string), TYPE, RESOURCE), this.body);
        return new BRWRule.RewriteIterator(extendedIterator, bRWRule);
    }

    public boolean completeFor(TriplePattern triplePattern) {
        return this.head.subsumes(triplePattern);
    }

    static class ResourceRewriteIterator
    extends WrappedIterator {
        private Triple[] lookahead = new Triple[3];
        private short nAvailable = 0;
        protected HashSet seen = new HashSet();

        public ResourceRewriteIterator(Iterator iterator) {
            super(iterator);
        }

        private void push(Node node) {
            if (this.seen.add(node)) {
                short s = this.nAvailable;
                this.nAvailable = (short)(s + 1);
                this.lookahead[s] = new Triple(node, TYPE, RESOURCE);
            }
        }

        public boolean hasNext() {
            while (this.nAvailable == 0 && super.hasNext()) {
                Triple triple = (Triple)super.next();
                if (!this.seen.add(triple)) continue;
                this.push(triple.getSubject());
                this.push(triple.getPredicate());
                Node node = triple.getObject();
                if (node.isLiteral()) continue;
                this.push(node);
            }
            return this.nAvailable > 0;
        }

        public Object next() {
            if (this.nAvailable == 0 && !this.hasNext()) {
                throw new NoSuchElementException("No element available");
            }
            this.nAvailable = (short)(this.nAvailable - 1);
            return this.lookahead[this.nAvailable];
        }
    }
}

