/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngineI;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BasicForwardRuleInfGraph
extends BaseInfGraph
implements ForwardRuleInfGraphI {
    protected OneToManyMap derivations;
    protected FGraph fdeductions;
    protected Graph schemaGraph;
    protected FRuleEngineI engine;
    protected List rules;
    protected boolean traceOn = false;
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$rulesys$BasicForwardRuleInfGraph == null ? (class$com$hp$hpl$jena$reasoner$rulesys$BasicForwardRuleInfGraph = BasicForwardRuleInfGraph.class$("com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph")) : class$com$hp$hpl$jena$reasoner$rulesys$BasicForwardRuleInfGraph));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$BasicForwardRuleInfGraph;

    public BasicForwardRuleInfGraph(Reasoner reasoner, Graph graph) {
        super(null, reasoner);
        this.instantiateRuleEngine(null);
        this.schemaGraph = graph;
    }

    public BasicForwardRuleInfGraph(Reasoner reasoner, List list, Graph graph) {
        super(null, reasoner);
        this.instantiateRuleEngine(list);
        this.rules = list;
        this.schemaGraph = graph;
    }

    public BasicForwardRuleInfGraph(Reasoner reasoner, List list, Graph graph, Graph graph2) {
        this(reasoner, list, graph);
        this.rebind(graph2);
    }

    protected void instantiateRuleEngine(List list) {
        this.engine = list != null ? new FRuleEngine(this, list) : new FRuleEngine(this);
    }

    public void setRuleStore(Object object) {
        this.engine.setRuleStore(object);
    }

    public void rebind(Graph graph) {
        this.fdata = new FGraph(graph);
        this.rebind();
    }

    public void rebind() {
        this.isPrepared = false;
    }

    public Graph getSchemaGraph() {
        return this.schemaGraph;
    }

    public synchronized void prepare() {
        this.isPrepared = true;
        this.fdeductions = new FGraph(new GraphMem());
        boolean bl = false;
        if (this.schemaGraph != null) {
            bl = this.preloadDeductions(this.schemaGraph);
        }
        if (bl) {
            this.engine.fastInit(this.fdata);
        } else {
            this.engine.init(true, this.fdata);
        }
    }

    protected boolean preloadDeductions(Graph graph) {
        Graph graph2 = this.fdeductions.getGraph();
        BasicForwardRuleInfGraph basicForwardRuleInfGraph = (BasicForwardRuleInfGraph)graph;
        if (basicForwardRuleInfGraph.rules == this.rules) {
            ExtendedIterator extendedIterator = basicForwardRuleInfGraph.find(null, null, null);
            while (extendedIterator.hasNext()) {
                graph2.add((Triple)extendedIterator.next());
            }
            this.engine.setRuleStore(basicForwardRuleInfGraph.engine.getRuleStore());
            return true;
        }
        return false;
    }

    public void addDeduction(Triple triple) {
        this.getDeductionsGraph().add(triple);
    }

    public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        ExtendedIterator extendedIterator = null;
        extendedIterator = this.fdata == null ? this.fdeductions.findWithContinuation(triplePattern, finder) : (finder == null ? this.fdata.findWithContinuation(triplePattern, this.fdeductions) : this.fdata.findWithContinuation(triplePattern, FinderUtil.cascade(this.fdeductions, finder)));
        return extendedIterator.filterDrop(Functor.acceptFilter);
    }

    public ExtendedIterator find(Node node, Node node2, Node node3) {
        return this.findWithContinuation(new TriplePattern(node, node2, node3), null);
    }

    public ExtendedIterator find(TriplePattern triplePattern) {
        return this.findWithContinuation(triplePattern, null);
    }

    public synchronized void performAdd(Triple triple) {
        this.fdata.getGraph().add(triple);
        if (this.isPrepared) {
            this.engine.add(triple);
        }
    }

    public int size() {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        return this.fdata.getGraph().size() + this.fdeductions.getGraph().size();
    }

    public void performDelete(Triple triple) {
        Graph graph;
        if (this.fdata != null && (graph = this.fdata.getGraph()) != null) {
            graph.delete(triple);
        }
        if (this.isPrepared) {
            this.fdeductions.getGraph().delete(triple);
        }
    }

    public void close() {
        if (!this.closed) {
            this.engine = null;
            this.fdeductions = null;
            this.rules = null;
            this.schemaGraph = null;
            super.close();
        }
    }

    public void addBRule(Rule rule) {
        throw new ReasonerException("Forward reasoner does not support hybrid rules - " + rule.toShortString());
    }

    public void deleteBRule(Rule rule) {
        throw new ReasonerException("Forward reasoner does not support hybrid rules - " + rule.toShortString());
    }

    public Graph getDeductionsGraph() {
        return this.fdeductions.getGraph();
    }

    public ExtendedIterator findDataMatches(Node node, Node node2, Node node3) {
        return this.find(node, node2, node3);
    }

    public void logDerivation(Triple triple, Object object) {
        this.derivations.put(triple, object);
    }

    public void silentAdd(Triple triple) {
        this.fdeductions.getGraph().add(triple);
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
        this.engine.setDerivationLogging(bl);
        this.derivations = bl ? new OneToManyMap() : null;
    }

    public boolean shouldLogDerivations() {
        return this.recordDerivations;
    }

    public Iterator getDerivation(Triple triple) {
        if (this.derivations == null) {
            return new NullIterator();
        }
        return this.derivations.getAll(triple);
    }

    public void setTraceOn(boolean bl) {
        this.traceOn = bl;
    }

    public boolean shouldTrace() {
        return this.traceOn && this.engine.shouldTrace();
    }

    public long getNRulesFired() {
        return this.engine.getNRulesFired();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

