/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.impl.GenericChoiceFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;

public class GenericTripleMatchFrame
extends GenericChoiceFrame {
    Node_RuleVariable subjectVar;
    Node_RuleVariable predicateVar;
    Node_RuleVariable objectVar;
    Functor objectFunctor;
    TriplePattern goal;

    public boolean bindResult(Triple triple, LPInterpreter lPInterpreter) {
        if (this.objectVar != null) {
            lPInterpreter.bind(this.objectVar, triple.getObject());
        }
        int n = lPInterpreter.trail.size();
        if (this.objectFunctor != null && !this.functorMatch(triple, lPInterpreter)) {
            lPInterpreter.unwindTrail(n);
            return false;
        }
        if (this.subjectVar != null && !lPInterpreter.unify(this.subjectVar, triple.getSubject())) {
            lPInterpreter.unwindTrail(n);
            return false;
        }
        if (this.predicateVar != null && !lPInterpreter.unify(this.predicateVar, triple.getPredicate())) {
            lPInterpreter.unwindTrail(n);
            return false;
        }
        return true;
    }

    public boolean functorMatch(Triple triple, LPInterpreter lPInterpreter) {
        Node node = triple.getObject();
        if (!Functor.isFunctor(node)) {
            return false;
        }
        Functor functor = (Functor)node.getLiteral().getValue();
        if (!functor.getName().equals(this.objectFunctor.getName())) {
            return false;
        }
        if (functor.getArgLength() != this.objectFunctor.getArgLength()) {
            return false;
        }
        Node[] nodeArray = functor.getArgs();
        Node[] nodeArray2 = this.objectFunctor.getArgs();
        for (int i = 0; i < nodeArray.length; ++i) {
            if (lPInterpreter.unify(nodeArray2[i], nodeArray[i])) continue;
            return false;
        }
        return true;
    }

    public void init(LPInterpreter lPInterpreter) {
        super.init(lPInterpreter);
        Node node = LPInterpreter.deref(lPInterpreter.argVars[0]);
        this.subjectVar = node instanceof Node_RuleVariable ? (Node_RuleVariable)node : null;
        Node node2 = LPInterpreter.deref(lPInterpreter.argVars[1]);
        this.predicateVar = node2 instanceof Node_RuleVariable ? (Node_RuleVariable)node2 : null;
        Node node3 = LPInterpreter.deref(lPInterpreter.argVars[2]);
        Node_RuleVariable node_RuleVariable = this.objectVar = node3 instanceof Node_RuleVariable ? (Node_RuleVariable)node3 : null;
        if (Functor.isFunctor(node3)) {
            this.objectFunctor = (Functor)node3.getLiteral().getValue();
            this.goal = new TriplePattern(node, node2, null);
        } else {
            this.objectFunctor = null;
            this.goal = new TriplePattern(node, node2, node3);
        }
    }
}

