/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class ReasonerTester {
    public static final String NS = "http://www.hpl.hp.com/semweb/2003/query_tester#";
    public static final String BASE_URI = "http://www.hpl.hp.com/semweb/2003/query_tester/";
    public static final Resource testClass;
    public static final Property descriptionP;
    public static final Property tboxP;
    public static final Property dataP;
    public static final Property queryP;
    public static final Property resultP;
    public static final String baseDir = "testing/reasoners/";
    protected Model testManifest;
    protected Map sourceCache = new HashMap();
    protected static Logger logger;
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$test$ReasonerTester;

    public ReasonerTester(String string) throws IOException {
        this.testManifest = this.loadFile(string, false);
    }

    public Model loadFile(String string, boolean bl) throws IOException {
        if (bl && this.sourceCache.keySet().contains(string)) {
            return (Model)this.sourceCache.get(string);
        }
        String string2 = "RDF/XML";
        if (string.endsWith(".nt")) {
            string2 = "N-TRIPLE";
        } else if (string.endsWith("n3")) {
            string2 = "N3";
        }
        ModelMem modelMem = new ModelMem();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(baseDir + string));
        modelMem.read(bufferedReader, BASE_URI + string, string2);
        if (bl) {
            this.sourceCache.put(string, modelMem);
        }
        return modelMem;
    }

    public Graph loadTestFile(Resource resource, Property property) throws IOException {
        if (resource.hasProperty(property)) {
            String string = ((Object)resource.getRequiredProperty(property).getObject()).toString();
            boolean bl = property.equals(tboxP) || property.equals(dataP);
            return this.loadFile(string, bl).getGraph();
        }
        return new GraphMem();
    }

    public static TriplePattern tripleToPattern(Triple triple) {
        return new TriplePattern(ReasonerTester.nodeToPattern(triple.getSubject()), ReasonerTester.nodeToPattern(triple.getPredicate()), ReasonerTester.nodeToPattern(triple.getObject()));
    }

    public static Node nodeToPattern(Node node) {
        if (node.isURI() && node.toString().startsWith("var:")) {
            return Node_RuleVariable.WILD;
        }
        return node;
    }

    public boolean runTests(ReasonerFactory reasonerFactory, TestCase testCase, Resource resource) throws IOException {
        Iterator iterator = this.listTests().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.runTest(string, reasonerFactory, testCase, resource)) continue;
            return false;
        }
        return true;
    }

    public boolean runTests(Reasoner reasoner, TestCase testCase) throws IOException {
        Iterator iterator = this.listTests().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.runTest(string, reasoner, testCase)) continue;
            return false;
        }
        return true;
    }

    public List listTests() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResIterator resIterator = this.testManifest.listSubjectsWithProperty(RDF.type, testClass);
        while (resIterator.hasNext()) {
            arrayList.add(resIterator.next().toString());
        }
        return arrayList;
    }

    public boolean runTest(String string, ReasonerFactory reasonerFactory, TestCase testCase, Resource resource) throws IOException {
        Reasoner reasoner = reasonerFactory.create(resource);
        return this.runTest(string, reasoner, testCase);
    }

    public boolean runTest(String string, Reasoner reasoner, TestCase testCase) throws IOException {
        Object object;
        Resource resource = this.testManifest.getResource(string);
        if (!resource.hasProperty(RDF.type, testClass)) {
            throw new JenaException("Can't find test: " + string);
        }
        String string2 = ((Object)resource.getRequiredProperty(descriptionP).getObject()).toString();
        logger.debug((Object)("Reasoner test " + resource.getURI() + " - " + string2));
        Graph graph = this.loadTestFile(resource, tboxP);
        Graph graph2 = this.loadTestFile(resource, dataP);
        InfGraph infGraph = reasoner.bindSchema(graph).bind(graph2);
        Graph graph3 = this.loadTestFile(resource, queryP);
        GraphMem graphMem = new GraphMem();
        ExtendedIterator extendedIterator = graph3.find(null, null, null);
        while (extendedIterator.hasNext()) {
            object = ReasonerTester.tripleToPattern((Triple)extendedIterator.next());
            logger.debug((Object)("Query: " + object));
            ExtendedIterator extendedIterator2 = infGraph.find(((TriplePattern)object).asTripleMatch());
            while (extendedIterator2.hasNext()) {
                Triple triple = (Triple)extendedIterator2.next();
                logger.debug((Object)("ans: " + TriplePattern.simplePrintString(triple)));
                graphMem.add(triple);
            }
        }
        object = this.loadTestFile(resource, resultP);
        boolean bl = object.isIsomorphicWith(graphMem);
        if (testCase != null) {
            TestCase.assertTrue((String)string2, (boolean)bl);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        descriptionP = new PropertyImpl(NS, "description");
        tboxP = new PropertyImpl(NS, "tbox");
        dataP = new PropertyImpl(NS, "data");
        queryP = new PropertyImpl(NS, "query");
        resultP = new PropertyImpl(NS, "result");
        testClass = new ResourceImpl(NS, "Test");
        logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$reasoner$test$ReasonerTester == null ? (class$com$hp$hpl$jena$reasoner$test$ReasonerTester = ReasonerTester.class$("com.hp.hpl.jena.reasoner.test.ReasonerTester")) : class$com$hp$hpl$jena$reasoner$test$ReasonerTester));
    }
}

