/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import com.hp.hpl.jena.xmloutput.test.TestXMLFeatures;
import com.hp.hpl.jena.xmloutput.test.testWriterInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;

public class testWriterAndReader
extends TestCase
implements RDFErrorHandler {
    private static boolean showProgress = false;
    private static boolean keepFiles = false;
    private static boolean errorDetail = false;
    private static int firstTest = 5;
    private static int lastTest = 9;
    private static int repetitionsJ = 6;
    protected static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$xmloutput$test$testWriterAndReader == null ? (class$com$hp$hpl$jena$xmloutput$test$testWriterAndReader = testWriterAndReader.class$("com.hp.hpl.jena.xmloutput.test.testWriterAndReader")) : class$com$hp$hpl$jena$xmloutput$test$testWriterAndReader));
    String lang;
    String test;
    int fileNumber;
    int options = 0;
    static Resource[] blockRules = new Resource[]{RDFSyntax.parseTypeLiteralPropertyElt, RDFSyntax.parseTypeCollectionPropertyElt, RDFSyntax.propertyAttr, RDFSyntax.sectionReification, RDFSyntax.sectionListExpand, RDFSyntax.parseTypeResourcePropertyElt, DAML_OIL.collection};
    static final String[] baseUris = new String[]{"http://foo.com/Hello", "http://foo.com/Hello", "http://daml.umbc.edu/ontologies/calendar-ont", "http://www.daml.org/2001/03/daml+oil-ex"};
    static /* synthetic */ Class class$com$hp$hpl$jena$xmloutput$test$testWriterAndReader;

    testWriterAndReader(String string, String string2, int n) {
        super(string);
        this.lang = string2;
        this.fileNumber = n;
    }

    testWriterAndReader(String string, String string2, int n, int n2) {
        super(string);
        this.lang = string2;
        this.fileNumber = n;
        this.options = n2;
    }

    public String toString() {
        return this.getName() + " " + this.lang + " t" + this.fileNumber + "000.rdf" + (this.options != 0 ? "[" + this.options + "]" : "");
    }

    static Test suite(String string) {
        return testWriterAndReader.suite(string, false);
    }

    public static Test suite() {
        return testWriterAndReader.suite("special");
    }

    private static boolean nBits(int n, int[] nArray) {
        int n2 = 0;
        while (n > 0) {
            if ((n & 1) == 1) {
                ++n2;
            }
            n >>= 1;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (n2 != nArray[i]) continue;
            return true;
        }
        return false;
    }

    static Test suite(String string, boolean bl) {
        TestSuite testSuite = new TestSuite();
        testSuite.setName(string);
        if (string.equals("special")) {
            testSuite.addTest((Test)new TestXMLFeatures("testNoReification", "RDF/XML-ABBREV"));
            return testSuite;
        }
        testSuite.addTest((Test)new testWriterInterface("testWriting", string));
        for (int i = firstTest; i <= lastTest; ++i) {
            if (string.indexOf("XML") <= 0) continue;
            testSuite.addTest((Test)new testWriterAndReader("testLongId", string, i));
            for (int j = 1; j < (string.equals("RDF/XML-ABBREV") ? 1 << blockRules.length : 2); ++j) {
                if (!bl && !testWriterAndReader.nBits(j, new int[]{1, 6, 7})) continue;
                testSuite.addTest((Test)new testWriterAndReader("testOptions", string, i, j));
            }
        }
        if (string.indexOf("XML") > 0) {
            testSuite.addTest((Test)new TestXMLFeatures("testBadURIAsProperty1", string));
            testSuite.addTest((Test)new TestXMLFeatures("testBadURIAsProperty2", string));
            testSuite.addTest((Test)new TestXMLFeatures("testBadProperty1", string));
            testSuite.addTest((Test)new TestXMLFeatures("testLiAsProperty1", string));
            testSuite.addTest((Test)new TestXMLFeatures("testDescriptionAsProperty", string));
            testSuite.addTest((Test)new TestXMLFeatures("testXMLBase", string));
            testSuite.addTest((Test)new TestXMLFeatures("testRelativeAPI", string));
            testSuite.addTest((Test)new TestXMLFeatures("testRelative", string));
            testSuite.addTest((Test)new TestXMLFeatures("testBug696057", string));
            testSuite.addTest((Test)new TestXMLFeatures("testPropertyURI", string));
            testSuite.addTest((Test)new TestXMLFeatures("testUseNamespace", string));
            testSuite.addTest((Test)new TestXMLFeatures("testUseDefaultNamespace", string));
            testSuite.addTest((Test)new TestXMLFeatures("testBadPrefixNamespace", string));
            testSuite.addTest((Test)new TestXMLFeatures("testRDFNamespace", string));
            testSuite.addTest((Test)new TestXMLFeatures("testDuplicatePrefixSysPropAndExplicit", string));
            testSuite.addTest((Test)new TestXMLFeatures("testRDFDefaultNamespace", string));
            testSuite.addTest((Test)new TestXMLFeatures("testDuplicateNamespace", string));
            testSuite.addTest((Test)new TestXMLFeatures("testDuplicatePrefix", string));
            testSuite.addTest((Test)new TestXMLFeatures("testUseNamespaceSysProp", string));
            testSuite.addTest((Test)new TestXMLFeatures("testDefaultNamespaceSysProp", string));
            testSuite.addTest((Test)new TestXMLFeatures("testDuplicateNamespaceSysProp", string));
            testSuite.addTest((Test)new TestXMLFeatures("testDuplicatePrefixSysProp", string));
            testSuite.addTest((Test)new TestXMLFeatures("testUTF8DeclAbsent", string));
            testSuite.addTest((Test)new TestXMLFeatures("testUTF16DeclAbsent", string));
            testSuite.addTest((Test)new TestXMLFeatures("testUTF8DeclPresent", string));
            testSuite.addTest((Test)new TestXMLFeatures("testUTF16DeclPresent", string));
            testSuite.addTest((Test)new TestXMLFeatures("testISO8859_1_DeclAbsent", string));
            testSuite.addTest((Test)new TestXMLFeatures("testISO8859_1_DeclPresent", string));
            testSuite.addTest((Test)new TestXMLFeatures("testStringDeclAbsent", string));
            testSuite.addTest((Test)new TestXMLFeatures("testStringDeclPresent", string));
            testSuite.addTest((Test)new TestXMLFeatures("testTab", string));
            testSuite.addTest((Test)new TestXMLFeatures("testNoLiteral", string));
            testSuite.addTest((Test)new TestXMLFeatures("testNoTab", string));
            testSuite.addTest((Test)new TestXMLFeatures("testDoubleQuote", string));
            testSuite.addTest((Test)new TestXMLFeatures("testSingleQuote", string));
        }
        if (string.equals("RDF/XML-ABBREV")) {
            testSuite.addTest((Test)new TestXMLFeatures("testNoPropAttr", "RDF/XML-ABBREV"));
            testSuite.addTest((Test)new TestXMLFeatures("testNoDamlCollection", "RDF/XML-ABBREV"));
            testSuite.addTest((Test)new TestXMLFeatures("testNoRdfCollection", "RDF/XML-ABBREV"));
            testSuite.addTest((Test)new TestXMLFeatures("testNoLi", "RDF/XML-ABBREV"));
            testSuite.addTest((Test)new TestXMLFeatures("testNoID", string));
            testSuite.addTest((Test)new TestXMLFeatures("testNoID2", string));
            testSuite.addTest((Test)new TestXMLFeatures("testNoResource", string));
            testSuite.addTest((Test)new TestXMLFeatures("testNoReification", string));
        }
        return testSuite;
    }

    public void testRandom() throws IOException {
        this.doTest(new String[0], new Object[0]);
    }

    public void testLongId() throws IOException {
        this.doTest(new String[]{"longId"}, new Object[]{new Boolean(true)});
    }

    public void testOptions() throws IOException {
        Vector<Resource> vector = new Vector<Resource>();
        for (int i = 0; i < blockRules.length; ++i) {
            if ((this.options & 1 << i) == 0) continue;
            vector.add(blockRules[i]);
        }
        Object[] objectArray = new Resource[vector.size()];
        vector.copyInto(objectArray);
        this.doTest(new String[]{"blockRules"}, new Object[]{objectArray});
    }

    public void doTest(String[] stringArray, Object[] objectArray) throws IOException {
        this.test(this.lang, 35, 1, stringArray, objectArray);
    }

    public void test(String string, int n, int n2, String[] stringArray, Object[] objectArray) throws IOException {
        int n4;
        ModelMem modelMem = new ModelMem();
        ModelMem modelMem2 = new ModelMem();
        this.test = "testWriterAndReader lang=" + string + " seed=" + n;
        String string2 = "modules/rdf/regression/testWriterAndReader/";
        if (showProgress) {
            System.out.println("Beginning " + this.test);
        }
        Random random = new Random(n);
        RDFReader rDFReader = modelMem.getReader(string);
        RDFWriter rDFWriter = modelMem.getWriter(string);
        if (stringArray != null) {
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                rDFWriter.setProperty(stringArray[n4], objectArray[n4]);
            }
        }
        rDFReader.setErrorHandler(this);
        rDFWriter.setErrorHandler(this);
        for (n4 = 0; n4 < n2; ++n4) {
            String string3 = "t" + this.fileNumber * 1000 + ".rdf";
            modelMem = new ModelMem();
            String string4 = this.fileNumber < baseUris.length ? baseUris[this.fileNumber] : "http://foo.com/Hello";
            FileInputStream fileInputStream = new FileInputStream(string2 + string3);
            modelMem.read(fileInputStream, string4);
            ((InputStream)fileInputStream).close();
            boolean bl = false;
            for (int i = 0; i < repetitionsJ; ++i) {
                File file = File.createTempFile("j" + this.lang.substring(0, 2) + this.lang.substring(this.lang.length() - 2) + i + "t", ".txt");
                String string5 = i % 2 == 0 ? string4 : "http://bar.com/irrelevant";
                int n5 = (int)modelMem.size();
                if (i % 2 == 0 && i > 0) {
                    this.prune(modelMem, random, 1 + n5 / 10);
                }
                if (i % 2 == 0 && i > 0) {
                    this.expand(modelMem, random, 1 + n5 / 10);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                rDFWriter.write((Model)modelMem, fileOutputStream, string5);
                ((OutputStream)fileOutputStream).close();
                modelMem2 = new ModelMem();
                FileInputStream fileInputStream2 = new FileInputStream(file);
                rDFReader.read((Model)modelMem2, fileInputStream2, string5);
                ((InputStream)fileInputStream2).close();
                ModelMem modelMem3 = modelMem;
                ModelMem modelMem4 = modelMem2;
                testWriterAndReader.assertTrue((String)("Comparison of file written out, and file read in. See " + file.getAbsolutePath()), (boolean)modelMem3.isIsomorphicWith(modelMem4));
                if (keepFiles) continue;
                file.delete();
            }
            if (!showProgress) continue;
            System.out.print("+");
            System.out.flush();
        }
        if (showProgress) {
            System.out.println("End of " + this.test);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prune(Model model, Random random, int n) {
        int n2;
        Statement[] statementArray = new Statement[n];
        int n4 = (int)model.size();
        StmtIterator stmtIterator = model.listStatements();
        try {
            for (n2 = 0; n2 < n; ++n2) {
                statementArray[n2] = stmtIterator.nextStatement();
            }
            while (stmtIterator.hasNext()) {
                n2 = random.nextInt(n4);
                if (n2 >= n) continue;
                statementArray[n2] = stmtIterator.nextStatement();
            }
        }
        finally {
            stmtIterator.close();
        }
        for (n2 = 0; n2 < n; ++n2) {
            model.remove(statementArray[n2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expand(Model model, Random random, int n) {
        int n2;
        Resource[] resourceArray = new Resource[n];
        Property[] propertyArray = new Property[n];
        RDFNode[] rDFNodeArray = new RDFNode[n];
        int n4 = (int)model.size();
        StmtIterator stmtIterator = model.listStatements();
        try {
            Object object;
            for (n2 = 0; n2 < n; ++n2) {
                object = stmtIterator.nextStatement();
                resourceArray[n2] = object.getSubject();
                propertyArray[n2] = object.getPredicate();
                rDFNodeArray[n2] = object.getObject();
            }
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                object = statement.getSubject();
                RDFNode rDFNode = statement.getObject();
                int n5 = random.nextInt(n4);
                if (n5 < n) {
                    resourceArray[n5] = object;
                }
                if ((n5 = random.nextInt(n4)) < n) {
                    rDFNodeArray[n5] = object;
                }
                if ((n5 = random.nextInt(n4)) < n) {
                    propertyArray[n5] = statement.getPredicate();
                }
                if ((n5 = random.nextInt(n4)) < n) {
                    rDFNodeArray[n5] = rDFNode;
                }
                if (!(rDFNode instanceof Resource) || (n5 = random.nextInt(n4)) >= n) continue;
                resourceArray[n5] = (Resource)rDFNode;
            }
        }
        finally {
            stmtIterator.close();
        }
        for (n2 = 0; n2 < n; ++n2) {
            model.add(resourceArray[n2], propertyArray[n2], rDFNodeArray[n2]);
        }
    }

    public void warning(Exception exception) {
        logger.warn((Object)(this.toString() + " " + exception.getMessage()), (Throwable)exception);
        throw new JenaException(exception);
    }

    public void error(Exception exception) {
        testWriterAndReader.fail((String)exception.getMessage());
    }

    public void fatalError(Exception exception) {
        this.error(exception);
        throw new JenaException(exception);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

