/*
 * Decompiled with CFR 0.152.
 */
package jena.cmdline;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jena.cmdline.Arg;
import jena.cmdline.ArgDecl;
import jena.cmdline.ArgHandler;

public class CommandLine {
    protected ArgHandler argHook = null;
    protected String usage = null;
    protected Map argMap = new HashMap();
    protected Set argValue = new HashSet();
    protected PrintStream out = System.err;
    protected List args = new ArrayList();
    protected List items = new ArrayList();

    public void setHook(ArgHandler argHandler) {
        this.argHook = argHandler;
    }

    public void setOutput(PrintStream out) {
        this.out = out;
    }

    public PrintStream getOutput() {
        return this.out;
    }

    public void setUsage(String usageMessage) {
        this.usage = usageMessage;
    }

    public List args() {
        return this.args;
    }

    public List items() {
        return this.items;
    }

    public void process(String[] argv) throws IllegalArgumentException {
        try {
            String argStr;
            int i;
            for (i = 0; i < argv.length && (argStr = argv[i]).startsWith("-") && !argStr.equals("--") && !argStr.equals("-"); ++i) {
                ArgDecl argDecl;
                Arg arg;
                argStr = ArgDecl.canonicalForm(argStr);
                String val = null;
                if (this.argMap.containsKey(argStr)) {
                    arg = new Arg(argStr);
                    argDecl = (ArgDecl)this.argMap.get(argStr);
                    if (argDecl.takesValue()) {
                        if (i == argv.length - 1) {
                            throw new IllegalArgumentException("No value for argument: " + arg.getName());
                        }
                        val = argv[++i];
                        arg.setValue(val);
                    }
                    if (this.argHook != null) {
                        this.argHook.action(argStr, val);
                    }
                } else {
                    throw new IllegalArgumentException("Unknown argument: " + argStr);
                }
                argDecl.trigger(arg);
                this.args.add(arg);
            }
            if (i < argv.length) {
                if (argv[i].equals("-") || argv[i].equals("--")) {
                    ++i;
                }
                while (i < argv.length) {
                    this.items.add(argv[i]);
                    ++i;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            if (this.out != null) {
                if (this.usage != null) {
                    this.out.println(this.usage);
                }
                this.out.println(ex.getMessage());
            }
            throw ex;
        }
    }

    public boolean contains(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public boolean contains(String s) {
        return this.getArg(s) != null;
    }

    public Arg getArg(ArgDecl argDecl) {
        Arg arg = null;
        Iterator iter = this.args.iterator();
        while (iter.hasNext()) {
            Arg a = (Arg)iter.next();
            if (!argDecl.matches(a)) continue;
            arg = a;
        }
        return arg;
    }

    public Arg getArg(String s) {
        s = ArgDecl.canonicalForm(s);
        Arg arg = null;
        Iterator iter = this.args.iterator();
        while (iter.hasNext()) {
            Arg a = (Arg)iter.next();
            if (!a.getName().equals(s)) continue;
            arg = a;
        }
        return arg;
    }

    public CommandLine add(String argName, boolean hasValue) {
        return this.add(new ArgDecl(hasValue, argName));
    }

    public CommandLine add(ArgDecl arg) {
        Iterator iter = arg.getNames();
        while (iter.hasNext()) {
            this.argMap.put(iter.next(), arg);
        }
        return this;
    }

    public ArgHandler trace() {
        final PrintStream _out = this.out;
        return new ArgHandler(){

            public void action(String arg, String val) {
                if (_out != null) {
                    _out.println("Seen: " + arg + (val != null ? " = " + val : ""));
                }
            }
        };
    }

    public static void main(String[] argv) {
        CommandLine cl = new CommandLine();
        cl.setOutput(System.out);
        ArgDecl argA = new ArgDecl(false, "-a");
        cl.add(argA);
        cl.add("-b", false);
        cl.add("-file", true);
        ArgDecl argFile = new ArgDecl(false, "-v", "--verbose");
        argFile.addHook(cl.trace());
        cl.add(argFile);
        String[] a = new String[]{"-a", "--b", "--a", "--file", "value1", "--file", "value2", "--v", "rest"};
        try {
            cl.process(a);
            System.out.println("PROCESSED");
            if (cl.getArg("file") == null) {
                System.out.println("No --file seen");
            } else {
                System.out.println("--file => " + cl.getArg("file").getValue());
            }
            if (cl.getArg(argA) == null) {
                System.out.println("No --a seen");
            } else {
                System.out.println("--a seen " + cl.getArg(argFile).getValue());
            }
            System.out.println("DUMP");
            Iterator iter = cl.args().iterator();
            while (iter.hasNext()) {
                Arg arg = (Arg)iter.next();
                String v = arg.hasValue() ? " = " + arg.getValue() : "";
                System.out.println("Arg: " + arg.getName() + v);
            }
            iter = cl.items().iterator();
            while (iter.hasNext()) {
                System.out.println("Item: " + (String)iter.next());
            }
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Illegal argument: " + ex.getMessage());
        }
    }
}

