/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import uk.ac.soton.itinnovation.wssecit.WSSecurityException;

public class WSSecITUtil {
    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.wssecit.WSSecITUtil");

    public static Element createElementInWSSecNamespace(Document parentDoc, String tagName) {
        Element e = parentDoc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:" + tagName);
        e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        return e;
    }

    public static Element createElementInSOAP11Namespace(Document parentDoc, String tagName) {
        Element e = parentDoc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:" + tagName);
        e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        return e;
    }

    public static Element createElementInWSUtiNamespace(Document parentDoc, String tagName) {
        Element e = parentDoc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsse:" + tagName);
        e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        return e;
    }

    public static void setAttributeInSOAP11Namespace(Element e, String soapPrefix, String attName, String value) throws WSSecurityException {
        Document parentDoc = e.getOwnerDocument();
        Attr a = parentDoc.createAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", soapPrefix + ":" + attName);
        a.setNodeValue(value);
        if (a.getOwnerDocument() == null) {
            throw new WSSecurityException("Unable to encode WS Security attribute correctly");
        }
        if (!WSSecITUtil.elementInWSSecNamespace(e)) {
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        }
        e.setAttributeNodeNS(a);
    }

    public static void setAttributeInWSSecNamespace(Element e, String attName, String value) throws WSSecurityException {
        Document parentDoc = e.getOwnerDocument();
        Attr a = parentDoc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:" + attName);
        a.setNodeValue(value);
        if (a.getOwnerDocument() == null) {
            throw new WSSecurityException("Unable to encode WS Security attribute correctly");
        }
        if (!WSSecITUtil.elementInWSSecNamespace(e)) {
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        }
        e.setAttributeNodeNS(a);
    }

    public static void setAttributeInWSUtilNamespace(Element e, String attName, String value) throws WSSecurityException {
        Document parentDoc = e.getOwnerDocument();
        Attr a = parentDoc.createAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:" + attName);
        a.setNodeValue(value);
        if (a.getOwnerDocument() == null) {
            throw new WSSecurityException("Unable to encode WS Security attribute correctly");
        }
        if (!WSSecITUtil.elementInWSUtilNamespace(e)) {
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        }
        e.setAttributeNodeNS(a);
    }

    public static boolean elementInWSSecNamespace(Element e) {
        return e != null && e.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    }

    public static boolean elementInWSUtilNamespace(Element e) {
        return e != null && e.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
    }

    public static void serializeDocument(OutputStream out, Document doc) throws WSSecurityException {
        try {
            byte[] outputBytes = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#WithComments").canonicalizeSubtree((Node)doc);
            out.write(outputBytes);
            out.close();
        }
        catch (IOException ex) {
            mLogger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new WSSecurityException("Unable to serialize DOM Document", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            mLogger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new WSSecurityException("Unable to serialize DOM Document", (Exception)((Object)ex));
        }
        catch (CanonicalizationException ex) {
            mLogger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new WSSecurityException("Unable to serialize DOM Document", (Exception)((Object)ex));
        }
    }

    public static Document loadDocument(InputStream in) throws WSSecurityException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            Document doc = db.parse(in);
            doc.normalize();
            return doc;
        }
        catch (IOException ex) {
            mLogger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new WSSecurityException("Unable to deserialize DOM Document", ex);
        }
        catch (ParserConfigurationException ex) {
            mLogger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new WSSecurityException("Unable to deserialize DOM Document", ex);
        }
        catch (SAXException ex) {
            mLogger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new WSSecurityException("Unable to deserialize DOM Document", ex);
        }
    }

    static {
        Init.init();
    }
}

