/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit.encoding;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import uk.ac.soton.itinnovation.wssecit.WSSecurityException;
import uk.ac.soton.itinnovation.wssecit.encoding.SecurityToken;

public class BinarySecurityToken
implements SecurityToken {
    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.wssecit.encoding.BinarySecurityToken");
    private String mId;
    private String mEncodingStyle;
    private String mValueType;
    private String mEncodedData;

    public BinarySecurityToken(String Id, String encodingStyle, String valueType, String encodedData) throws WSSecurityException {
        if (Id == null || Id.equals("")) {
            mLogger.log(Level.SEVERE, "Tried to create a binary security token without an id value");
            throw new WSSecurityException("Tried to create a binary security token without an id value");
        }
        if (encodingStyle == null || encodingStyle.equals("")) {
            mLogger.log(Level.SEVERE, "Tried to create a binary security token without an EncodingStyle value");
            throw new WSSecurityException("Tried to create a binary security token without an EncodingStyle value");
        }
        if (valueType == null || valueType.equals("")) {
            mLogger.log(Level.SEVERE, "Tried to create a binary security token without a ValueType value");
            throw new WSSecurityException("Tried to create a binary security token without a ValueType  value");
        }
        if (encodedData == null || encodedData.equals("")) {
            mLogger.log(Level.SEVERE, "Tried to create a binary security token without any encoded data value");
            throw new WSSecurityException("Tried to create a binary security token without an encoded data value");
        }
        this.mId = Id;
        this.mEncodingStyle = encodingStyle;
        this.mValueType = valueType;
        this.mEncodedData = encodedData;
    }

    public BinarySecurityToken(Element e) throws WSSecurityException {
        Attr IdAtt = e.getAttributeNode("wsu:Id");
        if (IdAtt == null) {
            mLogger.log(Level.SEVERE, "Could not retrieve Id attribute from binary security token");
            throw new WSSecurityException("Unable to retrieve a binary security token because part of the serialised form is missing");
        }
        Attr encAtt = e.getAttributeNode("wsse:EncodingType");
        if (encAtt == null) {
            mLogger.log(Level.SEVERE, "Could not retrieve EncodingStyle attribute from binary security token");
            throw new WSSecurityException("Unable to retrieve a binary security token because part of the serialised form is missing");
        }
        Attr valTypeAtt = e.getAttributeNode("wsse:ValueType");
        if (encAtt == null) {
            mLogger.log(Level.SEVERE, "Could not retrieve ValueType attribute from binary security token");
            throw new WSSecurityException("Unable to retrieve a binary security token because part of the serialised form is missing");
        }
        NodeList children = e.getChildNodes();
        int childrenNumber = children.getLength();
        Text content = null;
        for (int j = 0; j < childrenNumber; ++j) {
            Node node = children.item(j);
            if (node.getNodeType() != 3) continue;
            content = (Text)node;
            break;
        }
        this.mId = IdAtt.getValue();
        this.mEncodingStyle = encAtt.getValue();
        this.mValueType = valTypeAtt.getValue();
        this.mEncodedData = content.getData();
    }

    public String getId() {
        return this.mId;
    }

    public String getEncodingStyle() {
        return this.mEncodingStyle;
    }

    public String getValueType() {
        return this.mValueType;
    }

    public String getEncodedData() {
        return this.mEncodedData;
    }

    public int getType() {
        return 1;
    }
}

