/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit.encoding;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.soton.itinnovation.wssecit.WSSecITUtil;
import uk.ac.soton.itinnovation.wssecit.WSSecurityException;
import uk.ac.soton.itinnovation.wssecit.encoding.Reference;

public class SecurityTokenReference {
    Reference mRef = null;

    public SecurityTokenReference(Element e) throws WSSecurityException {
        NodeList nodeList = e.getChildNodes();
        int number = nodeList.getLength();
        boolean foundRef = false;
        for (int i = 0; i < number; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element refE = (Element)node;
            if (foundRef || !refE.getTagName().equals("Reference")) {
                throw new WSSecurityException("Only support SecurityTokenReference elements with wsse:Reference children");
            }
            foundRef = true;
            this.mRef = new Reference(refE);
        }
        if (!foundRef) {
            throw new WSSecurityException("Only support SecurityTokenReference elements with wsse:Reference children");
        }
    }

    public SecurityTokenReference(Reference ref) {
        this.mRef = ref;
    }

    public Reference getReference() {
        return this.mRef;
    }

    public Element getElement(Document doc) {
        Element e = WSSecITUtil.createElementInWSSecNamespace(doc, "SecurityTokenReference");
        e.appendChild(this.mRef.getElement(doc));
        return e;
    }
}

