/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit.encoding;

import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.xml.security.Init;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.soton.itinnovation.wssecit.WSSecITUtil;
import uk.ac.soton.itinnovation.wssecit.encoding.BinarySecurityToken;
import uk.ac.soton.itinnovation.wssecit.encoding.SecurityToken;
import uk.ac.soton.itinnovation.wssecit.encoding.WSSecHeader;

public class TestWSSecHeader
extends TestCase {
    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.wssecit.encoding.TestWSSecHeader");
    static /* synthetic */ Class class$uk$ac$soton$itinnovation$wssecit$encoding$TestWSSecHeader;

    public TestWSSecHeader(String s) {
        super(s);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestWSSecHeader.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(class$uk$ac$soton$itinnovation$wssecit$encoding$TestWSSecHeader == null ? (class$uk$ac$soton$itinnovation$wssecit$encoding$TestWSSecHeader = TestWSSecHeader.class$("uk.ac.soton.itinnovation.wssecit.encoding.TestWSSecHeader")) : class$uk$ac$soton$itinnovation$wssecit$encoding$TestWSSecHeader);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testPrependSecurityToken() {
        try {
            BinarySecurityToken binToken = new BinarySecurityToken("binaryToken", "wsse:Base64Binary", "wsse:X509v3", "MIIEZDLSIFHSH..");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element headerE = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
            WSSecHeader header = new WSSecHeader(headerE, "http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV");
            header.prependSecurityToken(binToken);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (out == null) {
                System.out.println("Output is null");
            }
            WSSecITUtil.serializeDocument(out, doc);
            mLogger.log(Level.INFO, new String(out.toByteArray()));
            SecurityToken[] tokens = header.getOrderedSecurityTokens();
            if (tokens.length != 1) {
                TestWSSecHeader.fail((String)"Incorrect token number exists");
            }
            System.out.println("Retrieved Token of Type: " + tokens[0].getType());
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "Test Failed", ex);
            TestWSSecHeader.fail();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Init.init();
    }
}

