/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit.encoding;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.w3c.dom.Document;
import uk.ac.soton.itinnovation.wssecit.WSSecITUtil;
import uk.ac.soton.itinnovation.wssecit.encoding.BinarySecurityToken;
import uk.ac.soton.itinnovation.wssecit.encoding.WSSecHeader;
import uk.ac.soton.itinnovation.wssecit.encoding.WSSecSOAPMessage;

public class TestWSSecSOAPMessage
extends TestCase {
    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.wssecit.encoding.TestWSSecSOAPMessage");
    private static final String SOAP_MSG_FILE = "test/unit/java/uk/ac/soton/itinnovation/wssecit/encoding/soap.xml";
    private static final String ACTOR = "http://localhost:8080/axis/services/TestService";
    static /* synthetic */ Class class$uk$ac$soton$itinnovation$wssecit$encoding$TestWSSecSOAPMessage;

    public TestWSSecSOAPMessage(String s) {
        super(s);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestWSSecSOAPMessage.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(class$uk$ac$soton$itinnovation$wssecit$encoding$TestWSSecSOAPMessage == null ? (class$uk$ac$soton$itinnovation$wssecit$encoding$TestWSSecSOAPMessage = TestWSSecSOAPMessage.class$("uk.ac.soton.itinnovation.wssecit.encoding.TestWSSecSOAPMessage")) : class$uk$ac$soton$itinnovation$wssecit$encoding$TestWSSecSOAPMessage);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testCreateEmptyWSSecurityHeader() {
        try {
            FileInputStream inStream = new FileInputStream(SOAP_MSG_FILE);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inStream);
            WSSecSOAPMessage wsSOAPMsg = new WSSecSOAPMessage(doc);
            WSSecHeader secHeader = wsSOAPMsg.createEmptyWSSecurityHeader(ACTOR);
            BinarySecurityToken binToken = new BinarySecurityToken("binaryToken", "wsse:Base64Binary", "wsse:X509v3", "MIIEZDLSIFHSH..");
            secHeader.prependSecurityToken(binToken);
            String actorURI = secHeader.getActor();
            if (actorURI == null || !actorURI.equals(ACTOR)) {
                mLogger.log(Level.SEVERE, "Test Failed since actor uris don't match");
                TestWSSecSOAPMessage.fail();
            }
            if (!((BinarySecurityToken)secHeader.getOrderedSecurityTokens()[0]).getId().equals("binaryToken")) {
                mLogger.log(Level.SEVERE, "Test failed since security token ids don't match");
                TestWSSecSOAPMessage.fail();
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            WSSecITUtil.serializeDocument(out, doc);
            mLogger.log(Level.INFO, new String(out.toByteArray()));
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "Test Failed", ex);
            TestWSSecSOAPMessage.fail();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

