/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit.encoding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import uk.ac.soton.itinnovation.wssecit.WSSecITUtil;
import uk.ac.soton.itinnovation.wssecit.WSSecurityException;
import uk.ac.soton.itinnovation.wssecit.encoding.BinarySecurityToken;
import uk.ac.soton.itinnovation.wssecit.encoding.SecurityToken;
import uk.ac.soton.itinnovation.wssecit.signatures.WSSecXMLSignature;

public class WSSecHeader {
    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.wssecit.encoding.WSSecHeader");
    private Element mHeaderElement;
    private String mSOAPEnvNamespaceURI;
    private String mSOAPEnvNamespacePrefix;
    private Map mAttachmentMap;

    public WSSecHeader(Element e, String SOAPEnvelopeNamespaceURI, String SOAPEnvelopeNamespacePrefix) {
        this.mHeaderElement = e;
        this.mSOAPEnvNamespaceURI = SOAPEnvelopeNamespaceURI;
        this.mSOAPEnvNamespacePrefix = SOAPEnvelopeNamespacePrefix;
    }

    public String getActor() throws WSSecurityException {
        String actor = this.mHeaderElement.getAttributeNS(this.mSOAPEnvNamespaceURI, "actor");
        if (actor != null && actor.equals("")) {
            return null;
        }
        return actor;
    }

    public synchronized void setActor(String actor) {
        Document parentDoc = this.mHeaderElement.getOwnerDocument();
        Attr att = parentDoc.createAttributeNS(this.mSOAPEnvNamespaceURI, "actor");
        att.setNodeValue(actor);
        this.mHeaderElement.setAttributeNodeNS(att);
    }

    public boolean mustUnderstand() {
        boolean mustUnderstand = true;
        String val = this.mHeaderElement.getAttributeNS(this.mSOAPEnvNamespaceURI, this.mSOAPEnvNamespacePrefix + ":" + "mustUnderstand");
        mustUnderstand = val == null ? false : Boolean.getBoolean(val);
        return mustUnderstand;
    }

    public synchronized void setMustUnderstand(boolean value) {
        Document doc = this.mHeaderElement.getOwnerDocument();
        Attr roleAtt = doc.createAttributeNS(this.mSOAPEnvNamespaceURI, this.mSOAPEnvNamespacePrefix + ":" + "mustUnderstand");
        if (value) {
            roleAtt.setNodeValue("true");
        } else {
            roleAtt.setNodeValue("false");
        }
        this.mHeaderElement.setAttributeNodeNS(roleAtt);
    }

    public synchronized void prependSecurityToken(SecurityToken token) throws WSSecurityException {
        Element SOAPe = this.createSecurityTokenSOAPElement(token);
        NodeList children = this.mHeaderElement.getChildNodes();
        int numberChildren = children.getLength();
        ArrayList<Node> childElements = new ArrayList<Node>();
        for (int i = 0; i < numberChildren; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            childElements.add(node);
        }
        if (childElements.size() == 0) {
            this.mHeaderElement.appendChild(SOAPe);
        } else {
            Iterator iterator = childElements.iterator();
            while (iterator.hasNext()) {
                this.mHeaderElement.removeChild((Node)iterator.next());
            }
            this.mHeaderElement.appendChild(SOAPe);
            iterator = childElements.iterator();
            while (iterator.hasNext()) {
                this.mHeaderElement.appendChild((Node)iterator.next());
            }
        }
    }

    public SecurityToken[] getOrderedSecurityTokens() throws WSSecurityException {
        NodeList nodeList = this.mHeaderElement.getChildNodes();
        int nodeNumber = nodeList.getLength();
        ArrayList<SecurityToken> tokenList = new ArrayList<SecurityToken>();
        for (int i = 0; i < nodeNumber; ++i) {
            Element e;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(e = (Element)node).getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") || !e.getTagName().equals("wsse:BinarySecurityToken")) continue;
            tokenList.add(this.retrieveSecurityTokenFromSOAPElement(e));
        }
        SecurityToken[] tokens = new SecurityToken[tokenList.size()];
        int index = 0;
        Iterator iterator = tokenList.iterator();
        while (iterator.hasNext()) {
            tokens[index++] = (SecurityToken)iterator.next();
        }
        return tokens;
    }

    public synchronized void prependXMLSignature(WSSecXMLSignature signature) throws WSSecurityException {
        Element SOAPe = this.createXMLSignatureSOAPElement(signature);
        NodeList children = this.mHeaderElement.getChildNodes();
        int numberChildren = children.getLength();
        ArrayList<Node> childElements = new ArrayList<Node>();
        for (int i = 0; i < numberChildren; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            childElements.add(node);
        }
        if (childElements.size() == 0) {
            this.mHeaderElement.appendChild(SOAPe);
        } else {
            Iterator iterator = childElements.iterator();
            while (iterator.hasNext()) {
                this.mHeaderElement.removeChild((Node)iterator.next());
            }
            this.mHeaderElement.appendChild(SOAPe);
            iterator = childElements.iterator();
            while (iterator.hasNext()) {
                this.mHeaderElement.appendChild((Node)iterator.next());
            }
        }
    }

    public WSSecXMLSignature[] getOrderedXMLSignatures() throws WSSecurityException {
        NodeList nodeList = this.mHeaderElement.getChildNodes();
        int nodeNumber = nodeList.getLength();
        ArrayList<WSSecXMLSignature> signatureList = new ArrayList<WSSecXMLSignature>();
        for (int i = 0; i < nodeNumber; ++i) {
            Element e;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(e = (Element)node).getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || !e.getTagName().equals("ds:Signature")) continue;
            signatureList.add(this.retrieveXMLSignatureFromSOAPElement(e));
        }
        int index = 0;
        Iterator iterator = signatureList.iterator();
        WSSecXMLSignature[] signatures = new WSSecXMLSignature[signatureList.size()];
        while (iterator.hasNext()) {
            signatures[index++] = (WSSecXMLSignature)iterator.next();
        }
        return signatures;
    }

    public void associatedWithAttachmentMap(Map attachmentMap) {
        this.mAttachmentMap = attachmentMap;
    }

    private Element createSecurityTokenSOAPElement(SecurityToken token) throws WSSecurityException {
        BinarySecurityToken binToken;
        Element binE = null;
        if (token.getType() == 0) {
            mLogger.log(Level.SEVERE, "Trying to add a username security token but they are not yet supported");
            throw new WSSecurityException("Trying to add a username security token but they are not yet supported");
        }
        if (token.getType() == 1) {
            binToken = (BinarySecurityToken)token;
            if (!binToken.getValueType().equals("wsse:X509v3")) {
                mLogger.log(Level.SEVERE, "Trying to add a binary security token with value type '" + binToken.getValueType() + "' but they are not yet supported");
                throw new WSSecurityException("Trying to add a binary security token with value type '" + binToken.getValueType() + "' but they are not yet supported");
            }
        } else {
            mLogger.log(Level.SEVERE, "Trying to add a security token that is not yet supported");
            throw new WSSecurityException("Trying to add a security token that is not yet supported");
        }
        Document doc = this.mHeaderElement.getOwnerDocument();
        binE = WSSecITUtil.createElementInWSSecNamespace(doc, "BinarySecurityToken");
        WSSecITUtil.setAttributeInWSUtilNamespace(binE, "Id", binToken.getId());
        WSSecITUtil.setAttributeInWSSecNamespace(binE, "EncodingType", binToken.getEncodingStyle());
        WSSecITUtil.setAttributeInWSSecNamespace(binE, "ValueType", binToken.getValueType());
        Text content = doc.createTextNode(binToken.getEncodedData());
        binE.appendChild(content);
        return binE;
    }

    private SecurityToken retrieveSecurityTokenFromSOAPElement(Element e) throws WSSecurityException {
        Attr IdAtt = e.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (IdAtt == null) {
            mLogger.log(Level.SEVERE, "Could not retrieve Id attribute from binary security token");
            throw new WSSecurityException("Unable to retrieve a binary security token because part of the serialised form is missing");
        }
        Attr encAtt = e.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "EncodingType");
        if (encAtt == null) {
            mLogger.log(Level.SEVERE, "Could not retrieve EncodingStyle attribute from binary security token");
            throw new WSSecurityException("Unable to retrieve a binary security token because part of the serialised form is missing");
        }
        Attr valTypeAtt = e.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "ValueType");
        if (encAtt == null) {
            mLogger.log(Level.SEVERE, "Could not retrieve ValueType attribute from binary security token");
            throw new WSSecurityException("Unable to retrieve a binary security token because part of the serialised form is missing");
        }
        NodeList children = e.getChildNodes();
        int childrenNumber = children.getLength();
        CharacterData content = null;
        for (int j = 0; j < childrenNumber; ++j) {
            Node node = children.item(j);
            if (node.getNodeType() != 3) continue;
            content = (Text)node;
            break;
        }
        return new BinarySecurityToken(IdAtt.getValue(), encAtt.getValue(), valTypeAtt.getValue(), content.getData());
    }

    private Element createXMLSignatureSOAPElement(WSSecXMLSignature signature) {
        return signature.getSignatureElement();
    }

    private WSSecXMLSignature retrieveXMLSignatureFromSOAPElement(Element e) throws WSSecurityException {
        if (this.mAttachmentMap == null) {
            return new WSSecXMLSignature(e);
        }
        return new WSSecXMLSignature(e, this.mAttachmentMap);
    }
}

