/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit.encoding;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.soton.itinnovation.wssecit.WSSecITUtil;
import uk.ac.soton.itinnovation.wssecit.WSSecurityException;
import uk.ac.soton.itinnovation.wssecit.encoding.InvalidWSSecurityEncodingException;
import uk.ac.soton.itinnovation.wssecit.encoding.WSSecHeader;

public class WSSecSOAPMessage {
    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.wssecit.encoding.WSSecSOAPMessage");
    private Document mSOAPEnvelope;
    private Element mSOAPHeader;
    private List mWSSecHeaderElements;
    private String mSOAPEnvelopeNamespaceURI;
    private String mSOAPEnvelopeNamespacePrefix;
    private Map mAttachmentMap;

    public WSSecSOAPMessage(Document soapEnvelope) throws WSSecurityException {
        this.initialise(soapEnvelope);
    }

    public WSSecSOAPMessage(Document soapEnvelope, Map attachmentMap) throws WSSecurityException {
        this.initialise(soapEnvelope);
        this.mAttachmentMap = attachmentMap;
    }

    public Document getSOAPMessage() {
        return this.mSOAPEnvelope;
    }

    public void release() {
        this.mSOAPEnvelope = null;
        this.mSOAPHeader = null;
        this.mWSSecHeaderElements = null;
    }

    public String getSOAPEnvelopeNamespaceURI() {
        return this.mSOAPEnvelopeNamespaceURI;
    }

    public String getSOAPEnvelopeNamespacePrefix() {
        return this.mSOAPEnvelopeNamespacePrefix;
    }

    public synchronized WSSecHeader createEmptyWSSecurityHeader() throws InvalidWSSecurityEncodingException {
        if (this.mSOAPHeader == null) {
            this.setSOAPHeader();
        }
        Element[] WSSecHeaders = this.getSecurityHeaderElements();
        for (int i = 0; i < WSSecHeaders.length; ++i) {
            if (WSSecHeaders[i].getAttributeNS(this.mSOAPEnvelopeNamespaceURI, "actor") == null) continue;
            throw new InvalidWSSecurityEncodingException("You have tried to create WS-Security header element without a role but a header without a role already exists");
        }
        Element headerElement = this.createEmptyHeader();
        this.addToHeaderElements(headerElement);
        WSSecHeader header = new WSSecHeader(headerElement, this.mSOAPEnvelopeNamespaceURI, this.mSOAPEnvelopeNamespacePrefix);
        if (this.mAttachmentMap != null) {
            header.associatedWithAttachmentMap(this.mAttachmentMap);
        }
        return header;
    }

    public synchronized WSSecHeader createEmptyWSSecurityHeader(String actor) throws WSSecurityException {
        if (this.mSOAPHeader == null) {
            this.setSOAPHeader();
        }
        Element[] WSSecHeaders = this.getSecurityHeaderElements();
        for (int i = 0; i < WSSecHeaders.length; ++i) {
            if (!WSSecHeaders[i].getAttributeNS(this.mSOAPEnvelopeNamespaceURI, "actor").equals(actor)) continue;
            throw new InvalidWSSecurityEncodingException("You have tried to create WS-Security header element with the actor '" + actor + "' but a header with a matching role already exists");
        }
        Element headerElement = this.createEmptyHeader(actor);
        this.addToHeaderElements(headerElement);
        WSSecHeader header = new WSSecHeader(headerElement, this.mSOAPEnvelopeNamespaceURI, this.mSOAPEnvelopeNamespacePrefix);
        if (this.mAttachmentMap != null) {
            header.associatedWithAttachmentMap(this.mAttachmentMap);
        }
        return header;
    }

    public WSSecHeader[] getWSSecurityHeaders() throws WSSecurityException {
        WSSecHeader[] headers = null;
        if (this.mWSSecHeaderElements == null) {
            headers = new WSSecHeader[]{};
        } else {
            headers = new WSSecHeader[this.mWSSecHeaderElements.size()];
            Iterator iterator = this.mWSSecHeaderElements.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                WSSecHeader header = new WSSecHeader((Element)iterator.next(), this.mSOAPEnvelopeNamespaceURI, this.mSOAPEnvelopeNamespacePrefix);
                if (this.mAttachmentMap != null) {
                    header.associatedWithAttachmentMap(this.mAttachmentMap);
                }
                headers[index++] = header;
            }
        }
        return headers;
    }

    public WSSecHeader[] getWSSecurityHeaders(String role) throws WSSecurityException {
        ArrayList<WSSecHeader> matchingHeaders = new ArrayList<WSSecHeader>();
        WSSecHeader header = null;
        if (this.mWSSecHeaderElements == null) {
            mLogger.log(Level.SEVERE, "There are no WS-Security headers defined, the message is not secure and should be rejected");
            throw new WSSecurityException("There are no WS-Security headers defined, the message is not secure and should be rejected");
        }
        Iterator iterator = this.mWSSecHeaderElements.iterator();
        boolean matchedRole = false;
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            String roleAttrVal = e.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor");
            if (!roleAttrVal.equals(role)) continue;
            header = new WSSecHeader(e, this.mSOAPEnvelopeNamespaceURI, this.mSOAPEnvelopeNamespacePrefix);
            if (this.mAttachmentMap != null) {
                header.associatedWithAttachmentMap(this.mAttachmentMap);
            }
            matchingHeaders.add(header);
            matchedRole = true;
        }
        if (!matchedRole) {
            mLogger.log(Level.SEVERE, "Failed to find security header associated with role '" + role + "'");
            throw new WSSecurityException("Failed to find security header associated with role '" + role + "'");
        }
        WSSecHeader[] headers = new WSSecHeader[matchingHeaders.size()];
        iterator = matchingHeaders.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            headers[index] = (WSSecHeader)iterator.next();
            ++index;
        }
        return headers;
    }

    private void initialise(Document soapEnvelope) throws WSSecurityException {
        try {
            Init.init();
            Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
            ByteArrayInputStream bais = new ByteArrayInputStream(canonicalizer.canonicalizeSubtree((Node)soapEnvelope));
            InputSource in = new InputSource(bais);
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            dfactory.setValidating(false);
            DocumentBuilder db = dfactory.newDocumentBuilder();
            this.mSOAPEnvelope = db.parse(in);
        }
        catch (InvalidCanonicalizerException ex) {
            mLogger.log(Level.SEVERE, "Unable to create WS-Security message.", ex);
            throw new WSSecurityException("Unable to create WS-Security message, please consult logs");
        }
        catch (CanonicalizationException ex) {
            mLogger.log(Level.SEVERE, "Unable to create WS-Security message.", ex);
            throw new WSSecurityException("Unable to create WS-Security message, please consult logs");
        }
        catch (ParserConfigurationException ex) {
            mLogger.log(Level.SEVERE, "Unable to create WS-Security message.", ex);
            throw new WSSecurityException("Unable to create WS-Security message, please consult logs");
        }
        catch (IOException ex) {
            mLogger.log(Level.SEVERE, "Unable to create WS-Security message.", ex);
            throw new WSSecurityException("Unable to create WS-Security message, please consult logs");
        }
        catch (SAXException ex) {
            mLogger.log(Level.SEVERE, "Unable to create WS-Security message.", ex);
            throw new WSSecurityException("Unable to create WS-Security message, please consult logs");
        }
        this.verifyAndInitSOAPEnvelope(this.mSOAPEnvelope);
        if (this.isSecured(this.mSOAPEnvelope)) {
            mLogger.log(Level.INFO, "Message is secured using WS-Security");
            this.loadSecureSOAPEnvelope(this.mSOAPEnvelope);
        } else {
            mLogger.log(Level.INFO, "Message is not secured using WS-Security");
        }
    }

    private void setSOAPHeader() throws InvalidWSSecurityEncodingException {
        NodeList nodeList = this.mSOAPEnvelope.getElementsByTagName(this.mSOAPEnvelopeNamespacePrefix + ":" + "Header");
        int numberHeaders = nodeList.getLength();
        if (numberHeaders == 0) {
            nodeList = this.mSOAPEnvelope.getElementsByTagName(this.mSOAPEnvelopeNamespacePrefix + ":" + "Header");
        }
        if (numberHeaders == 0) {
            this.mSOAPHeader = this.mSOAPEnvelope.createElementNS(this.mSOAPEnvelopeNamespaceURI, this.mSOAPEnvelopeNamespacePrefix + ":" + "Header");
            this.mSOAPEnvelope.getDocumentElement().appendChild(this.mSOAPHeader);
        } else if (numberHeaders == 1) {
            this.mSOAPHeader = (Element)nodeList.item(0);
        } else {
            mLogger.log(Level.SEVERE, "The passed SOAP Envelope object has more than one header element, which is not allowed");
            throw new InvalidWSSecurityEncodingException("The passed SOAP Envelope object has more than one header element, which is not allowed");
        }
    }

    private void addToHeaderElements(Element headerE) {
        this.mSOAPHeader.appendChild(headerE);
    }

    private Element[] getSecurityHeaderElements() {
        Element[] elements = null;
        NodeList nodeList = this.mSOAPHeader.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        int length = nodeList.getLength();
        elements = new Element[length];
        for (int i = 0; i < length; ++i) {
            elements[i] = (Element)nodeList.item(i);
        }
        return elements;
    }

    private Element createEmptyHeader() {
        Element e = WSSecITUtil.createElementInWSSecNamespace(this.mSOAPEnvelope, "Security");
        this.mSOAPHeader.appendChild(e);
        return e;
    }

    private Element createEmptyHeader(String role) throws WSSecurityException {
        Element e = WSSecITUtil.createElementInWSSecNamespace(this.mSOAPEnvelope, "Security");
        WSSecITUtil.setAttributeInSOAP11Namespace(e, this.mSOAPEnvelopeNamespacePrefix, "actor", role);
        this.mSOAPHeader.appendChild(e);
        return e;
    }

    private boolean isSecured(Document soapMessage) {
        Element soapEnv = soapMessage.getDocumentElement();
        NodeList nodeList = soapEnv.getChildNodes();
        NodeList headerList = soapEnv.getElementsByTagName(this.mSOAPEnvelopeNamespacePrefix + ":" + "Header");
        return headerList.getLength() == 1 && ((Element)headerList.item(0)).getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security").getLength() != 0;
    }

    private void loadSecureSOAPEnvelope(Document soapMessage) throws WSSecurityException {
        Element soapEnv = soapMessage.getDocumentElement();
        NodeList nodeList = soapEnv.getChildNodes();
        NodeList headerList = soapEnv.getElementsByTagName(this.mSOAPEnvelopeNamespacePrefix + ":" + "Header");
        Element headerE = (Element)headerList.item(0);
        if (headerE != null) {
            NodeList wsSecNodeList = headerE.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
            if (wsSecNodeList.getLength() == 0) {
                mLogger.log(Level.SEVERE, "An apparent secured message has no security headers");
                throw new WSSecurityException("An apparent secured message has no security headers");
            }
            for (int j = 0; j < wsSecNodeList.getLength(); ++j) {
                if (this.mWSSecHeaderElements == null) {
                    this.mWSSecHeaderElements = new ArrayList();
                }
                this.mWSSecHeaderElements.add(wsSecNodeList.item(j));
            }
        } else {
            mLogger.log(Level.SEVERE, "Could not obtain header element for SOAP message");
            throw new WSSecurityException("Could not obtain header element for SOAP message");
        }
    }

    private void verifyAndInitSOAPEnvelope(Document soapMessage) throws WSSecurityException {
        Element rootE = soapMessage.getDocumentElement();
        this.mSOAPEnvelopeNamespaceURI = rootE.getNamespaceURI();
        this.mSOAPEnvelopeNamespacePrefix = rootE.getPrefix();
        if (!rootE.getTagName().equals(this.mSOAPEnvelopeNamespacePrefix + ":" + "Envelope")) {
            mLogger.log(Level.SEVERE, "Supplied SOAP Message does not contain a SOAP Envelope, in contrast the root element is '" + rootE.getTagName() + "'");
            throw new WSSecurityException("Supplied SOAP Message does not contain a SOAP Envelope");
        }
    }

    private void circumventBug2650(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            int attributesLength = attributes.getLength();
            NodeList children = element.getChildNodes();
            int childrenLength = children.getLength();
            for (int j = 0; j < childrenLength; ++j) {
                Node child = children.item(j);
                if (child.getNodeType() != 1) continue;
                Element childElement = (Element)child;
                for (int i = 0; i < attributesLength; ++i) {
                    boolean mustBeDefinedInChild;
                    Attr currentAttr = (Attr)attributes.item(i);
                    boolean isNamespace = "http://www.w3.org/2000/xmlns/".equals(currentAttr.getNamespaceURI());
                    if (!isNamespace) continue;
                    boolean bl = mustBeDefinedInChild = !childElement.hasAttributeNS("http://www.w3.org/2000/xmlns/", currentAttr.getLocalName());
                    if (!mustBeDefinedInChild) continue;
                    childElement.setAttributeNS("http://www.w3.org/2000/xmlns/", currentAttr.getName(), currentAttr.getNodeValue());
                }
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: 
                case 5: 
                case 9: {
                    this.circumventBug2650(child);
                }
            }
        }
    }
}

