/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit.policy;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.ac.soton.itinnovation.wssecit.WSSecurityException;
import uk.ac.soton.itinnovation.wssecit.encoding.BinarySecurityToken;
import uk.ac.soton.itinnovation.wssecit.encoding.WSSecHeader;
import uk.ac.soton.itinnovation.wssecit.encoding.WSSecSOAPMessage;
import uk.ac.soton.itinnovation.wssecit.policy.PolicyEnforcer;
import uk.ac.soton.itinnovation.wssecit.policy.WSSecPolicyException;
import uk.ac.soton.itinnovation.wssecit.signatures.WSSecX509TrustManager;
import uk.ac.soton.itinnovation.wssecit.signatures.WSSecXMLSignature;

public class BasicBodyX509PolicyEnforcer
implements PolicyEnforcer {
    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.wssecit.policy.BasicBodyX509PolicyEnforcer");
    private PrivateKey mPrivateKey;
    private X509Certificate mCert;
    private WSSecX509TrustManager mTrustManager;
    private String mActorURI;

    public BasicBodyX509PolicyEnforcer(String soapActorURI, PrivateKey privateKey, X509Certificate cert) {
        this.mPrivateKey = privateKey;
        this.mCert = cert;
        this.mActorURI = soapActorURI;
    }

    public BasicBodyX509PolicyEnforcer(String soapActorURI, WSSecX509TrustManager trustManager) {
        this.mActorURI = soapActorURI;
        this.mTrustManager = trustManager;
    }

    public Document enforce(Document originalSOAPMsg) throws WSSecurityException {
        return this.enforceMsg(originalSOAPMsg, null);
    }

    public Document enforce(Document originalSOAPMsg, Map attachmentMap) throws WSSecurityException {
        return this.enforceMsg(originalSOAPMsg, attachmentMap);
    }

    public boolean process(Document originalSOAPMsg, Map attachmentMap) throws WSSecurityException {
        return this.processMsg(originalSOAPMsg, attachmentMap);
    }

    public boolean process(Document securedSOAPMsg) throws WSSecurityException {
        return this.processMsg(securedSOAPMsg, null);
    }

    private Document enforceMsg(Document originalSOAPMsg, Map attachmentMap) throws WSSecurityException {
        try {
            if (this.mPrivateKey == null) {
                mLogger.log(Level.SEVERE, "Unable to enforce message security policy because do not have a suitable private key");
                throw new WSSecPolicyException("Unable to enforce message security policy because do not have a suitable private key");
            }
            if (this.mCert == null) {
                mLogger.log(Level.SEVERE, "Unable to enforce message security policy because do not have a suitable X509 certificate");
                throw new WSSecPolicyException("Unable to enforce message security policy because do not have a suitable X509 certificate");
            }
            WSSecSOAPMessage wsSOAPMsg = null;
            wsSOAPMsg = attachmentMap != null ? new WSSecSOAPMessage(originalSOAPMsg, attachmentMap) : new WSSecSOAPMessage(originalSOAPMsg);
            WSSecHeader[] secHeaders = wsSOAPMsg.getWSSecurityHeaders();
            WSSecHeader secHeader = null;
            secHeader = secHeaders.length == 0 ? wsSOAPMsg.createEmptyWSSecurityHeader(this.mActorURI) : secHeaders[0];
            Base64 encoder = new Base64();
            String encodedData = new String(Base64.encode((byte[])this.mCert.getEncoded()));
            BinarySecurityToken binToken = new BinarySecurityToken("X509CertBinaryToken", "wsse:Base64Binary", "wsse:X509v3", encodedData);
            secHeader.prependSecurityToken(binToken);
            Element rootE = wsSOAPMsg.getSOAPMessage().getDocumentElement();
            NodeList nodeList = rootE.getElementsByTagNameNS(wsSOAPMsg.getSOAPEnvelopeNamespaceURI(), "Body");
            Element elementToSign = (Element)nodeList.item(0);
            if (elementToSign == null) {
                mLogger.log(Level.SEVERE, "Unable to find the Body element within the SOAP message as target for signing");
                throw new WSSecPolicyException("Unable to find the Body element within the SOAP message as target for signing");
            }
            WSSecXMLSignature xmlSignature = null;
            xmlSignature = attachmentMap != null ? new WSSecXMLSignature(wsSOAPMsg.getSOAPMessage(), elementToSign, binToken, attachmentMap) : new WSSecXMLSignature(wsSOAPMsg.getSOAPMessage(), elementToSign, binToken);
            secHeader.prependXMLSignature(xmlSignature);
            xmlSignature.sign(this.mPrivateKey);
            return wsSOAPMsg.getSOAPMessage();
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "Unexpected failure whilst attempting to enforce the selected message security policy", ex);
            throw new WSSecPolicyException("Unexpected failure whilst attempting to enforce the selected message security policy", ex);
        }
    }

    private boolean processMsg(Document securedSOAPMsg, Map attachmentMap) throws WSSecurityException {
        if (this.mTrustManager == null) {
            mLogger.log(Level.SEVERE, "Cannot process secured message according to security policy because cannot establish trust");
            throw new WSSecPolicyException("Cannot process secured message according to security policy because cannot establish trust");
        }
        WSSecSOAPMessage wsSOAPMsg = null;
        wsSOAPMsg = attachmentMap != null ? new WSSecSOAPMessage(securedSOAPMsg, attachmentMap) : new WSSecSOAPMessage(securedSOAPMsg);
        WSSecHeader[] secHeaders = wsSOAPMsg.getWSSecurityHeaders();
        if (secHeaders.length == 0) {
            mLogger.log(Level.SEVERE, "Policy expects one security header, but this is not true");
            return false;
        }
        for (int j = 0; j < secHeaders.length; ++j) {
            WSSecXMLSignature[] signatures = secHeaders[j].getOrderedXMLSignatures();
            if (signatures.length == 0) {
                mLogger.log(Level.SEVERE, "Policy expects one signature within the secured message, but this is not true");
                return false;
            }
            for (int i = 0; i < signatures.length; ++i) {
                boolean valid = signatures[i].checkSignatureValue(this.mTrustManager);
                if (valid) continue;
                mLogger.log(Level.SEVERE, "Signature was invalid");
                return false;
            }
        }
        wsSOAPMsg.release();
        wsSOAPMsg = null;
        secHeaders = null;
        return true;
    }
}

