/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit.policy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.w3c.dom.Document;
import uk.ac.soton.itinnovation.wssecit.WSSecITUtil;
import uk.ac.soton.itinnovation.wssecit.policy.BasicBodyX509PolicyEnforcer;
import uk.ac.soton.itinnovation.wssecit.signatures.WSSecX509TrustManager;

public class TestBasicBodyX509PolicyEnforcer
extends TestCase
implements WSSecX509TrustManager {
    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.wssecit.policy.TestBasicBodyX509PolicyEnforcer");
    private static final String SOAP_MSG_FILE = "test/unit/java/uk/ac/soton/itinnovation/wssecit/encoding/soap.xml";
    private static final String SIGNED_SOAP_MSG_FILE = "test/unit/java/uk/ac/soton/itinnovation/wssecit/policy/securedsoap.xml";
    private static final String KEY_STORE_FILE = "test/unit/java/uk/ac/soton/itinnovation/wssecit/signatures/test.keystore.jks";
    private static final String TRUST_STORE_FILE = "test/unit/java/uk/ac/soton/itinnovation/wssecit/signatures/test.truststore.jks";
    private static final String KEYSTORE_PASSWORD = "changeit";
    private static final String PRIVATE_KEY_ALIAS = "mykey";
    private static final String PRIVATE_KEY_PASS = "changeit";
    private static final String SOAP_ACTOR_URI = "http://www.it-innovation.soton.ac.uk/wssecit-processor";
    private static KeyStore mKeystore = null;
    static /* synthetic */ Class class$uk$ac$soton$itinnovation$wssecit$policy$TestBasicBodyX509PolicyEnforcer;

    public TestBasicBodyX509PolicyEnforcer(String s) {
        super(s);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestBasicBodyX509PolicyEnforcer.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(class$uk$ac$soton$itinnovation$wssecit$policy$TestBasicBodyX509PolicyEnforcer == null ? (class$uk$ac$soton$itinnovation$wssecit$policy$TestBasicBodyX509PolicyEnforcer = TestBasicBodyX509PolicyEnforcer.class$("uk.ac.soton.itinnovation.wssecit.policy.TestBasicBodyX509PolicyEnforcer")) : class$uk$ac$soton$itinnovation$wssecit$policy$TestBasicBodyX509PolicyEnforcer);
        return suite;
    }

    protected void setUp() {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(new File(KEY_STORE_FILE));
            mKeystore = KeyStore.getInstance("JKS");
            mKeystore.load(inStream, "changeit".toCharArray());
        }
        catch (IOException ex) {
            mLogger.log(Level.SEVERE, "Unable to find or read keystore file ' test/unit/java/uk/ac/soton/itinnovation/wssecit/signatures/test.truststore.jks'", ex);
            TestBasicBodyX509PolicyEnforcer.fail();
        }
        catch (NoSuchAlgorithmException ex) {
            mLogger.log(Level.SEVERE, "No supported algorithm when loading keystore 'test/unit/java/uk/ac/soton/itinnovation/wssecit/signatures/test.truststore.jks'", ex);
            TestBasicBodyX509PolicyEnforcer.fail();
        }
        catch (KeyStoreException ex) {
            mLogger.log(Level.SEVERE, "Unrecognised keystore failure", ex);
            TestBasicBodyX509PolicyEnforcer.fail();
        }
        catch (CertificateException ex) {
            mLogger.log(Level.SEVERE, "Unrecognised problem with certificate when loading keystore 'test/unit/java/uk/ac/soton/itinnovation/wssecit/signatures/test.truststore.jks'", ex);
            TestBasicBodyX509PolicyEnforcer.fail();
        }
    }

    protected void tearDown() {
    }

    public void testEnforce() {
        try {
            mLogger.log(Level.INFO, "**** Testing policy enforcement ****");
            FileInputStream inStream = new FileInputStream(SOAP_MSG_FILE);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inStream);
            PrivateKey privateKey = (PrivateKey)mKeystore.getKey(PRIVATE_KEY_ALIAS, "changeit".toCharArray());
            X509Certificate cert = (X509Certificate)mKeystore.getCertificate(PRIVATE_KEY_ALIAS);
            BasicBodyX509PolicyEnforcer policyEnforcer = new BasicBodyX509PolicyEnforcer(SOAP_ACTOR_URI, privateKey, cert);
            Document securedMsg = policyEnforcer.enforce(doc);
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "Test Failed", ex);
            TestBasicBodyX509PolicyEnforcer.fail();
        }
    }

    public void testProcess() {
        try {
            mLogger.log(Level.INFO, "**** Testing policy processing ****");
            FileInputStream inStream = new FileInputStream(SIGNED_SOAP_MSG_FILE);
            Document doc = WSSecITUtil.loadDocument(inStream);
            BasicBodyX509PolicyEnforcer policyEnforcer = new BasicBodyX509PolicyEnforcer(SOAP_ACTOR_URI, this);
            boolean valid = policyEnforcer.process(doc);
            if (!valid) {
                mLogger.log(Level.SEVERE, "Signature was not valid and it should be");
                TestBasicBodyX509PolicyEnforcer.fail();
            } else {
                mLogger.log(Level.INFO, "Signature valid, as it should be");
            }
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "Test Failed", ex);
            TestBasicBodyX509PolicyEnforcer.fail();
        }
    }

    public boolean isTrusted(X509Certificate cert) {
        try {
            if (cert == null) {
                TestBasicBodyX509PolicyEnforcer.fail();
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            FileInputStream fIn = new FileInputStream(TRUST_STORE_FILE);
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(fIn, null);
            tmf.init(keystore);
            TrustManager[] tms = tmf.getTrustManagers();
            if (tms.length > 1) {
                TestBasicBodyX509PolicyEnforcer.fail();
            }
            X509TrustManager x509tm = (X509TrustManager)tms[0];
            boolean trusted = false;
            X509Certificate[] certs = new X509Certificate[]{cert};
            x509tm.checkServerTrusted(certs, "RSA");
            return true;
        }
        catch (CertificateException ex) {
            mLogger.log(Level.SEVERE, "Certificate is not trusted", ex);
            return false;
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

