/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit.signatures;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.ac.soton.itinnovation.wssecit.WSSecITUtil;
import uk.ac.soton.itinnovation.wssecit.encoding.BinarySecurityToken;
import uk.ac.soton.itinnovation.wssecit.encoding.WSSecHeader;
import uk.ac.soton.itinnovation.wssecit.encoding.WSSecSOAPMessage;
import uk.ac.soton.itinnovation.wssecit.signatures.WSSecX509TrustManager;
import uk.ac.soton.itinnovation.wssecit.signatures.WSSecXMLSignature;

public class TestWSSecXMLSignature
extends TestCase
implements WSSecX509TrustManager {
    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.wssecit.signatures.TestWSSecXMLSignature");
    private static final String SOAP_MSG_FILE = "test/unit/java/uk/ac/soton/itinnovation/wssecit/encoding/soap.xml";
    private static final String SIGNED_SOAP_MSG_FILE = "test/unit/java/uk/ac/soton/itinnovation/wssecit/encoding/securedsoap.xml";
    private static final String SIGNED_SOAP_MSG_FILE_2 = "test/unit/java/uk/ac/soton/itinnovation/wssecit/encoding/securedsoap2.xml";
    private static final String KEY_STORE_FILE = "test/unit/java/uk/ac/soton/itinnovation/wssecit/signatures/test.keystore.jks";
    private static final String TRUST_STORE_FILE = "test/unit/java/uk/ac/soton/itinnovation/wssecit/signatures/test.truststore.jks";
    private static final String KEYSTORE_PASSWORD = "changeit";
    private static final String PRIVATE_KEY_ALIAS = "mykey";
    private static final String PRIVATE_KEY_PASS = "changeit";
    private static KeyStore mKeystore = null;
    static /* synthetic */ Class class$uk$ac$soton$itinnovation$wssecit$signatures$TestWSSecXMLSignature;

    public TestWSSecXMLSignature(String s) {
        super(s);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestWSSecXMLSignature.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(class$uk$ac$soton$itinnovation$wssecit$signatures$TestWSSecXMLSignature == null ? (class$uk$ac$soton$itinnovation$wssecit$signatures$TestWSSecXMLSignature = TestWSSecXMLSignature.class$("uk.ac.soton.itinnovation.wssecit.signatures.TestWSSecXMLSignature")) : class$uk$ac$soton$itinnovation$wssecit$signatures$TestWSSecXMLSignature);
        return suite;
    }

    protected void setUp() {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(new File(KEY_STORE_FILE));
            mKeystore = KeyStore.getInstance("JKS");
            mKeystore.load(inStream, "changeit".toCharArray());
        }
        catch (IOException ex) {
            mLogger.log(Level.SEVERE, "Unable to find or read keystore file ' test/unit/java/uk/ac/soton/itinnovation/wssecit/signatures/test.truststore.jks'", ex);
            TestWSSecXMLSignature.fail();
        }
        catch (NoSuchAlgorithmException ex) {
            mLogger.log(Level.SEVERE, "No supported algorithm when loading keystore 'test/unit/java/uk/ac/soton/itinnovation/wssecit/signatures/test.truststore.jks'", ex);
            TestWSSecXMLSignature.fail();
        }
        catch (KeyStoreException ex) {
            mLogger.log(Level.SEVERE, "Unrecognised keystore failure", ex);
            TestWSSecXMLSignature.fail();
        }
        catch (CertificateException ex) {
            mLogger.log(Level.SEVERE, "Unrecognised problem with certificate when loading keystore 'test/unit/java/uk/ac/soton/itinnovation/wssecit/signatures/test.truststore.jks'", ex);
            TestWSSecXMLSignature.fail();
        }
    }

    protected void tearDown() {
    }

    public void testSign() {
        try {
            mLogger.log(Level.INFO, "***** Testing Signing *****");
            FileInputStream inStream = new FileInputStream(SOAP_MSG_FILE);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inStream);
            WSSecSOAPMessage wsSOAPMsg = new WSSecSOAPMessage(doc);
            WSSecHeader secHeader = wsSOAPMsg.createEmptyWSSecurityHeader();
            Certificate cert = mKeystore.getCertificate(PRIVATE_KEY_ALIAS);
            Base64 encoder = new Base64();
            String encodedData = new String(Base64.encode((byte[])cert.getEncoded()));
            BinarySecurityToken binToken = new BinarySecurityToken("binaryToken", "wsse:Base64Binary", "wsse:X509v3", encodedData);
            secHeader.prependSecurityToken(binToken);
            Element rootE = wsSOAPMsg.getSOAPMessage().getDocumentElement();
            NodeList nodeList = rootE.getElementsByTagName("SOAP-ENV:Body");
            Element elementToSign = (Element)nodeList.item(0);
            WSSecXMLSignature xmlSignature = new WSSecXMLSignature(wsSOAPMsg.getSOAPMessage(), elementToSign, binToken);
            secHeader.prependXMLSignature(xmlSignature);
            PrivateKey privateKey = (PrivateKey)mKeystore.getKey(PRIVATE_KEY_ALIAS, "changeit".toCharArray());
            xmlSignature.sign(privateKey);
            WSSecSOAPMessage wsSOAPMsg2 = new WSSecSOAPMessage(wsSOAPMsg.getSOAPMessage());
            WSSecHeader[] secHeaders = wsSOAPMsg2.getWSSecurityHeaders();
            for (int j = 0; j < secHeaders.length; ++j) {
                WSSecXMLSignature[] signatures = secHeaders[j].getOrderedXMLSignatures();
                if (signatures.length == 0) {
                    TestWSSecXMLSignature.fail();
                }
                for (int i = 0; i < signatures.length; ++i) {
                    boolean valid = signatures[i].checkSignatureValue(this);
                    if (!valid) {
                        mLogger.log(Level.SEVERE, "Verification fails straight away");
                        TestWSSecXMLSignature.fail();
                        continue;
                    }
                    mLogger.log(Level.INFO, "Verification successful straight away");
                }
            }
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "Test Failed", ex);
            TestWSSecXMLSignature.fail();
        }
    }

    public void testCheckSignatureValue() {
        try {
            mLogger.log(Level.INFO, "***** Testing Verification of Signature *****");
            FileInputStream inStream = new FileInputStream(SIGNED_SOAP_MSG_FILE);
            Document doc = WSSecITUtil.loadDocument(inStream);
            WSSecSOAPMessage wsSOAPMsg = new WSSecSOAPMessage(doc);
            WSSecHeader[] secHeaders = wsSOAPMsg.getWSSecurityHeaders();
            if (secHeaders.length == 0) {
                mLogger.log(Level.INFO, "*** FAILURE: Obtained " + secHeaders.length + " security headers from the messed up message - that is wrong!");
                TestWSSecXMLSignature.fail();
            }
            for (int j = 0; j < secHeaders.length; ++j) {
                WSSecXMLSignature[] signatures = secHeaders[j].getOrderedXMLSignatures();
                if (signatures.length == 0) {
                    TestWSSecXMLSignature.fail();
                }
                for (int i = 0; i < signatures.length; ++i) {
                    boolean valid = signatures[i].checkSignatureValue(this);
                    if (!valid) {
                        mLogger.log(Level.SEVERE, "Signature was not valid and it should be");
                        TestWSSecXMLSignature.fail();
                        continue;
                    }
                    mLogger.log(Level.INFO, "Signature valid, as it should be");
                }
            }
            mLogger.log(Level.INFO, "Checking that messing up the signature leads to invalid signature");
            inStream = new FileInputStream(SIGNED_SOAP_MSG_FILE_2);
            doc = WSSecITUtil.loadDocument(inStream);
            WSSecSOAPMessage wsSOAPMsg2 = new WSSecSOAPMessage(doc);
            secHeaders = wsSOAPMsg2.getWSSecurityHeaders();
            if (secHeaders.length == 0) {
                mLogger.log(Level.INFO, "*** FAILURE: Obtained " + secHeaders.length + " security headers from the messed up message - that is wrong!");
                TestWSSecXMLSignature.fail();
            }
            for (int j = 0; j < secHeaders.length; ++j) {
                WSSecXMLSignature[] signatures = secHeaders[j].getOrderedXMLSignatures();
                if (signatures.length == 0) {
                    TestWSSecXMLSignature.fail();
                }
                for (int i = 0; i < signatures.length; ++i) {
                    boolean valid = signatures[i].checkSignatureValue(this);
                    if (!valid) {
                        mLogger.log(Level.INFO, "Signature was not valid but that is as actually correct!");
                        continue;
                    }
                    mLogger.log(Level.SEVERE, "Signature valid, it should not be");
                    TestWSSecXMLSignature.fail();
                }
            }
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "Test Failed", ex);
            TestWSSecXMLSignature.fail();
        }
    }

    public boolean isTrusted(X509Certificate cert) {
        try {
            if (cert == null) {
                TestWSSecXMLSignature.fail();
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            FileInputStream fIn = new FileInputStream(TRUST_STORE_FILE);
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(fIn, null);
            tmf.init(keystore);
            TrustManager[] tms = tmf.getTrustManagers();
            if (tms.length > 1) {
                TestWSSecXMLSignature.fail();
            }
            X509TrustManager x509tm = (X509TrustManager)tms[0];
            boolean trusted = false;
            X509Certificate[] certs = new X509Certificate[]{cert};
            x509tm.checkServerTrusted(certs, "RSA");
            return true;
        }
        catch (CertificateException ex) {
            mLogger.log(Level.SEVERE, "Certificate is not trusted", ex);
            return false;
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

