/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit.signatures;

import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.soton.itinnovation.wssecit.WSSecurityException;
import uk.ac.soton.itinnovation.wssecit.encoding.BinarySecurityToken;

public class WSSecKeyResolver
extends KeyResolverSpi {
    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.wssecit.signatures.WSSecKeyResolver");
    private NodeList mSecurityTokenReferences;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        try {
            Element nscontext = XMLUtils.createDSctx((Document)element.getOwnerDocument(), (String)"wsse", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            this.mSecurityTokenReferences = XPathAPI.selectNodeList((Node)element, (String)"//wsse:SecurityTokenReference", (Node)nscontext);
            if (this.mSecurityTokenReferences != null && this.mSecurityTokenReferences.getLength() > 0) {
                mLogger.log(Level.INFO, "WSSecKeyResolver can resolve KeyInfo information");
                return true;
            }
            mLogger.log(Level.INFO, "WSSecKeyResolver cannot resolve KeyInfo information");
            return false;
        }
        catch (TransformerException ex) {
            mLogger.log(Level.WARNING, "Failed to find out if can handle KeyInfo element", ex);
            return false;
        }
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        PublicKey pubKey;
        X509Certificate cert = this.engineResolveX509Certificate(element, BaseURI, storage);
        if (cert != null && (pubKey = cert.getPublicKey()) != null) {
            return pubKey;
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = null;
        try {
            if (this.engineCanResolve(element, BaseURI, storage)) {
                mLogger.log(Level.INFO, "Trying to resolve certificate using WSSecKeyResolver");
                int numberOfReferences = this.mSecurityTokenReferences.getLength();
                for (int i = 0; i < numberOfReferences; ++i) {
                    Element e = (Element)this.mSecurityTokenReferences.item(i);
                    Element refE = null;
                    NodeList eChildren = e.getChildNodes();
                    int childNumber = eChildren.getLength();
                    for (int j = 0; j < childNumber; ++j) {
                        Element ePos;
                        Node node = eChildren.item(j);
                        if (node.getNodeType() != 1 || !(ePos = (Element)node).getTagName().equals("wsse:Reference")) continue;
                        refE = ePos;
                    }
                    if (refE == null) {
                        mLogger.log(Level.SEVERE, "KeyInfo element does not contain any wsse:Reference elements");
                        throw new KeyResolverException("Unable to obtain true security tokens from references");
                    }
                    String refURI = refE.getAttribute("URI");
                    if (!refURI.startsWith("#")) {
                        mLogger.log(Level.SEVERE, "Only support wsse:References attribute value that point to the current document by starting with '#'");
                        throw new KeyResolverException("Unable to obtain true security tokens from references");
                    }
                    String Id = refURI.substring(1, refURI.length());
                    Document doc = e.getOwnerDocument();
                    Element nscontext = XMLUtils.createDSctx((Document)element.getOwnerDocument(), (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                    NodeList securityTokenList = XPathAPI.selectNodeList((Node)doc, (String)("//*[@wsu:Id='" + Id + "']"), (Node)nscontext);
                    Element securityTokenE = null;
                    int securityTokenNumber = securityTokenList.getLength();
                    if (securityTokenNumber != 1) {
                        Element context = XMLUtils.createDSctx((Document)doc, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                        NodeList list = XPathAPI.selectNodeList((Node)doc, (String)"//*", (Node)context);
                        for (int j = 0; j < list.getLength(); ++j) {
                            Element node = (Element)list.item(j);
                            String attVal = node.getAttribute("wsu:Id");
                            if (attVal == null || !attVal.equals(Id)) continue;
                            securityTokenE = node;
                            break;
                        }
                        if (securityTokenE == null) {
                            mLogger.log(Level.SEVERE, "No security tokens matching reference Id '" + Id + "'");
                            throw new KeyResolverException("Unable to obtain true security tokens from references");
                        }
                    } else {
                        Node node = securityTokenList.item(0);
                        if (node.getNodeType() != 1) {
                            mLogger.log(Level.SEVERE, "Could not find the security token referenced by Id '" + Id + "'");
                            throw new KeyResolverException("Unable to obtain true security tokens from references");
                        }
                        securityTokenE = (Element)node;
                    }
                    BinarySecurityToken binToken = new BinarySecurityToken(securityTokenE);
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                    cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(Base64.decode((byte[])binToken.getEncodedData().getBytes())));
                }
                if (cert == null) {
                    mLogger.log(Level.SEVERE, "Unable to obtain X509Certificate from WS-Security message, null value returned");
                    throw new KeyResolverException("Unable to obtain X509Certificate from WS-Security message");
                }
                return cert;
            }
            mLogger.log(Level.WARNING, "Failed to find out if can handle KeyInfo element");
            throw new KeyResolverException("Cannot resolve the supplied KeyInfo information");
        }
        catch (TransformerException ex) {
            mLogger.log(Level.SEVERE, "Unable to obtain X509Certificate from WS-Security message", ex);
            throw new KeyResolverException("Unable to obtain X509Certificate from WS-Security message");
        }
        catch (WSSecurityException ex) {
            mLogger.log(Level.SEVERE, "Unable to obtain X509Certificate from WS-Security message", ex);
            throw new KeyResolverException("Unable to obtain X509Certificate from WS-Security message");
        }
        catch (CertificateException ex) {
            mLogger.log(Level.SEVERE, "Unable to obtain X509Certificate from WS-Security message", ex);
            throw new KeyResolverException("Unable to obtain X509Certificate from WS-Security message");
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return null;
    }
}

