/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit.signatures;

import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.soton.itinnovation.wssecit.WSSecITUtil;
import uk.ac.soton.itinnovation.wssecit.WSSecurityException;
import uk.ac.soton.itinnovation.wssecit.encoding.BinarySecurityToken;
import uk.ac.soton.itinnovation.wssecit.encoding.Reference;
import uk.ac.soton.itinnovation.wssecit.encoding.SecurityTokenReference;
import uk.ac.soton.itinnovation.wssecit.signatures.WSSecKeyResolver;
import uk.ac.soton.itinnovation.wssecit.signatures.WSSecX509TrustManager;
import uk.ac.soton.itinnovation.wssecit.signatures.WSSecXMLSignatureException;
import uk.ac.soton.itinnovation.wssecit.signatures.WSUtilityIdResolver;

public class WSSecXMLSignature {
    private static final String XML_SIGNATURE_BASE_URI = "";
    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.wssecit.signatures.WSSecXMLSignature");
    private XMLSignature mSignature;
    private Map mAttachments;

    public WSSecXMLSignature(Document doc, Element elementToSign, BinarySecurityToken securityToken) throws WSSecurityException {
        this.initSignatureElement(doc, elementToSign, securityToken);
    }

    public WSSecXMLSignature(Document doc, Element elementToSign, BinarySecurityToken securityToken, Map attachmentMap) throws WSSecurityException {
        this.mAttachments = attachmentMap;
        this.initSignatureElement(doc, elementToSign, securityToken);
    }

    public WSSecXMLSignature(Element signatureElement) throws WSSecXMLSignatureException {
        try {
            this.mSignature = new XMLSignature(signatureElement, XML_SIGNATURE_BASE_URI);
            this.mSignature.addResourceResolver((ResourceResolverSpi)new WSUtilityIdResolver());
        }
        catch (IOException ex) {
            mLogger.log(Level.SEVERE, "Unable to create XML signature, please consult the logs", ex);
            throw new WSSecXMLSignatureException("Unable to create XML signature, please consult the logs", ex);
        }
        catch (XMLSecurityException ex) {
            mLogger.log(Level.SEVERE, "Unable to create XML signature, please consult the logs", ex);
            throw new WSSecXMLSignatureException("Unable to create XML signature, please consult the logs", (Exception)((Object)ex));
        }
    }

    public WSSecXMLSignature(Element signatureElement, Map attachmentMap) throws WSSecXMLSignatureException {
        try {
            this.mSignature = new XMLSignature(signatureElement, XML_SIGNATURE_BASE_URI);
            this.mSignature.addResourceResolver((ResourceResolverSpi)new WSUtilityIdResolver(attachmentMap));
        }
        catch (IOException ex) {
            mLogger.log(Level.SEVERE, "Unable to create XML signature, please consult the logs", ex);
            throw new WSSecXMLSignatureException("Unable to create XML signature, please consult the logs", ex);
        }
        catch (XMLSecurityException ex) {
            mLogger.log(Level.SEVERE, "Unable to create XML signature, please consult the logs", ex);
            throw new WSSecXMLSignatureException("Unable to create XML signature, please consult the logs", (Exception)((Object)ex));
        }
    }

    public boolean checkSignatureValue(WSSecX509TrustManager trustManager) throws WSSecurityException {
        try {
            KeyInfo keyInfo = this.mSignature.getKeyInfo();
            X509Certificate cert = keyInfo.getX509Certificate();
            if (cert == null) {
                mLogger.log(Level.SEVERE, "Could not obtain the X509Certificate used to sign the message");
                throw new WSSecXMLSignatureException("Could not obtain the X509Certificate used to sign the message");
            }
            cert.checkValidity();
            if (!trustManager.isTrusted(cert)) {
                mLogger.log(Level.SEVERE, "X509 Certificate with Subject DN '" + cert.getSubjectDN().getName() + "' is not trusted.");
                throw new WSSecXMLSignatureException("X509 Certificate with Subject DN '" + cert.getSubjectDN().getName() + "' is not trusted.");
            }
            boolean verify = this.mSignature.checkSignatureValue(cert);
            if (verify) {
                mLogger.log(Level.INFO, "Verified signature for X509 Certificate with Subject DN '" + cert.getSubjectDN().getName() + "'");
            } else {
                mLogger.log(Level.INFO, "Invalid signature for X509 Certificate with Subject DN '" + cert.getSubjectDN().getName() + "'");
            }
            return verify;
        }
        catch (XMLSecurityException ex) {
            mLogger.log(Level.SEVERE, "Unable to resolve X509Certificate for verifying signature, please consult logs", ex);
            throw new WSSecXMLSignatureException("Unable to resolve X509Certificate for verifying signature, please consult logs");
        }
        catch (CertificateNotYetValidException ex) {
            mLogger.log(Level.SEVERE, "X509Certificate for verifying signature is not yet valid", ex);
            throw new WSSecXMLSignatureException(ex.getMessage());
        }
        catch (CertificateExpiredException ex) {
            mLogger.log(Level.SEVERE, "X509Certificate for verifying signature has expired", ex);
            throw new WSSecXMLSignatureException(ex.getMessage());
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "Unexpected failure - could be a bug, check logs", ex);
            throw new WSSecXMLSignatureException(ex.getMessage());
        }
    }

    public void sign(PrivateKey privateKey) throws WSSecXMLSignatureException {
        try {
            SignedInfo signedInfo = this.mSignature.getSignedInfo();
            this.mSignature.sign((Key)privateKey);
            mLogger.log(Level.INFO, "Signed signature successfully");
        }
        catch (XMLSecurityException ex) {
            mLogger.log(Level.SEVERE, "Unable to sign signature using supplied private key, please consult the logs", ex);
            throw new WSSecXMLSignatureException("Unable to sign signature using supplied private key, please consult the logs", (Exception)((Object)ex));
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "Unexpected failure - could be a bug, check logs", ex);
            throw new WSSecXMLSignatureException(ex.getMessage());
        }
    }

    public Element getSignatureElement() {
        return this.mSignature.getElement();
    }

    private void initSignatureElement(Document doc, Element elementToSign, BinarySecurityToken securityToken) throws WSSecurityException {
        if (doc == null) {
            throw new WSSecXMLSignatureException("Supplied DOM Document for signing is null");
        }
        if (elementToSign == null) {
            throw new WSSecXMLSignatureException("Supplied Element to sign is null");
        }
        if (securityToken == null) {
            throw new WSSecXMLSignatureException("Supplied security token is null");
        }
        try {
            this.mSignature = new XMLSignature(doc, XML_SIGNATURE_BASE_URI, "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            if (this.mAttachments == null) {
                this.mSignature.addResourceResolver((ResourceResolverSpi)new WSUtilityIdResolver());
            } else {
                this.mSignature.addResourceResolver((ResourceResolverSpi)new WSUtilityIdResolver(this.mAttachments));
            }
            KeyInfo keyInfo = this.mSignature.getKeyInfo();
            Reference ref = new Reference("#" + securityToken.getId());
            SecurityTokenReference secRef = new SecurityTokenReference(ref);
            keyInfo.addUnknownElement(secRef.getElement(doc));
            WSSecITUtil.setAttributeInWSUtilNamespace(elementToSign, "Id", elementToSign.getTagName());
            this.mSignature.addDocument("#" + securityToken.getId());
            this.mSignature.addDocument("#" + elementToSign.getTagName());
        }
        catch (XMLSignatureException ex) {
            mLogger.log(Level.SEVERE, "Could not create a signature for the supplied information, please consult the logs for more information", ex);
            throw new WSSecXMLSignatureException("Could not create a signature for the supplied information, please consult the logs for more information");
        }
        catch (XMLSecurityException ex) {
            mLogger.log(Level.SEVERE, "Could not create a signature for the supplied information, please consult the logs for more information", ex);
            throw new WSSecXMLSignatureException("Could not create a signature for the supplied information, please consult the logs for more information");
        }
    }

    static {
        Init.init();
        KeyResolver.register((String)((Object)((Object)new WSSecKeyResolver())).getClass().getName());
    }
}

