/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.wssecit.signatures;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSUtilityIdResolver
extends ResourceResolverSpi {
    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.wssecit.signatures.WSUtilityIdResolver");
    private Map mAttachments;

    public WSUtilityIdResolver() {
    }

    public WSUtilityIdResolver(Map attachmentMap) {
        this.mAttachments = attachmentMap;
    }

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        try {
            Set infoSet = null;
            mLogger.log(Level.INFO, "Using WS-Security Utility Id to resolve URI");
            if (!this.engineCanResolve(uri, BaseURI)) {
                mLogger.log(Level.SEVERE, "Cannot resolver infoset from URI that does not start with '#'");
                throw new ResourceResolverException("signature.Verification.MissingID", uri, BaseURI);
            }
            Document ownerDoc = uri.getOwnerDocument();
            XMLUtils.circumventBug2650((Document)ownerDoc);
            String attValue = uri.getNodeValue();
            String Id = attValue.substring(1, attValue.length());
            Element nscontext = XMLUtils.createDSctx((Document)ownerDoc, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            CachedXPathAPI cXPathAPI = new CachedXPathAPI();
            NodeList idedNodeList = cXPathAPI.selectNodeList((Node)ownerDoc, "//*[@wsu:Id='" + Id + "']", (Node)nscontext);
            if (idedNodeList == null || idedNodeList.getLength() != 1) {
                mLogger.log(Level.SEVERE, "Could not uniquely fine element with attribute 'wsu:Id='" + Id + "'");
                throw new ResourceResolverException("signature.Verification.MissingID", uri, BaseURI);
            }
            Element selectedE = (Element)idedNodeList.item(0);
            XMLSignatureInput result = null;
            ArrayList attachmentList = new ArrayList();
            if (selectedE.getLocalName().equals("Body") && selectedE.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                NodeList bodyChildren = selectedE.getChildNodes();
                for (int j = 0; j < bodyChildren.getLength(); ++j) {
                    Node node = bodyChildren.item(j);
                    if (!(node instanceof Element)) continue;
                    Element methodE = (Element)node;
                    NodeList methodChildren = methodE.getChildNodes();
                    for (int i = 0; i < methodChildren.getLength(); ++i) {
                        Element paramE;
                        String hrefAttr;
                        Node nde = methodChildren.item(i);
                        if (!(nde instanceof Element) || (hrefAttr = (paramE = (Element)nde).getAttribute("href")) == null || hrefAttr.equals("")) continue;
                        Set keySet = this.mAttachments.keySet();
                        Iterator keyIterator = keySet.iterator();
                        while (keyIterator.hasNext()) {
                            String key = (String)keyIterator.next();
                            if (!key.equals(hrefAttr.substring(4))) continue;
                            attachmentList.add(this.mAttachments.get(key));
                        }
                    }
                }
            }
            if (attachmentList.size() > 0) {
                Canonicalizer c14n = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
                byte[] inBytes = c14n.canonicalizeSubtree((Node)selectedE);
                ByteArrayInputStream byteStream = new ByteArrayInputStream(inBytes);
                Iterator attIterator = attachmentList.iterator();
                InputStream last = byteStream;
                while (attIterator.hasNext()) {
                    DataHandler dH = (DataHandler)attIterator.next();
                    MessageDigest md = MessageDigest.getInstance("SHA");
                    InputStream originalStream = dH.getInputStream();
                    int available = originalStream.available();
                    while (available > 0) {
                        byte[] bytes;
                        if (available > 1024) {
                            bytes = new byte[1024];
                            originalStream.read(bytes);
                            md.update(bytes);
                        } else {
                            bytes = new byte[available];
                            originalStream.read(bytes);
                            md.update(bytes);
                        }
                        available = originalStream.available();
                    }
                    byte[] attDigest = md.digest();
                    last = new SequenceInputStream(last, new ByteArrayInputStream(attDigest));
                }
                result = new XMLSignatureInput(last);
            } else {
                NodeList selectedEAndChildren = cXPathAPI.selectNodeList((Node)selectedE, "(.//. | .//@* | .//namespace::*)[not(self::comment())]");
                infoSet = XMLUtils.convertNodelistToSet((NodeList)selectedEAndChildren);
                result = new XMLSignatureInput(infoSet, cXPathAPI);
                result.setMIMEType("text/xml");
            }
            try {
                URI uriNew = new URI(new URI(BaseURI), uri.getNodeValue());
                result.setSourceURI(uriNew.toString());
            }
            catch (URI.MalformedURIException ex) {
                result.setSourceURI(BaseURI);
            }
            return result;
        }
        catch (TransformerException ex) {
            mLogger.log(Level.SEVERE, "Could not find the element with attribute '" + uri.getNodeValue() + "'", ex);
            throw new ResourceResolverException("signature.Verification.MissingID", uri, BaseURI);
        }
        catch (NoSuchAlgorithmException ex) {
            mLogger.log(Level.SEVERE, "Could not retrieve suitable algorithm for attachment digest '" + uri.getNodeValue() + "'", ex);
            throw new ResourceResolverException("signature.Verification.MissingID", uri, BaseURI);
        }
        catch (IOException ex) {
            mLogger.log(Level.SEVERE, "Could not find the element with attribute '" + uri.getNodeValue() + "'", ex);
            throw new ResourceResolverException("signature.Verification.MissingID", uri, BaseURI);
        }
        catch (InvalidCanonicalizerException ex) {
            mLogger.log(Level.SEVERE, "Could not find the element with attribute '" + uri.getNodeValue() + "'", ex);
            throw new ResourceResolverException("signature.Verification.MissingID", uri, BaseURI);
        }
        catch (CanonicalizationException ex) {
            mLogger.log(Level.SEVERE, "Could not find the element with attribute '" + uri.getNodeValue() + "'", ex);
            throw new ResourceResolverException("signature.Verification.MissingID", uri, BaseURI);
        }
    }

    public boolean engineCanResolve(Attr uri, String BaseURI) {
        return uri.getNodeValue().startsWith("#");
    }
}

