/*
 * Decompiled with CFR 0.152.
 */
package at.ac.univie.iss.apm.spect;

import at.ac.univie.iss.apm.PerformanceModel;
import at.ac.univie.iss.descriptors.qos.PerformanceDescriptorImpl;
import at.ac.univie.iss.descriptors.qos.RequestDescriptorImpl;

public class SPECTPerformanceModel
implements PerformanceModel {
    private final int no_subsets = 4;
    private final int no_slices = 7;
    private final double VSCC_1 = 53.0;
    private final double VSCC_2 = 132.0;
    private final double VSCC_3 = 0.033;
    private final double VSCC_4 = 1.0;
    private final double VSCC_5 = 3.5;
    private final double VSCC_rearrange = 35.0;
    private final double VSCC_matrix_1 = 328.3;
    private final double VSCC_matrix_2 = 40.0;
    private final double VSCC_matrix_comm = 5.0;
    private final double VSCC_file = 13.0;

    private int getNumOfNodes(String machineDesc) {
        int first = machineDesc.indexOf("<number-of-nodes>");
        String submachineDesc = machineDesc.substring(new String("<number-of-nodes>").length() + first);
        String number = submachineDesc.substring(0, submachineDesc.indexOf("</")).trim();
        return Integer.parseInt(number);
    }

    public String getPerformanceEstimate(String reqDesc, String machineDesc) {
        int numOfNodes = this.getNumOfNodes(machineDesc);
        RequestDescriptorImpl requestDescriptor = new RequestDescriptorImpl(reqDesc);
        double iterations = Double.parseDouble(requestDescriptor.getPerformanceParameter("NumberOfIterations"));
        double radius = Double.parseDouble(requestDescriptor.getPerformanceParameter("Radius"));
        double threshold = Double.parseDouble(requestDescriptor.getPerformanceParameter("Threshold"));
        double slope = Double.parseDouble(requestDescriptor.getPerformanceParameter("ModelSlope"));
        double dx = Double.parseDouble(requestDescriptor.getPerformanceParameter("DX"));
        double dy = Double.parseDouble(requestDescriptor.getPerformanceParameter("DY"));
        double dz = Double.parseDouble(requestDescriptor.getPerformanceParameter("DZ"));
        double slices = Double.parseDouble(requestDescriptor.getPerformanceParameter("NumberOfSlices"));
        double projections = Double.parseDouble(requestDescriptor.getPerformanceParameter("NumberOfProjections"));
        double nx = Double.parseDouble(requestDescriptor.getPerformanceParameter("NX"));
        double ny = Double.parseDouble(requestDescriptor.getPerformanceParameter("NY"));
        double pixel_area = dx * dy;
        double sigma_min = slope * dx * (radius - nx / 2.0 * dx);
        double sigma_mid = slope * dx * radius;
        double sigma_max = slope * dx * (radius + nx / 2.0 * dx);
        double arg_min = Math.sqrt(Math.log(threshold) * -2.0 * sigma_min * sigma_min);
        double arg_mid = Math.sqrt(Math.log(threshold) * -2.0 * sigma_mid * sigma_mid);
        double arg_max = Math.sqrt(Math.log(threshold) * -2.0 * sigma_max * sigma_max);
        double alpha = Math.asin(arg_max / (radius + nx / 2.0 * dx)) * 57.29577951308232;
        double gamma_1 = Math.asin(Math.sin(1.5707963267948966 + alpha * (Math.PI / 180)) * arg_mid / (nx / 2.0 * dx)) * 57.29577951308232;
        double beta_1 = gamma_1 + alpha;
        double gamma_2 = Math.asin(Math.sin(1.5707963267948966 - alpha * (Math.PI / 180)) * arg_mid / (nx / 2.0 * dx)) * 57.29577951308232;
        double beta_2 = gamma_2 + alpha;
        double A_1 = Math.PI * (nx / 2.0 * dx * (nx / 2.0 * dx)) * beta_1 / 360.0;
        double A_2 = 0.5 * (nx / 2.0 * dx) * arg_mid * Math.sin(1.5707963267948966 - beta_1 * (Math.PI / 180));
        double A_3 = Math.PI * (nx / 2.0 * dx * (nx / 2.0 * dx)) * beta_2 / 360.0;
        double A_4 = 0.5 * (nx / 2.0 * dx) * arg_mid * Math.sin(1.5707963267948966 - beta_2 * (Math.PI / 180));
        double A_middle_0 = 2.0 * (A_1 + A_2 + A_3 + A_4);
        double arg_mid_1 = Math.sqrt(arg_mid * arg_mid - dx * dx);
        double arg_mid_2 = Math.sqrt(arg_mid * arg_mid - 2.0 * dx * (2.0 * dx));
        double arg_mid_3 = Math.sqrt(arg_mid * arg_mid - 3.0 * dx * (3.0 * dx));
        double gamma_1_1 = Math.asin(Math.sin(1.5707963267948966 + alpha * (Math.PI / 180)) * arg_mid_1 / (nx / 2.0 * dx)) * 57.29577951308232;
        double beta_1_1 = gamma_1_1 + alpha;
        double gamma_2_1 = Math.asin(Math.sin(1.5707963267948966 - alpha * (Math.PI / 180)) * arg_mid_1 / (nx / 2.0 * dx)) * 57.29577951308232;
        double beta_2_1 = gamma_2_1 - alpha;
        double gamma_1_2 = Math.asin(Math.sin(1.5707963267948966 + alpha * (Math.PI / 180)) * arg_mid_2 / (nx / 2.0 * dx)) * 57.29577951308232;
        double beta_1_2 = gamma_1_2 + alpha;
        double gamma_2_2 = Math.asin(Math.sin(1.5707963267948966 - alpha * (Math.PI / 180)) * arg_mid_2 / (nx / 2.0 * dx)) * 57.29577951308232;
        double beta_2_2 = gamma_2_2 - alpha;
        double gamma_1_3 = Math.asin(Math.sin(1.5707963267948966 + alpha * (Math.PI / 180)) * arg_mid_3 / (nx / 2.0 * dx)) * 57.29577951308232;
        double beta_1_3 = gamma_1_3 + alpha;
        double gamma_2_3 = Math.asin(Math.sin(1.5707963267948966 - alpha * (Math.PI / 180)) * arg_mid_3 / (nx / 2.0 * dx)) * 57.29577951308232;
        double beta_2_3 = gamma_2_3 - alpha;
        double A_1_1 = Math.PI * (nx / 2.0 * dx * (nx / 2.0 * dx)) * beta_1_1 / 360.0;
        double A_2_1 = 0.5 * (nx / 2.0 * dx) * arg_mid * Math.sin(1.5707963267948966 - beta_1_1 * (Math.PI / 180));
        double A_3_1 = Math.PI * (nx / 2.0 * dx * (nx / 2.0 * dx)) * beta_2_1 / 360.0;
        double A_4_1 = 0.5 * (nx / 2.0 * dx) * arg_mid * Math.sin(1.5707963267948966 - beta_2_1 * (Math.PI / 180));
        double A_1_2 = Math.PI * (nx / 2.0 * dx * (nx / 2.0 * dx)) * beta_1_2 / 360.0;
        double A_2_2 = 0.5 * (nx / 2.0 * dx) * arg_mid * Math.sin(1.5707963267948966 - beta_1_2 * (Math.PI / 180));
        double A_3_2 = Math.PI * (nx / 2.0 * dx * (nx / 2.0 * dx)) * beta_2_2 / 360.0;
        double A_4_2 = 0.0 * (nx / 2.0 * dx) * arg_mid * Math.sin(1.5707963267948966 - beta_2_2 * (Math.PI / 180));
        double A_1_3 = Math.PI * (nx / 2.0 * dx * (nx / 2.0 * dx)) * beta_1_3 / 360.0;
        double A_2_3 = 0.5 * (nx / 2.0 * dx) * arg_mid * Math.sin(1.5707963267948966 - beta_1_3 * (Math.PI / 180));
        double A_3_3 = Math.PI * (nx / 2.0 * dx * (nx / 2.0 * dx)) * beta_2_3 / 360.0;
        double A_4_3 = 0.0 * (nx / 2.0 * dx) * arg_mid * Math.sin(1.5707963267948966 - beta_2_3 * (Math.PI / 180));
        double A_middle_1 = 4.0 * (A_1_1 + A_2_1 + A_3_1 + A_4_1);
        double A_middle_2 = 4.0 * (A_1_2 + A_2_2 + A_3_2 + A_4_2);
        double A_middle_3 = 4.0 * (A_1_3 + A_2_3 + A_3_3 + A_4_3);
        double A_middle = A_middle_0 + A_middle_1 + A_middle_2 + A_middle_3;
        A_1 = 0.0;
        A_2 = 0.0;
        int k = 1;
        while ((double)k <= nx / 2.0 - 1.0) {
            double offset = dx / 2.0 + (double)k * dx;
            double x = Math.sqrt(nx / 2.0 * dx * (nx / 2.0 * dx) - offset * offset);
            sigma_min = slope * dx * (radius - x);
            sigma_mid = slope * dx * radius;
            sigma_max = slope * dx * (radius + x);
            arg_min = Math.sqrt(-(Math.log(threshold) * 2.0 * sigma_min * sigma_min));
            arg_mid = Math.sqrt(-(Math.log(threshold) * 2.0 * sigma_mid * sigma_mid));
            arg_max = Math.sqrt(-(Math.log(threshold) * 2.0 * sigma_max * sigma_max));
            double arg_min_1 = arg_min >= dx ? Math.sqrt(arg_min * arg_min - dx * dx) : 0.0;
            arg_mid_1 = Math.sqrt(arg_mid * arg_mid - dx * dx);
            double arg_max_1 = Math.sqrt(arg_max * arg_max - dx * dx);
            double arg_min_2 = arg_min >= 2.0 * dx ? Math.sqrt(arg_min * arg_min - 2.0 * dx * (2.0 * dx)) : 0.0;
            arg_mid_2 = Math.sqrt(arg_mid * arg_mid - 2.0 * dx * (2.0 * dx));
            double arg_max_2 = Math.sqrt(arg_max * arg_max - 2.0 * dx * (2.0 * dx));
            double arg_min_3 = arg_min >= 3.0 * dx ? Math.sqrt(arg_min * arg_min - 3.0 * dx * (3.0 * dx)) : 0.0;
            arg_mid_3 = Math.sqrt(arg_mid * arg_mid - 3.0 * dx * (3.0 * dx));
            double arg_max_3 = Math.sqrt(arg_max * arg_max - 3.0 * dx * (3.0 * dx));
            A_1 += 2.0 * x * (arg_min + arg_max + arg_min_1 + arg_max_1 + arg_min_2 + arg_max_2 + arg_min_3 + arg_max_3);
            ++k;
        }
        double A = (2.0 * A_middle + 4.0 * A_1) * projections;
        double number_of_elements = A / pixel_area * 0.88;
        double factor_slices_pseudo = (slices / (double)numOfNodes + 6.0) / 128.0;
        if (numOfNodes == 1) {
            factor_slices_pseudo = 1.0;
        }
        double factor_slices = slices / (double)numOfNodes / 128.0;
        double factor_elements = number_of_elements / 7.5318796E7;
        double factor_proj = projections / 120.0;
        double factor_dimension = nx / 128.0;
        double factor_comm = (double)numOfNodes / 8.0;
        if (numOfNodes == 1) {
            factor_comm = 0.0;
        }
        double factor_comm_matrix = (double)numOfNodes / 2.0;
        if (numOfNodes == 1) {
            factor_comm_matrix = 0.0;
        }
        double matrixTime_1 = 328.3 * factor_proj * factor_dimension * factor_dimension * factor_dimension / (double)numOfNodes;
        double matrixComm = 5.0 * factor_comm_matrix * factor_proj * factor_dimension * factor_dimension;
        double matrixTime_2 = 40.0 * factor_proj * factor_dimension * factor_dimension * factor_dimension;
        double matrixTime = matrixTime_1 + matrixComm + matrixTime_2;
        double execTime = matrixTime + 35.0 * factor_proj * factor_dimension * factor_dimension + 3.5 + iterations * 4.0 * (53.0 * factor_slices_pseudo * factor_elements + 132.0 * factor_elements * factor_slices + 1.0 * (slices / 128.0) * factor_dimension * factor_dimension) + 13.0 * (slices / 128.0) * factor_dimension * factor_dimension;
        PerformanceDescriptorImpl perfDesc = new PerformanceDescriptorImpl();
        perfDesc.setRuntime(execTime);
        return perfDesc.toString();
    }

    public static final void main(String[] args) {
        SPECTPerformanceModel pm = new SPECTPerformanceModel();
        RequestDescriptorImpl requestDescriptor = new RequestDescriptorImpl();
        requestDescriptor.setPerformanceParameter("NumberOfIterations", "5");
        requestDescriptor.setPerformanceParameter("Radius", "450.0");
        requestDescriptor.setPerformanceParameter("Threshold", "10e-5");
        requestDescriptor.setPerformanceParameter("ModelSlope", "0.003");
        requestDescriptor.setPerformanceParameter("DX", "4.42");
        requestDescriptor.setPerformanceParameter("DY", "4.42");
        requestDescriptor.setPerformanceParameter("DZ", "4.42");
        requestDescriptor.setPerformanceParameter("NumberOfSlices", "64");
        requestDescriptor.setPerformanceParameter("NumberOfProjections", "60");
        requestDescriptor.setPerformanceParameter("NX", "128");
        requestDescriptor.setPerformanceParameter("NY", "128");
        String machineDescriptor = new String("<machine-descriptor><number-of-nodes>8</number-of-nodes></machine-descriptor>");
        System.out.println("Bevor perfmodel ...");
        String ret = pm.getPerformanceEstimate(requestDescriptor.toString(), machineDescriptor);
        System.out.println("Return:\n" + ret);
    }
}

