/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.usfd.cardio;

import at.ac.univie.iss.apm.PerformanceModel;
import at.ac.univie.iss.descriptors.qos.PerformanceDescriptorImpl;
import at.ac.univie.iss.descriptors.qos.RequestDescriptorImpl;

public class CARDIOPerformanceModel
implements PerformanceModel {
    private final double speedup_peak = 16.0;
    private final double base_time_node_it_parallel = 7.12E-4;
    private final double base_time_node_serial = 0.01;
    private final double base_time_serial = 120.0;
    private final double error_margin = 0.3;
    private final int ppn = 2;

    private int getNumOfNodes(String string) {
        int n = string.indexOf("<number-of-nodes>");
        String string2 = string.substring(new String("<number-of-nodes>").length() + n);
        String string3 = string2.substring(0, string2.indexOf("</")).trim();
        return Integer.parseInt(string3);
    }

    public String getPerformanceEstimate(String string, String string2) {
        int n = this.getNumOfNodes(string2);
        int n2 = n * 2;
        double d = (double)n2 * (1.0 - (double)n2 / 32.0) / 0.96875;
        if (d < 1.0) {
            d = 1.0;
        }
        RequestDescriptorImpl requestDescriptorImpl = new RequestDescriptorImpl(string);
        int n3 = Integer.parseInt(requestDescriptorImpl.getPerformanceParameter("Mesh nodes"));
        int n4 = Integer.parseInt(requestDescriptorImpl.getPerformanceParameter("Iterations"));
        double d2 = 7.12E-4 * (double)n3 * (double)n4 / d + 0.01 * (double)n3 + 120.0;
        PerformanceDescriptorImpl performanceDescriptorImpl = new PerformanceDescriptorImpl();
        performanceDescriptorImpl.setRuntime(d2 *= 1.3);
        return performanceDescriptorImpl.toString();
    }

    public static final void main(String[] stringArray) {
        CARDIOPerformanceModel cARDIOPerformanceModel = new CARDIOPerformanceModel();
        RequestDescriptorImpl requestDescriptorImpl = new RequestDescriptorImpl();
        requestDescriptorImpl.setPerformanceParameter("Mesh nodes", "13041");
        requestDescriptorImpl.setPerformanceParameter("Iterations", "25");
        String string = new String("<machine-descriptor><number-of-nodes>4</number-of-nodes></machine-descriptor>");
        System.out.println("Performance model test ...");
        String string2 = cARDIOPerformanceModel.getPerformanceEstimate(requestDescriptorImpl.toString(), string);
        System.out.println("Return:\n" + string2);
    }
}

