/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] eras = null;
    String[] months = null;
    String[] shortMonths = null;
    String[] weekdays = null;
    String[] shortWeekdays = null;
    String[] ampms = null;
    String[][] zoneStrings = null;
    static final String patternChars = "GyMdkHmsSEDFwWahKz";
    String localPatternChars = null;
    static final long serialVersionUID = -5987973545549424702L;
    static final int millisPerHour = 3600000;
    static /* synthetic */ Class class$com$ibm$icu$util$GregorianCalendar;

    public DateFormatSymbols() {
        this.initializeData(Locale.getDefault());
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(locale);
    }

    public String[] getEras() {
        return this.duplicate(this.eras);
    }

    public void setEras(String[] newEras) {
        this.eras = this.duplicate(newEras);
    }

    public String[] getMonths() {
        return this.duplicate(this.months);
    }

    public void setMonths(String[] newMonths) {
        this.months = this.duplicate(newMonths);
    }

    public String[] getShortMonths() {
        return this.duplicate(this.shortMonths);
    }

    public void setShortMonths(String[] newShortMonths) {
        this.shortMonths = this.duplicate(newShortMonths);
    }

    public String[] getWeekdays() {
        return this.duplicate(this.weekdays);
    }

    public void setWeekdays(String[] newWeekdays) {
        this.weekdays = this.duplicate(newWeekdays);
    }

    public String[] getShortWeekdays() {
        return this.duplicate(this.shortWeekdays);
    }

    public void setShortWeekdays(String[] newShortWeekdays) {
        this.shortWeekdays = this.duplicate(newShortWeekdays);
    }

    public String[] getAmPmStrings() {
        return this.duplicate(this.ampms);
    }

    public void setAmPmStrings(String[] newAmpms) {
        this.ampms = this.duplicate(newAmpms);
    }

    public String[][] getZoneStrings() {
        return this.duplicate(this.zoneStrings);
    }

    public void setZoneStrings(String[][] newZoneStrings) {
        this.zoneStrings = this.duplicate(newZoneStrings);
    }

    public String getLocalPatternChars() {
        return new String(this.localPatternChars);
    }

    public void setLocalPatternChars(String newLocalPatternChars) {
        this.localPatternChars = newLocalPatternChars;
    }

    public Object clone() {
        try {
            DateFormatSymbols other = (DateFormatSymbols)super.clone();
            this.copyMembers(this, other);
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int hashcode = 0;
        int index = 0;
        while (index < this.zoneStrings[0].length) {
            hashcode ^= this.zoneStrings[0][index].hashCode();
            ++index;
        }
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormatSymbols that = (DateFormatSymbols)obj;
        return Utility.arrayEquals(this.eras, (Object)that.eras) && Utility.arrayEquals(this.months, (Object)that.months) && Utility.arrayEquals(this.shortMonths, (Object)that.shortMonths) && Utility.arrayEquals(this.weekdays, (Object)that.weekdays) && Utility.arrayEquals(this.shortWeekdays, (Object)that.shortWeekdays) && Utility.arrayEquals(this.ampms, (Object)that.ampms) && Utility.arrayEquals((Object[])this.zoneStrings, (Object)that.zoneStrings) && Utility.arrayEquals(this.localPatternChars, (Object)that.localPatternChars);
    }

    private void initializeData(Locale desiredLocale) {
        ResourceBundle rb = ICULocaleData.getLocaleElements(desiredLocale);
        this.eras = rb.getStringArray("Eras");
        this.months = rb.getStringArray("MonthNames");
        this.shortMonths = rb.getStringArray("MonthAbbreviations");
        String[] lWeekdays = rb.getStringArray("DayNames");
        this.weekdays = new String[8];
        this.weekdays[0] = "";
        System.arraycopy(lWeekdays, 0, this.weekdays, 1, lWeekdays.length);
        String[] sWeekdays = rb.getStringArray("DayAbbreviations");
        this.shortWeekdays = new String[8];
        this.shortWeekdays[0] = "";
        System.arraycopy(sWeekdays, 0, this.shortWeekdays, 1, sWeekdays.length);
        this.ampms = rb.getStringArray("AmPmMarkers");
        Object[] zoneObject = (Object[])rb.getObject("zoneStrings");
        this.zoneStrings = new String[zoneObject.length][];
        int i = 0;
        while (i < this.zoneStrings.length) {
            this.zoneStrings[i] = (String[])zoneObject[i];
            ++i;
        }
        this.localPatternChars = rb.getString("localPatternChars");
    }

    final int getZoneIndex(String ID) {
        int result = this._getZoneIndex(ID);
        if (result >= 0) {
            return result;
        }
        int n = TimeZone.countEquivalentIDs(ID);
        if (n > 1) {
            int i = 0;
            while (i < n) {
                int equivResult;
                String equivID = TimeZone.getEquivalentID(ID, i);
                if (!equivID.equals(ID) && (equivResult = this._getZoneIndex(equivID)) >= 0) {
                    return equivResult;
                }
                ++i;
            }
        }
        return -1;
    }

    private int _getZoneIndex(String ID) {
        int index = 0;
        while (index < this.zoneStrings.length) {
            if (ID.equalsIgnoreCase(this.zoneStrings[index][0])) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private final String[] duplicate(String[] srcArray) {
        return (String[])srcArray.clone();
    }

    private final String[][] duplicate(String[][] srcArray) {
        String[][] aCopy = new String[srcArray.length][];
        int i = 0;
        while (i < srcArray.length) {
            aCopy[i] = this.duplicate(srcArray[i]);
            ++i;
        }
        return aCopy;
    }

    private final void copyMembers(DateFormatSymbols src, DateFormatSymbols dst) {
        dst.eras = this.duplicate(src.eras);
        dst.months = this.duplicate(src.months);
        dst.shortMonths = this.duplicate(src.shortMonths);
        dst.weekdays = this.duplicate(src.weekdays);
        dst.shortWeekdays = this.duplicate(src.shortWeekdays);
        dst.ampms = this.duplicate(src.ampms);
        dst.zoneStrings = this.duplicate(src.zoneStrings);
        dst.localPatternChars = new String(src.localPatternChars);
    }

    public DateFormatSymbols(Calendar cal, Locale locale) {
        this(cal == null ? null : cal.getClass(), locale);
    }

    public DateFormatSymbols(Class calendarClass, Locale locale) {
        this(locale);
        if (calendarClass != null) {
            ResourceBundle bundle;
            block3: {
                bundle = null;
                try {
                    bundle = DateFormatSymbols.getDateFormatBundle(calendarClass, locale);
                }
                catch (MissingResourceException e) {
                    if ((class$com$ibm$icu$util$GregorianCalendar == null ? (class$com$ibm$icu$util$GregorianCalendar = DateFormatSymbols.class$("com.ibm.icu.util.GregorianCalendar")) : class$com$ibm$icu$util$GregorianCalendar).isAssignableFrom(calendarClass)) break block3;
                    throw e;
                }
            }
            this.constructCalendarSpecific(bundle);
        }
    }

    public DateFormatSymbols(ResourceBundle bundle, Locale locale) {
        this(locale);
        this.constructCalendarSpecific(bundle);
    }

    protected void constructCalendarSpecific(ResourceBundle bundle) {
        if (bundle != null) {
            String[] temp;
            try {
                temp = bundle.getStringArray("DayNames");
                this.setWeekdays(temp);
                this.setShortWeekdays(temp);
                temp = bundle.getStringArray("DayAbbreviations");
                this.setShortWeekdays(temp);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                temp = bundle.getStringArray("MonthNames");
                this.setMonths(temp);
                this.setShortMonths(temp);
                temp = bundle.getStringArray("MonthAbbreviations");
                this.setShortMonths(temp);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                temp = bundle.getStringArray("Eras");
                this.setEras(temp);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    public static ResourceBundle getDateFormatBundle(Class calendarClass, Locale locale) throws MissingResourceException {
        ResourceBundle result;
        block2: {
            String fullName = calendarClass.getName();
            int lastDot = fullName.lastIndexOf(46);
            String className = fullName.substring(lastDot + 1);
            String bundleName = className + "Symbols";
            result = null;
            try {
                result = ICULocaleData.getResourceBundle(bundleName, locale);
            }
            catch (MissingResourceException e) {
                if ((class$com$ibm$icu$util$GregorianCalendar == null ? (class$com$ibm$icu$util$GregorianCalendar = DateFormatSymbols.class$("com.ibm.icu.util.GregorianCalendar")) : class$com$ibm$icu$util$GregorianCalendar).isAssignableFrom(calendarClass)) break block2;
                throw e;
            }
        }
        return result;
    }

    public static ResourceBundle getDateFormatBundle(Calendar cal, Locale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(cal == null ? null : cal.getClass(), locale);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

