/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NFRuleSet;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedCollator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;

public final class RuleBasedNumberFormat
extends NumberFormat {
    private static final String copyrightNotice = "Copyright \u00a91997-1998 IBM Corp.  All rights reserved.";
    public static final int SPELLOUT = 1;
    public static final int ORDINAL = 2;
    public static final int DURATION = 3;
    private NFRuleSet[] ruleSets = null;
    private NFRuleSet defaultRuleSet = null;
    private Locale locale = null;
    private Collator collator = null;
    private DecimalFormatSymbols decimalFormatSymbols = null;
    private boolean lenientParse = false;
    private String lenientParseRules = null;

    public RuleBasedNumberFormat(String description) {
        this.locale = Locale.getDefault();
        this.init(description);
    }

    public RuleBasedNumberFormat(String description, Locale locale) {
        this.locale = locale;
        this.init(description);
    }

    public RuleBasedNumberFormat(Locale locale, int format) {
        this.locale = locale;
        ResourceBundle bundle = ICULocaleData.getResourceBundle("LocaleElements", locale);
        String description = "";
        switch (format) {
            case 1: {
                description = bundle.getString("SpelloutRules");
                break;
            }
            case 2: {
                description = bundle.getString("OrdinalRules");
                break;
            }
            case 3: {
                description = bundle.getString("DurationRules");
            }
        }
        this.init(description);
    }

    public RuleBasedNumberFormat(int format) {
        this(Locale.getDefault(), format);
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object that) {
        if (!(that instanceof RuleBasedNumberFormat)) {
            return false;
        }
        RuleBasedNumberFormat that2 = (RuleBasedNumberFormat)that;
        if (!this.locale.equals(that2.locale) || this.lenientParse != that2.lenientParse) {
            return false;
        }
        if (this.ruleSets.length != that2.ruleSets.length) {
            return false;
        }
        int i = 0;
        while (i < this.ruleSets.length) {
            if (!this.ruleSets[i].equals(that2.ruleSets[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.ruleSets.length) {
            result.append(this.ruleSets[i].toString());
            ++i;
        }
        return result.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        String description = in.readUTF();
        RuleBasedNumberFormat temp = new RuleBasedNumberFormat(description);
        this.ruleSets = temp.ruleSets;
        this.defaultRuleSet = temp.defaultRuleSet;
    }

    public String[] getRuleSetNames() {
        int count = 0;
        int i = 0;
        while (i < this.ruleSets.length) {
            if (!this.ruleSets[i].getName().startsWith("%%")) {
                ++count;
            }
            ++i;
        }
        String[] result = new String[count];
        count = 0;
        int i2 = this.ruleSets.length - 1;
        while (i2 >= 0) {
            if (!this.ruleSets[i2].getName().startsWith("%%")) {
                result[count++] = this.ruleSets[i2].getName();
            }
            --i2;
        }
        return result;
    }

    public String format(double number, String ruleSet) throws IllegalArgumentException {
        if (ruleSet.startsWith("%%")) {
            throw new IllegalArgumentException("Can't use internal rule set");
        }
        return this.format(number, this.findRuleSet(ruleSet));
    }

    public String format(long number, String ruleSet) throws IllegalArgumentException {
        if (ruleSet.startsWith("%%")) {
            throw new IllegalArgumentException("Can't use internal rule set");
        }
        return this.format(number, this.findRuleSet(ruleSet));
    }

    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition ignore) {
        toAppendTo.append(this.format(number, this.defaultRuleSet));
        return toAppendTo;
    }

    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition ignore) {
        toAppendTo.append(this.format(number, this.defaultRuleSet));
        return toAppendTo;
    }

    public StringBuffer format(BigInteger number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(new com.ibm.icu.math.BigDecimal(number), toAppendTo, pos);
    }

    public StringBuffer format(BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(new com.ibm.icu.math.BigDecimal(number), toAppendTo, pos);
    }

    public StringBuffer format(com.ibm.icu.math.BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(number.doubleValue(), toAppendTo, pos);
    }

    public Number parse(String text, ParsePosition parsePosition) {
        String workingText = text.substring(parsePosition.getIndex());
        ParsePosition workingPos = new ParsePosition(0);
        Number tempResult = null;
        Number result = new Long(0L);
        ParsePosition highWaterMark = new ParsePosition(workingPos.getIndex());
        int i = this.ruleSets.length - 1;
        while (i >= 0) {
            if (!this.ruleSets[i].getName().startsWith("%%")) {
                tempResult = this.ruleSets[i].parse(workingText, workingPos, Double.MAX_VALUE);
                if (workingPos.getIndex() > highWaterMark.getIndex()) {
                    result = tempResult;
                    highWaterMark.setIndex(workingPos.getIndex());
                }
                if (highWaterMark.getIndex() == workingText.length()) break;
                workingPos.setIndex(0);
            }
            --i;
        }
        parsePosition.setIndex(parsePosition.getIndex() + highWaterMark.getIndex());
        return result;
    }

    public void setLenientParseMode(boolean enabled) {
        this.lenientParse = enabled;
        if (!enabled) {
            this.collator = null;
        }
    }

    public boolean lenientParseEnabled() {
        return this.lenientParse;
    }

    public void setDefaultRuleSet(String ruleSetName) {
        if (ruleSetName == null) {
            this.initDefaultRuleSet();
        } else {
            if (ruleSetName.startsWith("%%")) {
                throw new IllegalArgumentException("cannot use private rule set: " + ruleSetName);
            }
            this.defaultRuleSet = this.findRuleSet(ruleSetName);
        }
    }

    NFRuleSet getDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    Collator getCollator() {
        if (this.collator == null && this.lenientParse) {
            try {
                RuleBasedCollator temp = (RuleBasedCollator)Collator.getInstance(this.locale);
                String rules = temp.getRules() + this.lenientParseRules;
                this.collator = new RuleBasedCollator(rules);
                this.collator.setDecomposition(17);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.collator = null;
            }
        }
        return this.collator;
    }

    DecimalFormatSymbols getDecimalFormatSymbols() {
        if (this.decimalFormatSymbols == null) {
            this.decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
        }
        return this.decimalFormatSymbols;
    }

    private void init(String description) {
        int lp = (description = this.stripWhitespace(description)).indexOf("%%lenient-parse:");
        if (lp != -1 && (lp == 0 || description.charAt(lp - 1) == ';')) {
            int lpEnd = description.indexOf(";%", lp);
            if (lpEnd == -1) {
                lpEnd = description.length() - 1;
            }
            int lpStart = lp + "%%lenient-parse:".length();
            while (UCharacterProperty.isRuleWhiteSpace(description.charAt(lpStart))) {
                ++lpStart;
            }
            this.lenientParseRules = description.substring(lpStart, lpEnd);
            StringBuffer temp = new StringBuffer(description.substring(0, lp));
            if (lpEnd + 1 < description.length()) {
                temp.append(description.substring(lpEnd + 1));
            }
            description = temp.toString();
        }
        int numRuleSets = 0;
        int p = description.indexOf(";%");
        while (p != -1) {
            ++numRuleSets;
            ++p;
            p = description.indexOf(";%", p);
        }
        this.ruleSets = new NFRuleSet[++numRuleSets];
        String[] ruleSetDescriptions = new String[numRuleSets];
        int curRuleSet = 0;
        int start = 0;
        int p2 = description.indexOf(";%");
        while (p2 != -1) {
            ruleSetDescriptions[curRuleSet] = description.substring(start, p2 + 1);
            this.ruleSets[curRuleSet] = new NFRuleSet(ruleSetDescriptions, curRuleSet);
            ++curRuleSet;
            start = p2 + 1;
            p2 = description.indexOf(";%", start);
        }
        ruleSetDescriptions[curRuleSet] = description.substring(start);
        this.ruleSets[curRuleSet] = new NFRuleSet(ruleSetDescriptions, curRuleSet);
        this.initDefaultRuleSet();
        int i = 0;
        while (i < this.ruleSets.length) {
            this.ruleSets[i].parseRules(ruleSetDescriptions[i], this);
            ruleSetDescriptions[i] = null;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String stripWhitespace(String description) {
        result = new StringBuffer();
        start = 0;
        ** GOTO lbl19
        {
            ++start;
            do {
                if (start < description.length() && UCharacterProperty.isRuleWhiteSpace(description.charAt(start))) continue block0;
                p = description.indexOf(59, start);
                if (p == -1) {
                    result.append(description.substring(start));
                    start = -1;
                    continue;
                }
                if (p < description.length()) {
                    result.append(description.substring(start, p + 1));
                    start = p + 1;
                    continue;
                }
                start = -1;
lbl19:
                // 4 sources

            } while (start != -1 && start < description.length());
        }
        return result.toString();
    }

    private void initDefaultRuleSet() {
        int i = this.ruleSets.length - 1;
        while (i >= 0) {
            if (!this.ruleSets[i].getName().startsWith("%%")) {
                this.defaultRuleSet = this.ruleSets[i];
                return;
            }
            --i;
        }
        this.defaultRuleSet = this.ruleSets[this.ruleSets.length - 1];
    }

    String format(double number, NFRuleSet ruleSet) {
        StringBuffer result = new StringBuffer();
        ruleSet.format(number, result, 0);
        return result.toString();
    }

    String format(long number, NFRuleSet ruleSet) {
        StringBuffer result = new StringBuffer();
        ruleSet.format(number, result, 0);
        return result.toString();
    }

    NFRuleSet findRuleSet(String name) throws IllegalArgumentException {
        int i = 0;
        while (i < this.ruleSets.length) {
            if (this.ruleSets[i].getName().equals(name)) {
                return this.ruleSets[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("No rule set named " + name);
    }
}

