/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.Wire;
import org.apache.commons.httpclient.WireLogOutputStream;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.httpclient.util.TimeoutController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpConnection {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$HttpConnection != null ? class$org$apache$commons$httpclient$HttpConnection : (class$org$apache$commons$httpclient$HttpConnection = HttpConnection.class$("org.apache.commons.httpclient.HttpConnection"))));
    private boolean used = false;
    private String hostName = null;
    private String virtualName = null;
    private int portNumber = -1;
    private String proxyHostName = null;
    private int proxyPortNumber = -1;
    private Socket socket = null;
    private PushbackInputStream inputStream = null;
    private OutputStream outputStream = null;
    private int sendBufferSize = -1;
    private InputStream lastResponseInputStream = null;
    protected boolean isOpen = false;
    private Protocol protocolInUse;
    private int soTimeout = 0;
    private boolean soNodelay = true;
    private boolean usingSecureSocket = false;
    private boolean tunnelEstablished = false;
    private boolean staleCheckingEnabled = true;
    private int connectTimeout = 0;
    private HttpConnectionManager httpConnectionManager;
    private InetAddress localAddress;
    static /* synthetic */ Class class$org$apache$commons$httpclient$HttpConnection;

    public HttpConnection(String host, int port) {
        this(null, -1, host, port, false);
    }

    public HttpConnection(String proxyHost, int proxyPort, String host, int port) {
        this(proxyHost, proxyPort, host, port, false);
    }

    public HttpConnection(String proxyHost, int proxyPort, String host, int port, boolean secure) {
        this(proxyHost, proxyPort, host, null, port, Protocol.getProtocol(secure ? "https" : "http"));
    }

    public HttpConnection(String proxyHost, int proxyPort, String host, String virtualHost, int port, Protocol protocol) {
        if (host == null) {
            throw new IllegalArgumentException("host parameter is null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        this.proxyHostName = proxyHost;
        this.proxyPortNumber = proxyPort;
        this.hostName = host;
        this.virtualName = virtualHost;
        this.portNumber = protocol.resolvePort(port);
        this.protocolInUse = protocol;
    }

    public HttpConnection(String host, int port, Protocol protocol) {
        this(null, -1, host, null, port, protocol);
    }

    public HttpConnection(String host, int port, boolean secure) {
        this(null, -1, host, port, secure);
    }

    public HttpConnection(String host, String virtualHost, int port, Protocol protocol) {
        this(null, -1, host, virtualHost, port, protocol);
    }

    public HttpConnection(HostConfiguration hostConfiguration) {
        this(hostConfiguration.getProxyHost(), hostConfiguration.getProxyPort(), hostConfiguration.getHost(), hostConfiguration.getVirtualHost(), hostConfiguration.getPort(), hostConfiguration.getProtocol());
        this.localAddress = hostConfiguration.getLocalAddress();
    }

    protected void assertNotOpen() throws IllegalStateException {
        if (this.isOpen) {
            throw new IllegalStateException("Connection is open");
        }
    }

    protected void assertOpen() throws IllegalStateException {
        if (!this.isOpen) {
            throw new IllegalStateException("Connection is not open");
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() {
        LOG.trace((Object)"enter HttpConnection.close()");
        this.closeSocketAndStreams();
    }

    protected void closeSocketAndStreams() {
        Closeable temp;
        LOG.trace((Object)"enter HttpConnection.closeSockedAndStreams()");
        this.lastResponseInputStream = null;
        if (this.inputStream != null) {
            temp = this.inputStream;
            this.inputStream = null;
            try {
                ((InputStream)temp).close();
            }
            catch (Exception ex) {
                LOG.debug((Object)"Exception caught when closing input", (Throwable)ex);
            }
        }
        if (this.outputStream != null) {
            temp = this.outputStream;
            this.outputStream = null;
            try {
                ((OutputStream)temp).close();
            }
            catch (Exception ex) {
                LOG.debug((Object)"Exception caught when closing output", (Throwable)ex);
            }
        }
        if (this.socket != null) {
            temp = this.socket;
            this.socket = null;
            try {
                ((Socket)temp).close();
            }
            catch (Exception ex) {
                LOG.debug((Object)"Exception caught when closing socket", (Throwable)ex);
            }
        }
        this.isOpen = false;
        this.used = false;
        this.tunnelEstablished = false;
        this.usingSecureSocket = false;
    }

    public void flushRequestOutputStream() throws IOException {
        LOG.trace((Object)"enter HttpConnection.flushRequestOutputStream()");
        this.assertOpen();
        this.outputStream.flush();
    }

    public String getHost() {
        return this.hostName;
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public InputStream getLastResponseInputStream() {
        return this.lastResponseInputStream;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getPort() {
        if (this.portNumber < 0) {
            return this.isSecure() ? 443 : 80;
        }
        return this.portNumber;
    }

    public Protocol getProtocol() {
        return this.protocolInUse;
    }

    public String getProxyHost() {
        return this.proxyHostName;
    }

    public int getProxyPort() {
        return this.proxyPortNumber;
    }

    public OutputStream getRequestOutputStream() throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.getRequestOutputStream()");
        this.assertOpen();
        OutputStream out = this.outputStream;
        if (Wire.enabled()) {
            out = new WireLogOutputStream(out);
        }
        return out;
    }

    public OutputStream getRequestOutputStream(boolean useChunking) throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.getRequestOutputStream(boolean)");
        OutputStream out = this.getRequestOutputStream();
        if (useChunking) {
            out = new ChunkedOutputStream(out);
        }
        return out;
    }

    public InputStream getResponseInputStream() throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.getResponseInputStream()");
        this.assertOpen();
        return this.inputStream;
    }

    public InputStream getResponseInputStream(HttpMethod method) throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.getResponseInputStream(HttpMethod)");
        return this.getResponseInputStream();
    }

    public int getSendBufferSize() throws SocketException {
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getSendBufferSize();
    }

    public int getSoTimeout() throws SocketException {
        LOG.debug((Object)"HttpConnection.getSoTimeout()");
        if (this.socket != null) {
            return this.socket.getSoTimeout();
        }
        return this.soTimeout;
    }

    public String getVirtualHost() {
        return this.virtualName;
    }

    public boolean isOpen() {
        if (this.used && this.isStaleCheckingEnabled() && this.isStale()) {
            LOG.debug((Object)"Connection is stale, closing...");
            this.close();
        }
        return this.isOpen;
    }

    public boolean isProxied() {
        return (this.proxyHostName == null || this.proxyPortNumber <= 0) ^ true;
    }

    public boolean isResponseAvailable() throws IOException {
        LOG.trace((Object)"enter HttpConnection.isResponseAvailable()");
        this.assertOpen();
        return this.inputStream.available() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isResponseAvailable(int timeout) throws IOException {
        LOG.trace((Object)"enter HttpConnection.isResponseAvailable(int)");
        this.assertOpen();
        boolean result = false;
        if (this.inputStream.available() > 0) {
            return true;
        }
        try {
            block7: {
                try {
                    this.socket.setSoTimeout(timeout);
                    int byteRead = this.inputStream.read();
                    if (byteRead != -1) {
                        this.inputStream.unread(byteRead);
                        LOG.debug((Object)"Input data available");
                        result = true;
                    } else {
                        LOG.debug((Object)"Input data not available");
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)("Input data not available after " + timeout + " ms"));
                }
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.socket.setSoTimeout(this.soTimeout);
            throw throwable;
        }
        this.socket.setSoTimeout(this.soTimeout);
        return result;
    }

    public boolean isSecure() {
        return this.protocolInUse.isSecure();
    }

    protected boolean isStale() {
        boolean isStale;
        block6: {
            isStale = true;
            if (!this.isOpen) break block6;
            isStale = false;
            try {
                block7: {
                    if (this.inputStream.available() != 0) break block6;
                    try {
                        this.socket.setSoTimeout(1);
                        int byteRead = this.inputStream.read();
                        if (byteRead == -1) {
                            isStale = true;
                            break block7;
                        }
                        this.inputStream.unread(byteRead);
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        this.socket.setSoTimeout(this.soTimeout);
                        throw throwable;
                    }
                }
                Object var3_3 = null;
                this.socket.setSoTimeout(this.soTimeout);
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException e) {
                LOG.debug((Object)"An error occurred while reading from the socket, is appears to be stale", (Throwable)e);
                isStale = true;
            }
        }
        return isStale;
    }

    public boolean isStaleCheckingEnabled() {
        return this.staleCheckingEnabled;
    }

    public boolean isTransparent() {
        return !this.isProxied() || this.tunnelEstablished;
    }

    public void open() throws IOException {
        LOG.trace((Object)"enter HttpConnection.open()");
        this.assertNotOpen();
        try {
            if (this.socket == null) {
                ProtocolSocketFactory socketFactory;
                final String host = this.proxyHostName == null ? this.hostName : this.proxyHostName;
                final int port = this.proxyHostName == null ? this.portNumber : this.proxyPortNumber;
                this.usingSecureSocket = this.isSecure() && !this.isProxied();
                ProtocolSocketFactory protocolSocketFactory = socketFactory = this.isSecure() && this.isProxied() ? new DefaultProtocolSocketFactory() : this.protocolInUse.getSocketFactory();
                if (this.connectTimeout == 0) {
                    this.socket = this.localAddress != null ? socketFactory.createSocket(host, port, this.localAddress, 0) : socketFactory.createSocket(host, port);
                } else {
                    SocketTask task = new SocketTask(this){

                        public void doit() throws IOException {
                            if (localAddress != null) {
                                this.setSocket(socketFactory.createSocket(host, port, localAddress, 0));
                            } else {
                                this.setSocket(socketFactory.createSocket(host, port));
                            }
                        }
                    };
                    TimeoutController.execute(task, (long)this.connectTimeout);
                    this.socket = task.getSocket();
                    if (task.exception != null) {
                        throw task.exception;
                    }
                }
            }
            this.socket.setTcpNoDelay(this.soNodelay);
            this.socket.setSoTimeout(this.soTimeout);
            if (this.sendBufferSize != -1) {
                this.socket.setSendBufferSize(this.sendBufferSize);
            }
            this.inputStream = new PushbackInputStream(this.socket.getInputStream());
            this.outputStream = new BufferedOutputStream(new WrappedOutputStream(this.socket.getOutputStream()), this.socket.getSendBufferSize());
            this.isOpen = true;
            this.used = false;
        }
        catch (IOException e) {
            this.closeSocketAndStreams();
            throw e;
        }
        catch (TimeoutController.TimeoutException timeoutException) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("The host " + this.hostName + ":" + this.portNumber + " (or proxy " + this.proxyHostName + ":" + this.proxyPortNumber + ") did not accept the connection within timeout of " + this.connectTimeout + " milliseconds"));
            }
            throw new ConnectionTimeoutException();
        }
    }

    public void print(String data) throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace((Object)"enter HttpConnection.print(String)");
        this.write(HttpConstants.getBytes(data));
    }

    public void printLine() throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace((Object)"enter HttpConnection.printLine()");
        this.writeLine();
    }

    public void printLine(String data) throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace((Object)"enter HttpConnection.printLine(String)");
        this.writeLine(HttpConstants.getBytes(data));
    }

    public String readLine() throws IOException, IllegalStateException {
        LOG.trace((Object)"enter HttpConnection.readLine()");
        this.assertOpen();
        return HttpParser.readLine(this.inputStream);
    }

    public void releaseConnection() {
        LOG.trace((Object)"enter HttpConnection.releaseConnection()");
        this.used = true;
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.releaseConnection(this);
        }
    }

    public void setConnectionTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public void setHost(String host) throws IllegalStateException {
        if (host == null) {
            throw new IllegalArgumentException("host parameter is null");
        }
        this.assertNotOpen();
        this.hostName = host;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    public void setLastResponseInputStream(InputStream inStream) {
        this.lastResponseInputStream = inStream;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.assertNotOpen();
        this.localAddress = localAddress;
    }

    public void setPort(int port) throws IllegalStateException {
        this.assertNotOpen();
        this.portNumber = port;
    }

    public void setProtocol(Protocol protocol) {
        this.assertNotOpen();
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        this.protocolInUse = protocol;
    }

    public void setProxyHost(String host) throws IllegalStateException {
        this.assertNotOpen();
        this.proxyHostName = host;
    }

    public void setProxyPort(int port) throws IllegalStateException {
        this.assertNotOpen();
        this.proxyPortNumber = port;
    }

    public void setSecure(boolean secure) throws IllegalStateException {
        this.assertNotOpen();
        this.protocolInUse = secure ? Protocol.getProtocol("https") : Protocol.getProtocol("http");
    }

    public void setSendBufferSize(int sendBufferSize) throws SocketException {
        this.sendBufferSize = sendBufferSize;
        if (this.socket != null) {
            this.socket.setSendBufferSize(sendBufferSize);
        }
    }

    public void setSoTimeout(int timeout) throws SocketException, IllegalStateException {
        LOG.debug((Object)("HttpConnection.setSoTimeout(" + timeout + ")"));
        this.soTimeout = timeout;
        if (this.socket != null) {
            this.socket.setSoTimeout(timeout);
        }
    }

    public void setStaleCheckingEnabled(boolean staleCheckEnabled) {
        this.staleCheckingEnabled = staleCheckEnabled;
    }

    public void setVirtualHost(String host) throws IllegalStateException {
        this.assertNotOpen();
        this.virtualName = host;
    }

    public void shutdownOutput() {
        LOG.trace((Object)"enter HttpConnection.shutdownOutput()");
        try {
            Class[] paramsClasses = new Class[]{};
            Method shutdownOutput = this.socket.getClass().getMethod("shutdownOutput", paramsClasses);
            Object[] params = new Object[]{};
            shutdownOutput.invoke((Object)this.socket, params);
        }
        catch (Exception ex) {
            LOG.debug((Object)"Unexpected Exception caught", (Throwable)ex);
        }
    }

    public void tunnelCreated() throws IllegalStateException, IOException {
        LOG.trace((Object)"enter HttpConnection.tunnelCreated()");
        if (!this.isSecure() || !this.isProxied()) {
            throw new IllegalStateException("Connection must be secure and proxied to use this feature");
        }
        if (this.usingSecureSocket) {
            throw new IllegalStateException("Already using a secure socket");
        }
        SecureProtocolSocketFactory socketFactory = (SecureProtocolSocketFactory)this.protocolInUse.getSocketFactory();
        this.socket = socketFactory.createSocket(this.socket, this.hostName, this.portNumber, true);
        if (this.sendBufferSize != -1) {
            this.socket.setSendBufferSize(this.sendBufferSize);
        }
        this.inputStream = new PushbackInputStream(this.socket.getInputStream());
        this.outputStream = new BufferedOutputStream(new WrappedOutputStream(this.socket.getOutputStream()), this.socket.getSendBufferSize());
        this.usingSecureSocket = true;
        this.tunnelEstablished = true;
        LOG.debug((Object)"Secure tunnel created");
    }

    public void write(byte[] data) throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace((Object)"enter HttpConnection.write(byte[])");
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace((Object)"enter HttpConnection.write(byte[], int, int)");
        if (offset + length > data.length) {
            throw new HttpRecoverableException("Unable to write: offset=" + offset + " length=" + length + " data.length=" + data.length);
        }
        if (data.length <= 0) {
            throw new HttpRecoverableException("Unable to write: data.length=" + data.length);
        }
        this.assertOpen();
        try {
            this.outputStream.write(data, offset, length);
        }
        catch (HttpRecoverableException hre) {
            throw hre;
        }
        catch (SocketException se) {
            LOG.debug((Object)"HttpConnection: Socket exception while writing data", (Throwable)se);
            throw new HttpRecoverableException(se.toString());
        }
        catch (IOException ioe) {
            LOG.debug((Object)"HttpConnection: Exception while writing data", (Throwable)ioe);
            throw ioe;
        }
    }

    public void writeLine() throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace((Object)"enter HttpConnection.writeLine()");
        this.write(CRLF);
    }

    public void writeLine(byte[] data) throws IOException, IllegalStateException, HttpRecoverableException {
        LOG.trace((Object)"enter HttpConnection.writeLine(byte[])");
        this.write(data);
        this.writeLine();
    }

    public class ConnectionTimeoutException
    extends IOException {
    }

    private abstract class SocketTask
    implements Runnable {
        private Socket socket;
        private IOException exception;

        SocketTask() {
        }

        public abstract void doit() throws IOException;

        protected Socket getSocket() {
            return this.socket;
        }

        public void run() {
            try {
                this.doit();
            }
            catch (IOException e) {
                this.exception = e;
            }
        }

        protected void setSocket(Socket newSocket) {
            this.socket = newSocket;
        }
    }

    private class WrappedOutputStream
    extends OutputStream {
        private OutputStream out;

        public WrappedOutputStream(OutputStream out) {
            this.out = out;
        }

        public void close() throws IOException {
            try {
                this.out.close();
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public void flush() throws IOException {
            try {
                this.out.flush();
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        private IOException handleException(IOException ioe) {
            boolean tempUsed = HttpConnection.this.used;
            HttpConnection.this.close();
            if (tempUsed) {
                LOG.debug((Object)"Output exception occurred on a used connection.  Will treat as recoverable.", (Throwable)ioe);
                return new HttpRecoverableException(ioe.toString());
            }
            return ioe;
        }

        public void write(int b) throws IOException {
            try {
                this.out.write(b);
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public void write(byte[] b) throws IOException {
            try {
                this.out.write(b);
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.out.write(b, off, len);
            }
            catch (IOException ioe) {
                throw this.handleException(ioe);
            }
        }
    }
}

