/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiThreadedHttpConnectionManager
implements HttpConnectionManager {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$MultiThreadedHttpConnectionManager != null ? class$org$apache$commons$httpclient$MultiThreadedHttpConnectionManager : (class$org$apache$commons$httpclient$MultiThreadedHttpConnectionManager = MultiThreadedHttpConnectionManager.class$("org.apache.commons.httpclient.MultiThreadedHttpConnectionManager"))));
    public static final int DEFAULT_MAX_HOST_CONNECTIONS = 2;
    public static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 20;
    private int maxHostConnections = 2;
    private int maxTotalConnections = 20;
    private boolean connectionStaleCheckingEnabled = true;
    private ConnectionPool connectionPool;
    private Map referenceToHostConfig = Collections.synchronizedMap(new HashMap());
    private ReferenceQueue referenceQueue;
    static /* synthetic */ Class class$org$apache$commons$httpclient$MultiThreadedHttpConnectionManager;

    public MultiThreadedHttpConnectionManager() {
        this.connectionPool = new ConnectionPool();
        this.referenceQueue = new ReferenceQueue();
        new ReferenceQueueThread().start();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private HostConfiguration configurationForConnection(HttpConnection conn) {
        HostConfiguration connectionConfiguration = new HostConfiguration();
        connectionConfiguration.setHost(conn.getHost(), conn.getVirtualHost(), conn.getPort(), conn.getProtocol());
        if (conn.getLocalAddress() != null) {
            connectionConfiguration.setLocalAddress(conn.getLocalAddress());
        }
        if (conn.getProxyHost() != null) {
            connectionConfiguration.setProxy(conn.getProxyHost(), conn.getProxyPort());
        }
        return connectionConfiguration;
    }

    private HttpConnection doGetConnection(HostConfiguration hostConfiguration, long timeout) throws HttpException {
        HttpConnection connection = null;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            hostConfiguration = new HostConfiguration(hostConfiguration);
            HostConnectionPool hostPool = this.connectionPool.getHostPool(hostConfiguration);
            WaitingThread waitingThread = null;
            boolean useTimeout = timeout > 0L;
            long timeToWait = timeout;
            long startWait = 0L;
            long endWait = 0L;
            while (connection == null) {
                Object var17_11;
                if (hostPool.freeConnections.size() > 0) {
                    connection = this.connectionPool.getFreeConnection(hostConfiguration);
                    continue;
                }
                if (hostPool.numConnections < this.maxHostConnections && this.connectionPool.numConnections < this.maxTotalConnections) {
                    connection = this.connectionPool.createConnection(hostConfiguration);
                    continue;
                }
                if (hostPool.numConnections < this.maxHostConnections && this.connectionPool.freeConnections.size() > 0) {
                    this.connectionPool.deleteLeastUsedConnection();
                    connection = this.connectionPool.createConnection(hostConfiguration);
                    continue;
                }
                try {
                    try {
                        if (useTimeout && timeToWait <= 0L) {
                            throw new HttpException("Timeout waiting for connection");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Unable to get a connection, waiting..., hostConfig=" + hostConfiguration));
                        }
                        if (waitingThread == null) {
                            waitingThread = new WaitingThread();
                            waitingThread.hostConnectionPool = hostPool;
                            waitingThread.thread = Thread.currentThread();
                        }
                        if (useTimeout) {
                            startWait = System.currentTimeMillis();
                        }
                        hostPool.waitingThreads.addLast(waitingThread);
                        this.connectionPool.waitingThreads.addLast(waitingThread);
                        this.connectionPool.wait(timeToWait);
                        hostPool.waitingThreads.remove(waitingThread);
                        this.connectionPool.waitingThreads.remove(waitingThread);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    var17_11 = null;
                    if (!useTimeout) continue;
                }
                catch (Throwable throwable) {
                    var17_11 = null;
                    if (useTimeout) {
                        endWait = System.currentTimeMillis();
                        timeToWait -= endWait - startWait;
                    }
                    throw throwable;
                }
                endWait = System.currentTimeMillis();
                timeToWait -= endWait - startWait;
            }
        }
        return connection;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration) {
        while (true) {
            try {
                return this.getConnection(hostConfiguration, 0L);
            }
            catch (HttpException e) {
                LOG.debug((Object)"Unexpected exception while waiting for connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long timeout) throws HttpException {
        LOG.trace((Object)"enter HttpConnectionManager.getConnection(HostConfiguration, long)");
        if (hostConfiguration == null) {
            throw new IllegalArgumentException("hostConfiguration is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HttpConnectionManager.getConnection:  config = " + hostConfiguration + ", timeout = " + timeout));
        }
        HttpConnection conn = this.doGetConnection(hostConfiguration, timeout);
        return new HttpConnectionAdapter(conn);
    }

    public int getConnectionsInUse() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            int n = this.connectionPool.numConnections;
            Object var3_3 = null;
            return n;
        }
    }

    public int getConnectionsInUse(HostConfiguration hostConfiguration) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            HostConnectionPool hostPool = this.connectionPool.getHostPool(hostConfiguration);
            int n = hostPool.numConnections;
            Object var4_5 = null;
            return n;
        }
    }

    public int getMaxConnectionsPerHost() {
        return this.maxHostConnections;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public boolean isConnectionStaleCheckingEnabled() {
        return this.connectionStaleCheckingEnabled;
    }

    public void releaseConnection(HttpConnection conn) {
        LOG.trace((Object)"enter HttpConnectionManager.releaseConnection(HttpConnection)");
        if (conn instanceof HttpConnectionAdapter) {
            conn = ((HttpConnectionAdapter)conn).getWrappedConnection();
        }
        SimpleHttpConnectionManager.finishLastResponse(conn);
        this.connectionPool.freeConnection(conn);
    }

    public void setConnectionStaleCheckingEnabled(boolean connectionStaleCheckingEnabled) {
        this.connectionStaleCheckingEnabled = connectionStaleCheckingEnabled;
    }

    public void setMaxConnectionsPerHost(int maxHostConnections) {
        this.maxHostConnections = maxHostConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    private class ConnectionPool {
        private LinkedList freeConnections = new LinkedList();
        private LinkedList waitingThreads = new LinkedList();
        private final Map mapHosts = new HashMap();
        private int numConnections = 0;

        ConnectionPool() {
        }

        public synchronized HttpConnection createConnection(HostConfiguration hostConfiguration) {
            HttpConnection connection = null;
            HostConnectionPool hostPool = this.getHostPool(hostConfiguration);
            if (hostPool.numConnections < MultiThreadedHttpConnectionManager.this.getMaxConnectionsPerHost() && this.numConnections < MultiThreadedHttpConnectionManager.this.getMaxTotalConnections()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Allocating new connection, hostConfig=" + hostConfiguration));
                }
                connection = new HttpConnection(hostConfiguration);
                connection.setStaleCheckingEnabled(MultiThreadedHttpConnectionManager.this.connectionStaleCheckingEnabled);
                connection.setHttpConnectionManager(MultiThreadedHttpConnectionManager.this);
                ++this.numConnections;
                ++hostPool.numConnections;
                MultiThreadedHttpConnectionManager.this.referenceToHostConfig.put(new WeakReference<HttpConnection>(connection, MultiThreadedHttpConnectionManager.this.referenceQueue), hostConfiguration);
            } else if (LOG.isDebugEnabled()) {
                if (hostPool.numConnections >= MultiThreadedHttpConnectionManager.this.getMaxConnectionsPerHost()) {
                    LOG.debug((Object)("No connection allocated, host pool has already reached maxConnectionsPerHost, hostConfig=" + hostConfiguration + ", maxConnectionsPerhost=" + MultiThreadedHttpConnectionManager.this.getMaxConnectionsPerHost()));
                } else {
                    LOG.debug((Object)("No connection allocated, maxTotalConnections reached, maxTotalConnections=" + MultiThreadedHttpConnectionManager.this.getMaxTotalConnections()));
                }
            }
            return connection;
        }

        public synchronized void deleteLeastUsedConnection() {
            HttpConnection connection = (HttpConnection)this.freeConnections.removeFirst();
            if (connection != null) {
                HostConfiguration connectionConfiguration = MultiThreadedHttpConnectionManager.this.configurationForConnection(connection);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Reclaiming unused connection, hostConfig=" + connectionConfiguration));
                }
                connection.close();
                Iterator iter = MultiThreadedHttpConnectionManager.this.referenceToHostConfig.keySet().iterator();
                while (iter.hasNext()) {
                    WeakReference connectionRef = (WeakReference)iter.next();
                    if (connectionRef.get() != connection) continue;
                    iter.remove();
                    connectionRef.enqueue();
                    break;
                }
                HostConnectionPool hostPool = this.getHostPool(connectionConfiguration);
                hostPool.freeConnections.remove(connection);
                --hostPool.numConnections;
                --this.numConnections;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Attempted to reclaim an unused connection but there were none.");
            }
        }

        public void freeConnection(HttpConnection conn) {
            HostConfiguration connectionConfiguration = MultiThreadedHttpConnectionManager.this.configurationForConnection(conn);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Freeing connection, hostConfig=" + connectionConfiguration));
            }
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                HostConnectionPool hostPool = this.getHostPool(connectionConfiguration);
                hostPool.freeConnections.add(conn);
                if (hostPool.numConnections == 0) {
                    LOG.error((Object)("Host connection pool not found, hostConfig=" + connectionConfiguration));
                    hostPool.numConnections = 1;
                }
                this.freeConnections.add(conn);
                if (this.numConnections == 0) {
                    LOG.error((Object)("Host connection pool not found, hostConfig=" + connectionConfiguration));
                    this.numConnections = 1;
                }
                this.notifyWaitingThread(hostPool);
            }
        }

        public synchronized HttpConnection getFreeConnection(HostConfiguration hostConfiguration) {
            HttpConnection connection = null;
            HostConnectionPool hostPool = this.getHostPool(hostConfiguration);
            if (hostPool.freeConnections.size() > 0) {
                connection = (HttpConnection)hostPool.freeConnections.removeFirst();
                this.freeConnections.remove(connection);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Getting free connection, hostConfig=" + hostConfiguration));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("There were no free connections to get, hostConfig=" + hostConfiguration));
            }
            return connection;
        }

        public synchronized HostConnectionPool getHostPool(HostConfiguration hostConfiguration) {
            LOG.trace((Object)"enter HttpConnectionManager.ConnectionPool.getHostPool(HostConfiguration)");
            HostConnectionPool listConnections = (HostConnectionPool)this.mapHosts.get(hostConfiguration);
            if (listConnections == null) {
                listConnections = new HostConnectionPool();
                listConnections.hostConfiguration = hostConfiguration;
                this.mapHosts.put(hostConfiguration, listConnections);
            }
            return listConnections;
        }

        public synchronized void notifyWaitingThread(HostConfiguration configuration) {
            this.notifyWaitingThread(this.getHostPool(configuration));
        }

        public synchronized void notifyWaitingThread(HostConnectionPool hostPool) {
            WaitingThread waitingThread = null;
            if (hostPool.waitingThreads.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Notifying thread waiting on host pool, hostConfig=" + hostPool.hostConfiguration));
                }
                waitingThread = (WaitingThread)hostPool.waitingThreads.removeFirst();
                this.waitingThreads.remove(waitingThread);
            } else if (this.waitingThreads.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No-one waiting on host pool, notifying next waiting thread.");
                }
                waitingThread = (WaitingThread)this.waitingThreads.removeFirst();
                waitingThread.hostConnectionPool.waitingThreads.remove(waitingThread);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Notifying no-one, there are no waiting threads");
            }
            if (waitingThread != null) {
                waitingThread.thread.interrupt();
            }
        }
    }

    private class HostConnectionPool {
        public HostConfiguration hostConfiguration;
        public LinkedList freeConnections = new LinkedList();
        public LinkedList waitingThreads = new LinkedList();
        public int numConnections = 0;

        HostConnectionPool() {
        }
    }

    private class WaitingThread {
        public Thread thread;
        public HostConnectionPool hostConnectionPool;

        WaitingThread() {
        }
    }

    private class ReferenceQueueThread
    extends Thread {
        public ReferenceQueueThread() {
            this.setDaemon(true);
        }

        private void handleReference(Reference ref) {
            ConnectionPool connectionPool = MultiThreadedHttpConnectionManager.this.connectionPool;
            synchronized (connectionPool) {
                if (MultiThreadedHttpConnectionManager.this.referenceToHostConfig.containsKey(ref)) {
                    HostConfiguration config = (HostConfiguration)MultiThreadedHttpConnectionManager.this.referenceToHostConfig.get(ref);
                    MultiThreadedHttpConnectionManager.this.referenceToHostConfig.remove(ref);
                    HostConnectionPool hostPool = MultiThreadedHttpConnectionManager.this.connectionPool.getHostPool(config);
                    --hostPool.numConnections;
                    ConnectionPool connectionPool2 = MultiThreadedHttpConnectionManager.this.connectionPool;
                    connectionPool2.numConnections = connectionPool2.numConnections - 1;
                    MultiThreadedHttpConnectionManager.this.connectionPool.notifyWaitingThread(config);
                }
            }
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Reference ref;
                        if ((ref = MultiThreadedHttpConnectionManager.this.referenceQueue.remove()) == null) {
                            continue;
                        }
                        this.handleReference(ref);
                    }
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"ReferenceQueueThread interrupted", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private static class HttpConnectionAdapter
    extends HttpConnection {
        private HttpConnection wrappedConnection;

        public HttpConnectionAdapter(HttpConnection connection) {
            super(connection.getHost(), connection.getPort(), connection.getProtocol());
            this.wrappedConnection = connection;
        }

        public void close() {
            if (this.hasConnection()) {
                this.wrappedConnection.close();
            }
        }

        public void flushRequestOutputStream() throws IOException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.flushRequestOutputStream();
        }

        public String getHost() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getHost();
            }
            return null;
        }

        public HttpConnectionManager getHttpConnectionManager() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getHttpConnectionManager();
            }
            return null;
        }

        public InputStream getLastResponseInputStream() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getLastResponseInputStream();
            }
            return null;
        }

        public InetAddress getLocalAddress() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getLocalAddress();
            }
            return null;
        }

        public int getPort() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getPort();
            }
            return -1;
        }

        public Protocol getProtocol() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getProtocol();
            }
            return null;
        }

        public String getProxyHost() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getProxyHost();
            }
            return null;
        }

        public int getProxyPort() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getProxyPort();
            }
            return -1;
        }

        public OutputStream getRequestOutputStream() throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getRequestOutputStream();
            }
            return null;
        }

        public OutputStream getRequestOutputStream(boolean useChunking) throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getRequestOutputStream(useChunking);
            }
            return null;
        }

        public InputStream getResponseInputStream() throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getResponseInputStream();
            }
            return null;
        }

        public InputStream getResponseInputStream(HttpMethod method) throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getResponseInputStream(method);
            }
            return null;
        }

        public int getSendBufferSize() throws SocketException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getSendBufferSize();
            }
            throw new IllegalStateException("Connection has been released");
        }

        public int getSoTimeout() throws SocketException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getSoTimeout();
            }
            throw new IllegalStateException("Connection has been released");
        }

        public String getVirtualHost() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getVirtualHost();
            }
            throw new IllegalStateException("Connection has been released");
        }

        HttpConnection getWrappedConnection() {
            return this.wrappedConnection;
        }

        protected boolean hasConnection() {
            return this.wrappedConnection != null;
        }

        public boolean isOpen() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isOpen();
            }
            return false;
        }

        public boolean isProxied() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isProxied();
            }
            return false;
        }

        public boolean isResponseAvailable() throws IOException {
            if (this.hasConnection()) {
                return this.wrappedConnection.isResponseAvailable();
            }
            return false;
        }

        public boolean isResponseAvailable(int timeout) throws IOException {
            if (this.hasConnection()) {
                return this.wrappedConnection.isResponseAvailable(timeout);
            }
            return false;
        }

        public boolean isSecure() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isSecure();
            }
            return false;
        }

        public boolean isStaleCheckingEnabled() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isStaleCheckingEnabled();
            }
            return false;
        }

        public boolean isTransparent() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isTransparent();
            }
            return false;
        }

        public void open() throws IOException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.open();
        }

        public void print(String data) throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.print(data);
        }

        public void printLine() throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.printLine();
        }

        public void printLine(String data) throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.printLine(data);
        }

        public String readLine() throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.readLine();
            }
            throw new IllegalStateException("Connection has been released");
        }

        public void releaseConnection() {
            if (this.hasConnection()) {
                HttpConnection wrappedConnection = this.wrappedConnection;
                this.wrappedConnection = null;
                wrappedConnection.releaseConnection();
            }
        }

        public void setConnectionTimeout(int timeout) {
            if (this.hasConnection()) {
                this.wrappedConnection.setConnectionTimeout(timeout);
            }
        }

        public void setHost(String host) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setHost(host);
            }
        }

        public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
            if (this.hasConnection()) {
                this.wrappedConnection.setHttpConnectionManager(httpConnectionManager);
            }
        }

        public void setLastResponseInputStream(InputStream inStream) {
            if (this.hasConnection()) {
                this.wrappedConnection.setLastResponseInputStream(inStream);
            }
        }

        public void setLocalAddress(InetAddress localAddress) {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setLocalAddress(localAddress);
        }

        public void setPort(int port) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setPort(port);
            }
        }

        public void setProtocol(Protocol protocol) {
            if (this.hasConnection()) {
                this.wrappedConnection.setProtocol(protocol);
            }
        }

        public void setProxyHost(String host) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setProxyHost(host);
            }
        }

        public void setProxyPort(int port) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setProxyPort(port);
            }
        }

        public void setSecure(boolean secure) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setSecure(secure);
            }
        }

        public void setSendBufferSize(int sendBufferSize) throws SocketException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setSendBufferSize(sendBufferSize);
        }

        public void setSoTimeout(int timeout) throws SocketException, IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setSoTimeout(timeout);
            }
        }

        public void setStaleCheckingEnabled(boolean staleCheckEnabled) {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setStaleCheckingEnabled(staleCheckEnabled);
        }

        public void setVirtualHost(String host) throws IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setVirtualHost(host);
        }

        public void shutdownOutput() {
            if (this.hasConnection()) {
                this.wrappedConnection.shutdownOutput();
            }
        }

        public void tunnelCreated() throws IllegalStateException, IOException {
            if (this.hasConnection()) {
                this.wrappedConnection.tunnelCreated();
            }
        }

        public void write(byte[] data) throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.write(data);
        }

        public void write(byte[] data, int offset, int length) throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.write(data, offset, length);
        }

        public void writeLine() throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.writeLine();
        }

        public void writeLine(byte[] data) throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.writeLine(data);
        }
    }
}

