/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods.multipart;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilePart
extends Part {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    public static final String DEFAULT_TRANSFER_ENCODING = "binary";
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$methods$multipart$FilePart != null ? class$org$apache$commons$httpclient$methods$multipart$FilePart : (class$org$apache$commons$httpclient$methods$multipart$FilePart = FilePart.class$("org.apache.commons.httpclient.methods.multipart.FilePart"))));
    protected static final String FILE_NAME = "; filename=";
    protected static final byte[] FILE_NAME_BYTES = HttpConstants.getAsciiBytes("; filename=");
    private String name;
    private PartSource source;
    private String contentType;
    private String charset;
    static /* synthetic */ Class class$org$apache$commons$httpclient$methods$multipart$FilePart;

    public FilePart(String name, File file) throws FileNotFoundException {
        this(name, new FilePartSource(file), null, null);
    }

    public FilePart(String name, File file, String contentType, String charset) throws FileNotFoundException {
        this(name, new FilePartSource(file), contentType, charset);
    }

    public FilePart(String name, String fileName, File file) throws FileNotFoundException {
        this(name, new FilePartSource(fileName, file), null, null);
    }

    public FilePart(String name, String fileName, File file, String contentType, String charset) throws FileNotFoundException {
        this(name, new FilePartSource(fileName, file), contentType, charset);
    }

    public FilePart(String name, PartSource partSource) {
        this(name, partSource, null, null);
    }

    public FilePart(String name, PartSource partSource, String contentType, String charset) {
        LOG.trace((Object)"enter FilePart(String, PartSource, String, String)");
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.name = name;
        if (partSource == null) {
            throw new IllegalArgumentException("Source may not be null");
        }
        if (partSource.getLength() < 0L) {
            throw new IllegalArgumentException("Source length must be >= 0");
        }
        this.source = partSource;
        this.contentType = contentType != null ? contentType : DEFAULT_CONTENT_TYPE;
        this.charset = charset;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String getCharSet() {
        return this.charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getTransferEncoding() {
        return DEFAULT_TRANSFER_ENCODING;
    }

    protected long lengthOfData() throws IOException {
        LOG.trace((Object)"enter lengthOfData()");
        return this.source.getLength();
    }

    protected void sendData(OutputStream out) throws IOException {
        LOG.trace((Object)"enter sendData(OutputStream out)");
        if (this.lengthOfData() == 0L) {
            LOG.debug((Object)"No data to send.");
            return;
        }
        byte[] tmp = new byte[4096];
        InputStream instream = this.source.createInputStream();
        try {
            int len;
            while ((len = instream.read(tmp)) >= 0) {
                out.write(tmp, 0, len);
            }
        }
        finally {
            Object var5_5 = null;
            instream.close();
        }
    }

    protected void sendDispositionHeader(OutputStream out) throws IOException {
        LOG.trace((Object)"enter sendDispositionHeader(OutputStream out)");
        super.sendDispositionHeader(out);
        String filename = this.source.getFileName();
        if (filename != null) {
            out.write(FILE_NAME_BYTES);
            out.write(Part.QUOTE_BYTES);
            out.write(HttpConstants.getAsciiBytes(filename));
            out.write(Part.QUOTE_BYTES);
        }
    }
}

