/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.gemss.applications.performance.rapt;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Job {
    private Logger mlogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.applications.performance.rapt");
    private int jid;
    private String sessionId;
    private String startTime;
    private String stopTime;
    private String nodeMap;

    public void setJobParams(List par) {
        this.mlogger.log(Level.WARNING, "Performance model: setJobParams() called but not implemented");
    }

    public void readJobParams(String sessionDir) {
        String filename = sessionDir.concat("/.aux");
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            String line = new String();
            line = in.readLine();
            Pattern p = Pattern.compile("<pid>(\\d+)</pid>");
            Matcher m = p.matcher(line);
            if (m.find()) {
                this.jid = Integer.valueOf(m.group(1));
            } else {
                this.mlogger.log(Level.WARNING, "Performance model: Failed to find jid: " + line);
            }
            p = Pattern.compile("<sessionId>(.*)</sessionId>");
            line = in.readLine();
            m = p.matcher(line);
            if (m.find()) {
                this.sessionId = m.group(1);
            } else {
                this.mlogger.log(Level.WARNING, "Performance model: Failed to find session ID: " + line);
            }
            line = in.readLine();
            line = in.readLine();
            line = in.readLine();
            line = in.readLine();
            line = in.readLine();
            p = Pattern.compile("<startTime>(.*)</startTime>");
            m = p.matcher(line);
            if (m.find()) {
                this.startTime = m.group(1);
            } else {
                this.mlogger.log(Level.WARNING, "Performance model: Failed to find start time: " + line);
            }
            line = in.readLine();
            p = Pattern.compile("<stopTime>(.*)</stopTime>");
            m = p.matcher(line);
            if (m.find()) {
                this.stopTime = m.group(1);
            } else {
                this.mlogger.log(Level.WARNING, "Performance model: Failed to find stop time: " + line);
            }
            line = in.readLine();
            p = Pattern.compile("<nodeMap>(.*)</nodeMap>");
            m = p.matcher(line);
            if (m.find()) {
                this.nodeMap = m.group(1);
            } else {
                this.mlogger.log(Level.WARNING, "Performance model: Failed to find node map: " + line);
            }
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            String msg = "Error cannot locate file: " + fnfe.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: readJobParams file not found error " + msg, fnfe);
            throw new RuntimeException(msg, fnfe);
        }
        catch (Exception ex) {
            String msg = "Error opening file '" + filename + "': " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: readJobParams error " + msg, ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model init error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public String toString() {
        return this.jid + "," + this.sessionId + "," + this.startTime + "," + this.stopTime + "," + this.nodeMap;
    }

    public String report() {
        String str = "Job Id       : " + this.jid + "\nSession Id   : " + this.sessionId + "\nStart time   : " + this.startTime + "\nStop time    : " + this.stopTime;
        return str;
    }
}

