/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.gemss.applications.performance.rapt;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.Resource;

public class NecCluster
implements Resource {
    private Logger mlogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.applications.performance.rapt");
    private int cpuSpeed;
    private int ram;
    private int netSpeed;
    private int nodes;
    private int numProc;

    public List getResource() {
        try {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(new Integer(this.nodes));
            list.add(new Integer(this.numProc));
            return list;
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: getResource error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void setResource(List rsc) {
        try {
            Integer g = (Integer)rsc.get(0);
            this.nodes = g;
            g = (Integer)rsc.get(1);
            this.numProc = g;
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: setResource error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void setResource(int n, int p) {
        this.nodes = n;
        this.numProc = p;
    }

    public void readResource(String sessionDir) {
        String filename = sessionDir.concat("/.aux");
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            String line = new String();
            line = in.readLine();
            line = in.readLine();
            Pattern p = Pattern.compile("<numOfNodes>(\\d+)</numOfNodes>");
            line = in.readLine();
            Matcher m = p.matcher(line);
            if (!m.find()) {
                throw new RuntimeException("Failed to find jid: " + line);
            }
            this.nodes = Integer.valueOf(m.group(1));
            p = Pattern.compile("<numOfProcs>(\\d+)</numOfProcs>");
            line = in.readLine();
            m = p.matcher(line);
            if (m.find()) {
                this.numProc = Integer.valueOf(m.group(1));
            } else {
                System.out.println("Failed to find number of procs: " + line);
            }
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            String msg = "Error cannot locate file " + fnfe.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: readResource file not found error " + msg, fnfe);
            throw new RuntimeException(msg, fnfe);
        }
        catch (Exception ex) {
            String msg = "Error opening file '" + filename + "': " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: readResource error " + msg, ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: readResource error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public String toString() {
        return this.nodes + "," + this.numProc;
    }

    public static void main(String[] args) {
        NecCluster nc = new NecCluster();
        nc.readResource(".");
    }

    public int getNumOfProcs() {
        return this.numProc;
    }

    public int getProc() {
        return this.nodes * this.numProc;
    }

    public int getNodes() {
        return this.nodes;
    }
}

