/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.gemss.applications.performance.rapt;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.Base64;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.NecCluster;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.RaptModel;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.RaptShot;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.RaptTime;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.RaptWorkload;

public class RaptJob {
    private Logger mlogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.applications.performance.rapt");
    private String database;
    private int workSoFar;
    private String workDir;
    private int multishots;
    private int workload;
    private int completedWorkSoFar;
    private String sessionName;
    private String userName;
    private NecCluster _rsc;
    private RaptWorkload _work;
    private RaptTime _time;
    private List time;
    private RaptModel _rm;

    public RaptJob(String strRW, String strRes) {
        try {
            this._rm = new RaptModel();
            this._rsc = new NecCluster();
            int startIdx = strRW.indexOf("<Value>");
            if (startIdx == -1) {
                throw new Exception("Error cannot find start substring index");
            }
            int endIdx = strRW.indexOf("</Value>");
            if (endIdx == -1) {
                throw new Exception("Error cannot find end substring index");
            }
            if (endIdx - startIdx - 7 < 0) {
                throw new Exception("Error cannot extract substring (" + endIdx + ", " + startIdx + ")");
            }
            String clearRW = strRW.substring(startIdx + 7, endIdx);
            this.mlogger.log(Level.INFO, "Performamce model: The extracted serialised object is:\n" + clearRW);
            byte[] ba = clearRW.getBytes();
            ObjectInputStream in = new ObjectInputStream(new Base64.InputStream(new ByteArrayInputStream(ba)));
            this._work = (RaptWorkload)in.readObject();
            this.mlogger.log(Level.INFO, "Performance model: The unserialized object is:\n" + this._work);
        }
        catch (IOException ex1) {
            String msg = "Problem loading the resource description: " + ex1.getMessage();
            this.mlogger.log(Level.SEVERE, "Performamce model: IO error " + msg, ex1);
            throw new RuntimeException(msg, ex1);
        }
        catch (Exception ex3) {
            String msg = "Exception: " + ex3.getMessage();
            this.mlogger.log(Level.INFO, "Performance model: init error", ex3);
            throw new RuntimeException(msg, ex3);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: init error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
        try {
            this._time = new RaptTime();
            this.time = new ArrayList();
            this.workload = 0;
            this.completedWorkSoFar = 0;
            this.sessionName = "unknown";
            this.userName = "unknown";
            this.multishots = this._work.getMultiplicity();
            for (int i = 0; i < this.multishots; ++i) {
                this.time.add(new RaptTime());
            }
            int first = strRes.indexOf("<number-of-nodes>");
            String submachineDesc = strRes.substring(new String("<number-of-nodes>").length() + first);
            String number = submachineDesc.substring(0, submachineDesc.indexOf("</")).trim();
            int nodes = Integer.parseInt(number);
            this._rsc.setResource(nodes, 2);
        }
        catch (Exception ex) {
            String msg = "Initialisation error: " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model init error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model init error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public RaptJob(String sessionDir) {
        try {
            this._rm = new RaptModel();
            this._rsc = new NecCluster();
            this._work = new RaptWorkload(sessionDir);
            this._time = new RaptTime();
            this.time = new ArrayList();
            this.workDir = sessionDir;
            this.workload = 0;
            this.completedWorkSoFar = 0;
            this.sessionName = "unknown";
            this.userName = "unknown";
            this._work.readWorkload(this.workDir);
            this.multishots = this._work.getMultiplicity();
            for (int i = 0; i < this.multishots; ++i) {
                this.time.add(new RaptTime());
            }
            this._rsc.readResource(sessionDir);
        }
        catch (Exception ex) {
            String msg = "Initialisation error: " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: init error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: init error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void updateRaptDb(String dbName) {
        try {
            this.mlogger.log(Level.INFO, "Performance model: Update RAPT DB file " + dbName);
            String[] multifort = this.findFile(this.workDir, "VARIANCE[0-9][0-9].out|VARIANCE.out");
            for (int i = 0; i < multifort.length; ++i) {
                RaptShot rs = (RaptShot)this._work.getShots().get(i);
                RaptTime rt = new RaptTime();
                rt.readRealTime(this.workDir, multifort[i]);
                double[] lt = new double[]{this.findTime(i), 0.0, 0.0};
                rt.setEstimateTime(lt);
                this.mlogger.log(Level.INFO, "Prediction time [" + i + "]: " + rt);
            }
        }
        catch (Exception ex) {
            String msg = "Error updatng RAPT DB: " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: updateRaptDb error " + msg, ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: init error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public long findTime(int idx) {
        double comp = 0.0;
        double comm = 0.0;
        try {
            int proc = this._rsc.getNumOfProcs();
            RaptShot rs = (RaptShot)this._work.getShots().get(idx);
            int geom = 80;
            double Fphoton = 0.0079 * (double)this._work.getPhotons() - 0.7385;
            double Fbeam = 1.0 + 0.0789 * (double)(rs.getBeams() - 201) / 15.8664;
            double Fnodes = 1.0 / Math.pow(proc, 1.004);
            double Fgeom = 1.0 + 0.1556 * (double)(geom - 80) / 15.5308;
            comp = Fphoton * Fbeam * Fnodes * Fgeom;
            comm = 1000.0 * (29.498 * (double)proc - 6.2424);
            this.mlogger.log(Level.INFO, "Performance model: findTime [shot " + idx + "] estCPU " + comp + " estComm " + comm + " estTotal " + (comp + comm));
            return (long)(comp + comm);
        }
        catch (Exception ex) {
            String msg = "Error in findTime: " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: findTime error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: init error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void getStatus() {
        boolean nphots = false;
        int modBeam = 1;
        int modBatch = 1;
        int pace = 1;
        try {
            System.out.println("*****************************\n* RAPT Job Progresss Report *\n*****************************\n\nMultiplicity: " + this.multishots + "\n");
            int numOfProcessors = this._rsc.getProc();
            String[] completeShots = this.findFile(this.workDir, "monitor[0-9][0-9].out");
            String currentStatus = "Current job status\n";
            for (int i = 0; i < completeShots.length; ++i) {
                RaptShot rs = this._work.getShot(i);
                this.completedWorkSoFar += this._work.getPhotons() * rs.getBeams();
                currentStatus = currentStatus + "-------------------------\nShot " + (i + 1) + "\n" + rs.report() + "\nShot status          : COMPLETE\n";
                currentStatus = currentStatus + "Real, estimate times : " + this.findTime1(rs, completeShots[i], i) + "\n";
            }
            int remainingShots = this.multishots - completeShots.length;
            File monitor = new File("monitor.out");
            if (monitor.exists() && completeShots.length < this.multishots) {
                --remainingShots;
                currentStatus = currentStatus + "-------------------------\nShot " + (completeShots.length + 1) + "\n";
                RaptShot rs = this._work.getShot(completeShots.length);
                currentStatus = currentStatus + rs.report() + "\nShot status          : RUNNING ";
                int numOfPhotons = this._work.getPhotons();
                int numOfBeams = rs.getBeams();
                int batch = this._work.getBatches();
                try {
                    Matcher m;
                    Pattern p;
                    BufferedReader in = new BufferedReader(new FileReader("monitor.out"));
                    String line = new String();
                    int count = 3;
                    int beamIdx = 0;
                    int idx = 0;
                    int batchIdx = 0;
                    line = in.readLine();
                    line = in.readLine();
                    line = in.readLine();
                    if (line != null) {
                        p = Pattern.compile("^\\s*Done\\s*([\\d]+)\\s*.*$");
                        m = p.matcher(line);
                        if (m.find()) {
                            pace = Integer.valueOf(m.group(1));
                            modBeam = numOfPhotons / pace / batch + 1;
                            modBatch = numOfBeams * (1 + numOfPhotons / pace / batch) + 1;
                        } else {
                            System.err.println("Warning cannot find pace (possible cause too few photons)");
                        }
                    }
                    int naxNumOfLines = batch * numOfBeams * modBeam + 1;
                    idx = 1;
                    beamIdx = 0;
                    int readBeamNum = 0;
                    while ((line = in.readLine()) != null) {
                        if (count % modBatch == 0) {
                            ++batchIdx;
                            beamIdx = -1;
                            idx = 0;
                            ++count;
                            continue;
                        }
                        if ((count - batchIdx - 1) % modBeam == 0) {
                            p = Pattern.compile("^.*\\s+([\\d]+)\\s+nphots\\s*([\\d]+)\\s*$");
                            m = p.matcher(line);
                            if (m.find()) {
                                readBeamNum = Integer.valueOf(m.group(1));
                            }
                            ++beamIdx;
                            idx = 0;
                            ++count;
                            continue;
                        }
                        ++idx;
                        ++count;
                    }
                    if (beamIdx < 0) {
                        beamIdx = 0;
                    }
                    this.workSoFar = batchIdx * numOfBeams * numOfPhotons / batch + (beamIdx * numOfPhotons / batch + idx * pace);
                    int shotWorkload = this._work.getPhotons() * rs.getBeams();
                    float estWork = 100.0f * ((float)this.workSoFar / (float)shotWorkload);
                    currentStatus = currentStatus + "on " + numOfProcessors + " processors\n" + "Completed work       : ";
                    NumberFormat form = NumberFormat.getInstance();
                    form.setMaximumFractionDigits(2);
                    currentStatus = currentStatus + form.format(estWork) + "%" + " (" + this.workSoFar + "/" + shotWorkload + ")" + "\nBatches              : " + batchIdx + "/" + batch + (modBeam - 1) + " (pace: " + pace + ")";
                    currentStatus = currentStatus + "\nReal, estimate times : " + this.findTime1(rs, "NULL", completeShots.length) + "\n";
                    System.out.println(currentStatus);
                    currentStatus = "";
                    if ((int)estWork == 100) {
                        System.out.println("shot " + (completeShots.length + 1) + " FINISHED");
                    }
                    in.close();
                }
                catch (FileNotFoundException fnfe) {
                    String msg = "Cannot locate file: " + fnfe.getMessage();
                    this.mlogger.log(Level.SEVERE, "Performance model: getStatus file not found error " + msg, fnfe);
                    throw new RuntimeException(msg, fnfe);
                }
                catch (Exception ex) {
                    String msg = "Error opening file 'monitor.out': " + ex.getMessage();
                    this.mlogger.log(Level.SEVERE, "Performamce model: getStatus error " + msg, ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            if (remainingShots > 0) {
                System.out.println("-------------------------\n\nRemaining shots   : " + (this.multishots - completeShots.length - 1) + "\n");
                for (int i = completeShots.length + 1; i < this.multishots; ++i) {
                    RaptShot rs = this._work.getShot(i);
                    this.completedWorkSoFar += rs.getBeams() * this._work.getPhotons();
                    currentStatus = currentStatus + "-------------------------\nShot " + (i + 1) + "\n" + rs.report() + "\nShot status          : NOT COMPLETE\n";
                    currentStatus = currentStatus + "Real, estimate times : " + this.findTime1(rs, "NULL", i) + "\n";
                }
                System.out.println(currentStatus + "-------------------------\n");
            }
            System.out.println(this.reportTime() + "\n-------------------------");
            if (remainingShots == this.multishots) {
                System.out.println(currentStatus);
                System.out.println("-------------------------\nJob FINISHED");
            }
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: getStatus error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public String[] findFile(String dir, String pat) {
        try {
            File dirF = new File(dir);
            final String expr = pat;
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    Pattern pattern = Pattern.compile(expr);
                    Matcher matcher = pattern.matcher(name);
                    return matcher.find();
                }
            };
            String[] fileList = dirF.list(filter);
            return fileList;
        }
        catch (Exception ex) {
            String msg = "Error finding file: directory is '" + dir + "' and pattern is '" + pat + "': " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: findFile " + msg, ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: findFile error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public String reportTime() {
        double realTime = 0.0;
        double estTime = 0.0;
        try {
            for (int i = 0; i < this.multishots; ++i) {
                RaptTime rt = (RaptTime)this.time.get(i);
                double[] dd = rt.getRealTime();
                realTime += dd[0];
                dd = rt.getEstimateTime();
                estTime += dd[0];
            }
            String totTime = "Total Estimate time : " + estTime + "\nTotal Real time     : " + realTime;
            return totTime;
        }
        catch (Exception ex) {
            String msg = "Error: " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: reportTime error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: reportTime error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public double estJobTime() {
        double estTime = 0.0;
        try {
            int proc = this._rsc.getNodes();
            int geom = 80;
            for (int i = 0; i < this.multishots; ++i) {
                RaptShot rs = this._work.getShot(i);
                double dd = this._rm.est(this._work.getPhotons(), rs.getBeams(), proc, geom, rs);
                estTime += dd;
            }
            return estTime;
        }
        catch (Exception ex) {
            String msg = "Performance model estJobTime error: " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, msg, ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: estJobTime error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public String findTime1(RaptShot rs, String var, int idx) {
        double comp = 0.0;
        double comm = 0.0;
        try {
            RaptTime rt = (RaptTime)this.time.get(idx);
            if (!var.equals("NULL")) {
                int id = Integer.parseInt(this.idxString(var));
                if (id != idx + 1) {
                    System.out.println("Error index numbers do not match (" + id + " / " + (idx + 1) + " )");
                }
                rt.readRealTime(this.workDir, "VARIANCE" + this.idxString(var) + ".OUT");
            }
            int proc = this._rsc.getNodes();
            int geom = 80;
            comp = this._rm.est(this._work.getPhotons(), rs.getBeams(), proc, geom, rs);
            double[] dd = new double[]{comp, 0.0, 0.0};
            rt.setEstimateTime(dd);
            return rt.toString();
        }
        catch (Exception ex) {
            String msg = "Error: " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: findTime1 error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: findTime1 error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public String idxString(String filename) {
        try {
            Pattern pt = Pattern.compile("^.*([0-9][0-9])\\..*$");
            Matcher mt = pt.matcher(filename);
            if (mt.find()) {
                return mt.group(1);
            }
            return null;
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: idxString error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public static void main(String[] args) {
        String dir = ".";
        String dbFile = "raptDB";
        String props = "raptPerformance.props";
        boolean est = false;
        boolean update = false;
        boolean status = false;
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            String arg;
            if ((arg = args[i++]).equals("-dir")) {
                if (i < args.length) {
                    dir = args[i++];
                    continue;
                }
                System.err.println("-dir requires a directory name");
                continue;
            }
            if (arg.equals("-props")) {
                if (i < args.length) {
                    props = args[i++];
                    continue;
                }
                System.err.println("-props requires a filename");
                continue;
            }
            if (arg.equals("-dbfile")) {
                if (i < args.length) {
                    dbFile = args[i++];
                    continue;
                }
                System.err.println("-dbfile requires a filename");
                continue;
            }
            block8: for (int j = 1; j < arg.length(); ++j) {
                char flag = arg.charAt(j);
                switch (flag) {
                    case 'e': {
                        est = true;
                        continue block8;
                    }
                    case 'u': {
                        update = true;
                        continue block8;
                    }
                    case 's': {
                        status = true;
                    }
                }
            }
        }
        if (i != args.length) {
            System.err.println("Usage: -dir directory -dbfile dbfile -props props_filename -esu");
            System.exit(1);
        }
        RaptJob rj = new RaptJob(dir, dbFile);
        if (update) {
            rj.updateRaptDb(dbFile);
        }
        if (status) {
            try {
                rj.getStatus();
            }
            catch (Exception e) {
                System.err.println("Cannot get status: " + e.getMessage());
            }
        }
        if (est) {
            System.out.println("Direct estimation is not implemented, you need to specify workload and resources first!");
        }
    }
}

