/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.gemss.applications.performance.rapt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.Base64;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.RaptShot;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.RaptWorkload;

public class RaptMetadata
implements Serializable {
    private static Logger mlogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.applications.performance.rapt");
    private Properties props;
    private String sessionName;
    private String dataDir;
    private String sessionDir;
    private RaptWorkload work;

    public RaptMetadata(String sessionName, String dir, String propName) {
        try {
            this.sessionName = sessionName;
            this.dataDir = dir;
            this.sessionDir = dir + System.getProperty("file.separator") + sessionName;
            this.props = this.readProps(propName);
            this.work = new RaptWorkload(this.sessionDir);
        }
        catch (Exception ex) {
            mlogger.log(Level.SEVERE, "Performance model init error", ex);
            throw new RuntimeException("Performance model: " + ex.getMessage(), ex);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model init error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public Properties readProps(String filename) {
        Properties props = new Properties();
        try {
            FileInputStream is = new FileInputStream(filename);
            props.load(is);
            is.close();
            return props;
        }
        catch (FileNotFoundException fnfe) {
            String msg = "Performance model: Error cannot locate properties file " + fnfe.getMessage();
            mlogger.log(Level.SEVERE, "File not found", fnfe);
            throw new RuntimeException(msg, fnfe);
        }
        catch (Exception e) {
            String msg = "Error opening properties file '" + filename + "': " + e.getMessage();
            mlogger.log(Level.SEVERE, "Performance model: readProps error", e);
            throw new RuntimeException(msg, e);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: readProps error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void getShot() {
        mlogger.log(Level.WARNING, "Performance model: getShots called but not implemented");
    }

    public void updateJobDesc(String config) {
        String line = config;
        try {
            Pattern p = Pattern.compile("^(.*" + this.sessionName + ")\\.conf$");
            Matcher m = p.matcher(line);
            String configWL = m.find() ? m.group(1) + "-rd.xml" : this.sessionDir + System.getProperty("file.separator") + this.sessionName + System.getProperty("file.separator") + this.sessionName + "-rd.xml";
            mlogger.log(Level.INFO, "Performance model: Store wl object under: " + configWL);
            this.storeToRequestDescriptor(configWL);
            line = configWL;
            p = Pattern.compile("\\\\");
            m = p.matcher(line);
            configWL = m.replaceAll("\\\\\\\\");
            FileOutputStream fout = new FileOutputStream(config, true);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter out = new OutputStreamWriter(bout);
            out.write("\n#Request descriptor file name entry automatically added by the RAPT grid client metadata [do not edit]\nrequestDescFilename=" + configWL + "\n");
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            String msg = "Error updating job description: " + ex.getMessage();
            mlogger.log(Level.SEVERE, "Performance model: updateJobDesc failed", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: updateJobDesc failed", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void storeToFile(String filename) {
        try {
            mlogger.log(Level.INFO, "Performance model: storing RaptWorkload metadata object to " + filename + ".wl");
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename + ".wl"));
            out.writeObject(this.work);
            out.close();
            mlogger.log(Level.INFO, "Performance model: storing RaptWorkload object to " + filename + ".wlb64");
            String result1 = Base64.encodeObject(this.work);
            File outFile = new File(filename + ".wlb64");
            FileWriter fw = new FileWriter(outFile);
            String reqDesc = this.requestDescriptorXMLWrapper(result1);
            fw.write(reqDesc);
            fw.close();
        }
        catch (IOException ex) {
            String msg = "Error storing data to file '" + filename + "': " + ex.getMessage();
            mlogger.log(Level.SEVERE, "Performance model: storeToFile IO error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: storeToFile error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public String requestDescriptorXMLWrapper(String strWorkObj) {
        try {
            String pre = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?> <RequestDescriptor>\n    <RequestInfo>\n        <ServiceCategory>serviceCategory</ServiceCategory>\n    </RequestInfo>\n    <PerformanceParameters>\n        <PerformanceParameter>\n            <Name>RaptParam</Name>\n            <Value>";
            String post = "</Value>\n        </PerformanceParameter>\n    </PerformanceParameters>\n</RequestDescriptor>";
            return pre + strWorkObj + post;
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: requestDescriptorXMLWrapper error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void storeToRequestDescriptor(String filename) {
        try {
            mlogger.log(Level.INFO, "Performance model: storing RaptWorkload object to " + filename);
            String result1 = Base64.encodeObject(this.work);
            File outFile = new File(filename);
            FileWriter fw = new FileWriter(outFile);
            String reqDesc = this.requestDescriptorXMLWrapper(result1);
            fw.write(reqDesc);
            fw.close();
        }
        catch (IOException ex) {
            String msg = "Error storing data to file '" + filename + "': " + ex.getMessage();
            mlogger.log(Level.INFO, "Performance model: storeToRequestDescriptor IO error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: storeToRequestDescriptor error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void writeXML() {
        try {
            FileOutputStream fout = new FileOutputStream(this.sessionDir + System.getProperty("file.separator") + this.sessionName + ".xml");
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "8859_1");
            out.write("<?xml version=\"1.0\" ");
            out.write("encoding=\"ISO-8859-1\"?>\r\n");
            out.write("<session>\r\n");
            out.write("   <sessionName>" + this.sessionName + "</sessionName>\r\n");
            out.write("   <application>" + this.props.getProperty("application") + "</application>\r\n");
            out.write("   <date>" + new Date() + "</date>\r\n");
            out.write("   <user>" + this.props.getProperty("user") + "</user>\r\n");
            out.write("   <organisation>" + this.props.getProperty("organisation") + "</organisation>\r\n");
            out.write("   <summary/>\r\n\r\n");
            out.write("   <sessionConf>" + this.props.getProperty("homeDir") + System.getProperty("file.separator") + "raptSession" + System.getProperty("file.separator") + this.sessionName + ".conf</sessionConf>\r\n");
            out.write("   <inputURI>" + this.dataDir + System.getProperty("file.separator") + this.sessionName + "_in.zip</inputURI>\r\n");
            out.write("   <outputURI>" + this.dataDir + System.getProperty("file.separator") + this.sessionName + "_out.zip</outputURI>\r\n");
            out.write("   <parameters/>\r\n");
            out.write("   <numberOfPhotons>" + this.work.getPhotons() + "</numberOfPhotons>\r\n");
            out.write("   <numberOfBatches>" + this.work.getBatches() + "</numberOfBatches>\r\n");
            out.write("   <multiplicity>" + this.work.getMultiplicity() + "</multiplicity>\r\n\r\n");
            out.write("   <parameters/>\r\n\r\n");
            ArrayList ar = (ArrayList)this.work.getShots();
            for (int i = 0; i < ar.size(); ++i) {
                RaptShot rs = (RaptShot)ar.get(i);
                out.write("   <shot>\r\n");
                out.write("      <beams>" + rs.getBeams() + "</beams>\r\n");
                out.write("      <isocentre>\r\n");
                float[] f = new float[3];
                f = rs.getIsocentre();
                out.write("         <x>" + f[0] + "</x>\r\n");
                out.write("         <y>" + f[1] + "</y>\r\n");
                out.write("         <z>" + f[2] + "</z>\r\n");
                out.write("      </isocentre>\r\n");
                out.write("      <gamma>" + rs.getGamma() + "</gamma>\r\n");
                out.write("      <helmet>" + rs.getHelmet() + "</helmet>\r\n");
                out.write("      <geometry/>\r\n");
                out.write("   </shot>\r\n\r\n");
            }
            out.write("   <signature/>\r\n\r\n");
            out.write("</session>\r\n");
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            String msg = "Error writing XML: " + ex.getMessage();
            mlogger.log(Level.INFO, "Performance model: writeXML IO error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: writeXML error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void compressInput() {
        try {
            this.zipSession(this.sessionDir + "_in.zip", this.sessionDir);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: compressInput error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void zipSession(String zipName, String zipDir) {
        File file = new File(zipDir);
        try {
            FileOutputStream fos = new FileOutputStream(zipName);
            ZipOutputStream zos = new ZipOutputStream(fos);
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                if (!fileList[i].isFile()) continue;
                String fileName = fileList[i].getName();
                String filePath = fileList[i].getPath();
                String relPath = null;
                if (filePath.startsWith(this.sessionDir)) {
                    int root_length = this.sessionDir.length() + 1;
                    relPath = filePath.substring(root_length);
                }
                if (relPath != null) {
                    int byteCount;
                    FileInputStream fis = new FileInputStream(filePath);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    ZipEntry fileEntry = null;
                    fileEntry = new ZipEntry(fileName);
                    zos.putNextEntry(fileEntry);
                    byte[] data = new byte[1024];
                    while ((byteCount = bis.read(data, 0, 1024)) > -1) {
                        zos.write(data, 0, byteCount);
                    }
                    continue;
                }
                throw new IOException("I have a null relative path!");
            }
            zos.flush();
            zos.close();
            fos.close();
        }
        catch (IOException ex) {
            String msg = "Zipping files error: " + ex.getMessage();
            mlogger.log(Level.INFO, "Performance model: zipsession IO error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: zipsession error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public static void main(String[] args) {
        String propertiesName = "props.txt";
        String dir = "data";
        String sessionName = "new";
        String config = "data";
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            String arg;
            if ((arg = args[i++]).equals("-dir")) {
                if (i < args.length) {
                    dir = args[i++];
                    continue;
                }
                System.err.println("-dir requires a directory name");
                continue;
            }
            if (arg.equals("-n")) {
                if (i < args.length) {
                    sessionName = args[i++];
                    continue;
                }
                System.err.println("-n requires a session name");
                continue;
            }
            if (arg.equals("-p")) {
                if (i < args.length) {
                    propertiesName = args[i++];
                    continue;
                }
                System.err.println("-p requires a properties name");
                continue;
            }
            if (arg.equals("-c")) {
                if (i < args.length) {
                    config = args[i++];
                    continue;
                }
                System.err.println("-c requires config file");
                continue;
            }
            System.err.println("unknown argumnet");
            System.exit(1);
        }
        if (i != args.length) {
            System.err.println("Usage: -n session name  -p properties file [-dir directory]");
            System.exit(1);
        }
        RaptMetadata rm = new RaptMetadata(sessionName, dir, propertiesName);
        rm.writeXML();
        rm.storeToFile(dir + System.getProperty("file.separator") + sessionName + System.getProperty("file.separator") + sessionName);
        rm.updateJobDesc(config);
        rm.compressInput();
    }
}

