/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.gemss.applications.performance.rapt;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.RaptShot;

public class RaptModel {
    private Logger mlogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.applications.performance.rapt");
    private static final String PERFORMANCE = "performance";
    private ResourceBundle _bundle = null;

    public RaptModel() {
        try {
            this._bundle = ResourceBundle.getBundle(PERFORMANCE);
        }
        catch (Exception ex) {
            String msg = "Failed to get resource bundle: " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: RaptModel init", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: RaptModel init error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public double est(int photons, int beams, int proc, int geom, RaptShot rs) {
        try {
            double comp = 0.0;
            double comm = 0.0;
            double photonA = Double.valueOf(this._bundle.getString("photonA"));
            double photonB = Double.valueOf(this._bundle.getString("photonB"));
            double beamA = Double.valueOf(this._bundle.getString("beamA"));
            double beamB = Double.valueOf(this._bundle.getString("beamB"));
            double geomA = Double.valueOf(this._bundle.getString("geomA"));
            double geomB = Double.valueOf(this._bundle.getString("geomB"));
            double nodeA = Double.valueOf(this._bundle.getString("nodeA"));
            double commA = Double.valueOf(this._bundle.getString("commA"));
            double commB = Double.valueOf(this._bundle.getString("commB"));
            double scale = Double.valueOf(this._bundle.getString("scale"));
            double Fphoton = photonA * (double)photons + photonB;
            double Fbeam = 1.0 + beamA * (double)(beams - 201) / beamB;
            double Fnodes = 1.0 / Math.pow(proc, nodeA);
            double Fgeom = 1.0 + geomA * (double)(geom - 80) / geomB;
            double Ffocus = this.focus(rs);
            comp = Fphoton * Fbeam * Fnodes * Fgeom * Ffocus;
            comm = commA * (double)proc + commB;
            this.mlogger.log(Level.INFO, "Performance model: ESTIMATION:\nFphoton: " + Fphoton + "(photons: " + photons + ")\n" + " Fbeam: " + Fbeam + " (beams: " + beams + ")\n" + " Fnodes: " + Fnodes + " (proc: " + proc + ")\n" + " Fgeom: " + Fgeom + "\n" + " Fcocus: " + Ffocus + "\n" + " comm: " + comm + "\n" + " scaling: " + scale);
            return scale * (comp + comm);
        }
        catch (Exception ex) {
            String msg = "Error in estimating RAPT performance: " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: est error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: est error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public double focus(RaptShot rs) {
        try {
            double[][] fAr = new double[][]{{0.866978808, 178.1885246, 99.5}, {0.894036081, 172.1819672, 129.4016393}, {0.915095525, 165.0737705, 112.6147541}, {0.87998444, 155.1065574, 155.1065574}, {0.933873803, 151.9590164, 125.7295082}, {0.952110315, 151.9590164, 99.5}, {0.939016176, 138.8442623, 138.8442623}, {0.964786841, 138.8442623, 112.6147541}, {0.865126217, 129.4016393, 172.1819672}, {0.934154294, 125.7295082, 151.9590164}, {0.977448629, 125.7295082, 125.7295082}, {0.987392319, 125.7295082, 99.5}, {0.991872575, 112.6147541, 112.6147541}, {0.895878699, 112.6147541, 165.0737705}, {0.963362044, 112.6147541, 138.8442623}, {0.999999999, 99.5, 99.5}, {0.986016996, 99.5, 125.7295082}, {0.941976437, 99.5, 151.9590164}, {0.830296144, 99.5, 178.1885246}, {0.995099578, 86.3852459, 112.6147541}, {0.896022851, 86.3852459, 165.0737705}, {0.961712947, 86.3852459, 138.8442623}, {0.932527903, 73.2704918, 151.9590164}, {0.978002685, 73.2704918, 125.7295082}, {0.99334919, 73.2704918, 99.5}, {0.861280008, 69.59836066, 172.1819672}, {0.943070228, 60.1557377, 138.8442623}, {0.972759749, 60.1557377, 112.6147541}, {0.937212877, 47.04098361, 125.7295082}, {0.946018927, 47.04098361, 99.5}, {0.883634471, 43.89344262, 155.1065574}, {0.913233534, 33.92622951, 112.6147541}, {0.883892881, 26.81803279, 129.4016393}, {0.845181474, 20.81147541, 99.5}};
            float X = rs.getIsocentre()[0] - 20.5f;
            float Z = rs.getIsocentre()[2] - 20.5f;
            double min = 0.0;
            int minIdx = 0;
            for (int i = 0; i < 34; ++i) {
                double dif = Math.sqrt((fAr[i][1] - (double)X) * (fAr[i][1] - (double)X) + (fAr[i][2] - (double)Z) * (fAr[i][2] - (double)Z));
                if (i == 0) {
                    min = dif;
                    minIdx = i;
                    continue;
                }
                if (!(dif < min)) continue;
                min = dif;
                minIdx = i;
            }
            return fAr[minIdx][0];
        }
        catch (Exception ex) {
            String msg = "Error in focus calculation: " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: focus error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: focus error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }
}

