/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.gemss.applications.performance.rapt;

import at.ac.univie.iss.apm.PerformanceModel;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.RaptJob;

public class RaptPerformanceModel
implements PerformanceModel {
    private String modelProps;
    private Logger mlogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.applications.performance.rapt");

    public RaptPerformanceModel() {
        this.mlogger.log(Level.INFO, "Performance model: Initialised ok");
    }

    public String getPerformanceEstimate(String reqDesc, String machineDesc) {
        try {
            RaptJob rj = new RaptJob(reqDesc, machineDesc);
            long runtime = (long)rj.estJobTime();
            StringBuffer perfDesc = new StringBuffer();
            perfDesc.append("<PerformanceDescriptor>\n");
            perfDesc.append("   <Runtime>" + runtime + "</Runtime>\n");
            perfDesc.append("   <DiscRequirement>19</DiscRequirement>\n");
            perfDesc.append("   <MemoryRequirement>199</MemoryRequirement>\n");
            perfDesc.append("</PerformanceDescriptor>\n");
            return perfDesc.toString();
        }
        catch (Exception ex) {
            String msg = "Error getting performance estimate for RAPT job: " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: init error " + msg, ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: init error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public static void main(String[] args) {
        try {
            String line;
            System.out.println(" RAPT application performance model ");
            RaptPerformanceModel rpm = new RaptPerformanceModel();
            String machineDesc = "<machineDesc><number-of-nodes>1</number-of-nodes></machineDesc>";
            String reqDesc = "";
            FileInputStream fin = new FileInputStream("workload");
            BufferedReader br = new BufferedReader(new InputStreamReader(fin));
            while ((line = br.readLine()) != null) {
                reqDesc = reqDesc + line;
            }
            System.out.println("Prediction: \n" + rpm.getPerformanceEstimate(reqDesc, machineDesc));
        }
        catch (Exception e) {
            System.err.println("Error opening workload file " + e);
            System.exit(1);
        }
    }
}

