/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.gemss.applications.performance.rapt;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.Time;

public class RaptTime
implements Time {
    private Logger mlogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.applications.performance.rapt");
    private double[] realTime = new double[3];
    private double[] estTime = new double[3];

    public double[] getRealTime() {
        return this.realTime;
    }

    public void setRealTime(double[] eta) {
        try {
            this.realTime[0] = eta[0];
            this.realTime[1] = eta[1];
            this.realTime[2] = eta[2];
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: setRealTime error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void readRealTime(String dir) {
        try {
            this.readRealTime(dir, "VARIANCE.OUT");
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: readRealTime error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void setEstimateTime(double[] eta) {
        this.estTime = eta;
    }

    public double[] getEstimateTime() {
        return this.estTime;
    }

    public void readEstimateTime(String dir) {
        this.mlogger.log(Level.WARNING, "Performance model: readEstimateTime called but not implemented");
    }

    public void readRealTime(String dir, String variance) {
        String filename = dir.concat("/" + variance);
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            Pattern pTot = Pattern.compile("^\\s*0:\\s*Total Run Time\\s*=\\s*(\\d+\\.\\d*)\\s*$");
            int count = 0;
            while ((line = in.readLine()) != null && count < 1) {
                Matcher mTot = pTot.matcher(line);
                if (!mTot.find()) continue;
                double d = Double.valueOf(mTot.group(1));
                ++count;
                this.realTime[0] = d;
            }
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            String msg = "Error cannot locate file " + fnfe.getMessage();
            this.mlogger.log(Level.SEVERE, "Performance model: readRealTime file not found error " + msg, fnfe);
            throw new RuntimeException(msg, fnfe);
        }
        catch (Exception ex) {
            String msg = "Error opening file '" + filename + "': " + ex.getMessage();
            this.mlogger.log(Level.SEVERE, "Performamce model: readRealTime error " + msg, ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: readRealTime error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public String toString() {
        try {
            return this.realTime[0] + ", " + this.realTime[1] + ", " + this.realTime[2] + ",  " + this.estTime[0] + ", " + this.estTime[1] + ", " + this.estTime[2];
        }
        catch (Throwable th) {
            this.mlogger.log(Level.SEVERE, "Performance model: toString error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }
}

