/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.itinnovation.gemss.applications.performance.rapt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.RaptShot;
import uk.ac.soton.itinnovation.gemss.applications.performance.rapt.Workload;

public class RaptWorkload
implements Workload,
Serializable {
    private static Logger mlogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.applications.performance.rapt");
    private int photons;
    private int batches;
    private int multiplicity;
    private List shots;

    public RaptWorkload(String dir) {
        try {
            this.shots = new ArrayList();
            this.readWorkload(dir);
            mlogger.log(Level.SEVERE, "Performance model: workflow = " + this.toString());
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: RaptWorkflow error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void readWorkload() {
        mlogger.log(Level.WARNING, "Performance model: readWorkflow called but not implemented");
    }

    public void readWorkload(String dir) {
        try {
            File dirF = new File(dir);
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    Pattern pattern = Pattern.compile("BEAM[0-9][0-9].IN");
                    Matcher matcher = pattern.matcher(name);
                    return matcher.find();
                }
            };
            String[] multiBeam = dirF.list(filter);
            this.multiplicity = multiBeam.length;
            if (this.multiplicity == 0) {
                String msg = "There are no BEAM.IN files in " + dir;
                mlogger.log(Level.SEVERE, "Performance model: " + msg);
                throw new RuntimeException(msg);
            }
            this.readPhotonsBatches(multiBeam[0], dir);
            for (int i = 0; i < multiBeam.length; ++i) {
                RaptShot rs = new RaptShot();
                this.readShot(multiBeam[i], dir, rs);
                this.shots.add(rs);
            }
        }
        catch (Exception ex) {
            String msg = "Error in readWorkload: " + ex.getMessage();
            mlogger.log(Level.SEVERE, "Performance model: readWorkdlow error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: readWorkflow error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void setWorkload(List wl) {
        mlogger.log(Level.WARNING, "Performamce model: setWorkflow() called but not implemented");
    }

    public void readShot(String name, String dir, RaptShot rs) {
        String beamsFilename = dir + System.getProperty("file.separator") + name;
        float[] iso = new float[3];
        String line = new String();
        try {
            String n;
            Matcher m;
            Pattern p;
            try {
                BufferedReader in = new BufferedReader(new FileReader(beamsFilename));
                p = Pattern.compile("^([0-9.]+)\\s*$");
                int count = 0;
                while ((line = in.readLine()) != null && count < 8) {
                    m = p.matcher(line);
                    if (!m.find()) continue;
                    if (count == 0) {
                        rs.setBeams(Integer.valueOf(m.group(1)));
                    }
                    if (count == 1) {
                        iso[0] = Float.valueOf(m.group(1)).floatValue();
                    }
                    if (count == 2) {
                        iso[1] = Float.valueOf(m.group(1)).floatValue();
                    }
                    if (count == 3) {
                        iso[2] = Float.valueOf(m.group(1)).floatValue();
                    }
                    if (count == 7) break;
                    ++count;
                }
                rs.setIsocentre(iso);
                in.close();
            }
            catch (FileNotFoundException fnfe) {
                String msg = "Cannot locate file: " + fnfe.getMessage();
                mlogger.log(Level.SEVERE, "Performance model: readShot file not found error = " + msg, fnfe);
                throw new RuntimeException(msg, fnfe);
            }
            catch (Exception e) {
                String msg = "Error opening file " + beamsFilename + ": " + e.getMessage();
                mlogger.log(Level.SEVERE, "Performance model: readShot error = " + msg, e);
                throw new RuntimeException(msg, e);
            }
            p = Pattern.compile("BEAM([0-9]+).IN");
            m = p.matcher(name);
            String intensityFilename = dir + System.getProperty("file.separator") + "INTENSITY";
            if (m.find()) {
                n = m.group(1);
            } else {
                mlogger.log(Level.INFO, "Cannot extract multiplictity " + this.multiplicity + " suffix from " + name);
                n = "01";
            }
            intensityFilename = intensityFilename + n + ".IN";
            try {
                BufferedReader in = new BufferedReader(new FileReader(intensityFilename));
                p = Pattern.compile("Helmet:\\s*([0-9]+)");
                boolean count = false;
                while ((line = in.readLine()) != null) {
                    m = p.matcher(line);
                    if (!m.find()) continue;
                    rs.setHelmet(Integer.valueOf(m.group(1)));
                    break;
                }
                in.close();
            }
            catch (FileNotFoundException fnfe) {
                String msg = "Cannot locate file: " + fnfe.getMessage();
                mlogger.log(Level.SEVERE, "Performance model: readShot file not found error = " + msg, fnfe);
                throw new RuntimeException(msg, fnfe);
            }
            catch (Exception e) {
                String msg = "Error opening file " + intensityFilename + ": " + e.getMessage();
                mlogger.log(Level.SEVERE, "Performance model: readShot error = " + msg, e);
                throw new RuntimeException(msg, e);
            }
            rs.setGeometry(0);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: readShot error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void readPhotonsBatches(String name, String dir) {
        Matcher m;
        int count;
        Pattern p;
        BufferedReader in;
        String beamsFilename = dir + System.getProperty("file.separator") + name;
        String statusFilename = dir + System.getProperty("file.separator") + "STATUS.IN";
        String line = new String();
        try {
            in = new BufferedReader(new FileReader(statusFilename));
            p = Pattern.compile("^([0-9]+)\\s*$");
            count = 0;
            while ((line = in.readLine()) != null && count < 1) {
                m = p.matcher(line);
                if (!m.find()) continue;
                this.batches = Integer.valueOf(m.group(1));
                ++count;
                in.close();
                break;
            }
            if (count != 1) {
                System.out.println("Cannot find batch number, assume batch number is 1");
                this.batches = 1;
            }
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            String msg = "Cannot locate file: " + fnfe.getMessage();
            mlogger.log(Level.SEVERE, "Performanmce model: readPhotonBatches file not found error = " + msg, fnfe);
            throw new RuntimeException(msg, fnfe);
        }
        catch (Exception e) {
            String msg = "Error opening file " + statusFilename + ": " + e.getMessage();
            mlogger.log(Level.SEVERE, "Performance model: readPhotonBatches error = " + msg, e);
            throw new RuntimeException(msg, e);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: readPhotonBatches error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
        try {
            in = new BufferedReader(new FileReader(beamsFilename));
            p = Pattern.compile("^([0-9.]+)\\s*$");
            count = 0;
            while ((line = in.readLine()) != null && count < 8) {
                m = p.matcher(line);
                if (!m.find()) continue;
                if (count == 7) {
                    this.photons = Integer.valueOf(m.group(1));
                    break;
                }
                ++count;
            }
            in.close();
        }
        catch (FileNotFoundException fnfe) {
            String msg = "Cannot locate file: " + fnfe.getMessage();
            mlogger.log(Level.SEVERE, "Performance model: readPhotonBatches file not found = " + msg, fnfe);
            throw new RuntimeException(msg, fnfe);
        }
        catch (Exception e) {
            String msg = "Error opening file " + beamsFilename + ": " + e.getMessage();
            mlogger.log(Level.SEVERE, "PErformance model: readPhotonBatches error = " + msg, e);
            throw new RuntimeException(msg, e);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: readPhotonBatches error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public int getPhotons() {
        return this.photons;
    }

    public int getBatches() {
        return this.batches;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public List getShots() {
        return this.shots;
    }

    public String report() {
        return null;
    }

    public String toString() {
        try {
            String str = "RaptWorkload\nMultiplicity .....: " + this.multiplicity + "\nPhotons per beeam : " + this.photons + "\nBatches ..........: " + this.batches + "\n\n";
            for (int i = 0; i < this.multiplicity; ++i) {
                RaptShot rs = (RaptShot)this.shots.get(i);
                str = str + "Shot [" + i + "] : " + rs.toString() + "\n";
            }
            return str;
        }
        catch (Exception ex) {
            String msg = "Error: " + ex.getMessage();
            mlogger.log(Level.SEVERE, "Performance model: toString error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: toString error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void storeToFile(String filename) {
        try {
            System.out.println("storing rapt worload object ..." + filename);
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
            out.writeObject(this);
            out.close();
        }
        catch (IOException e) {
            String msg = "Error storing rapt workload object: " + e.getMessage();
            mlogger.log(Level.SEVERE, "Performamce model: storeToFile error " + msg, e);
            throw new RuntimeException(msg, e);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: storeToFile error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public RaptShot getShot(int idx) {
        try {
            RaptShot rs = (RaptShot)this.shots.get(idx);
            return rs;
        }
        catch (Exception ex) {
            String msg = "Error: " + ex.getMessage();
            mlogger.log(Level.SEVERE, "Performance model: getShot error", ex);
            throw new RuntimeException(msg, ex);
        }
        catch (Throwable th) {
            mlogger.log(Level.SEVERE, "Performance model: getShot error", th);
            throw new RuntimeException(th.getMessage(), th);
        }
    }

    public void readRaptWorkload(String str) {
        mlogger.log(Level.WARNING, "Performance model: readRaptWorkload() called but not implemented");
    }

    public static void main(String[] args) {
        System.out.println("Test new RAPT workload");
        RaptWorkload rw = new RaptWorkload(".");
    }
}

