/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.exception;

import javax.servlet.jsp.JspTagException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.exception.SeverityEnum;

public abstract class BaseNestableJspTagException
extends JspTagException {
    private final Class sourceClass;
    private Throwable nestedException;

    public BaseNestableJspTagException(Class source, String message) {
        super(message);
        this.sourceClass = source;
        Log log = LogFactory.getLog((Class)source);
        log.error((Object)this.toString());
        if (this.getSeverity() == SeverityEnum.DEBUG) {
            log.debug((Object)this.toString());
        } else if (this.getSeverity() == SeverityEnum.INFO) {
            log.info((Object)this.toString());
        } else if (this.getSeverity() == SeverityEnum.WARN) {
            log.warn((Object)this.toString());
        } else {
            log.error((Object)this.toString());
        }
    }

    public BaseNestableJspTagException(Class source, String message, Throwable cause) {
        super(message);
        this.sourceClass = source;
        this.nestedException = cause;
        Log log = LogFactory.getLog((Class)source);
        if (this.getSeverity() == SeverityEnum.DEBUG) {
            log.debug((Object)this.toString(), cause);
        } else if (this.getSeverity() == SeverityEnum.INFO) {
            log.info((Object)this.toString(), cause);
        } else if (this.getSeverity() == SeverityEnum.WARN) {
            log.warn((Object)this.toString(), cause);
        } else {
            log.error((Object)this.toString(), cause);
        }
    }

    public Throwable getCause() {
        return this.nestedException;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String className = this.sourceClass.getName();
        className = className.substring(className.lastIndexOf("."));
        buffer.append("Exception: ");
        buffer.append("[").append(className).append("] ");
        buffer.append(((Throwable)((Object)this)).getMessage());
        if (this.nestedException != null) {
            buffer.append("\nCause:     ");
            buffer.append(this.nestedException.getMessage());
        }
        return buffer.toString();
    }

    public abstract SeverityEnum getSeverity();
}

