/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import java.util.Iterator;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;

public abstract class BaseExportView {
    private static Log log = LogFactory.getLog((Class)(class$org$displaytag$export$BaseExportView == null ? (class$org$displaytag$export$BaseExportView = BaseExportView.class$("org.displaytag.export.BaseExportView")) : class$org$displaytag$export$BaseExportView));
    private TableModel model;
    private boolean exportFull;
    private boolean header;
    private boolean decorated;
    static /* synthetic */ Class class$org$displaytag$export$BaseExportView;

    public BaseExportView(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        this.model = tableModel;
        this.exportFull = exportFullList;
        this.header = includeHeader;
        this.decorated = decorateValues;
    }

    protected abstract String getRowStart();

    protected abstract String getRowEnd();

    protected abstract String getCellStart();

    protected abstract String getCellEnd();

    protected abstract String getDocumentStart();

    protected abstract String getDocumentEnd();

    protected abstract boolean getAlwaysAppendCellEnd();

    protected abstract boolean getAlwaysAppendRowEnd();

    public abstract String getMimeType();

    protected String doHeaders() {
        String ROW_START = this.getRowStart();
        String ROW_END = this.getRowEnd();
        String CELL_START = this.getCellStart();
        String CELL_END = this.getCellEnd();
        boolean ALWAYS_APPEND_CELL_END = this.getAlwaysAppendCellEnd();
        StringBuffer buffer = new StringBuffer(1000);
        Iterator iterator = this.model.getHeaderCellList().iterator();
        buffer.append(ROW_START);
        while (iterator.hasNext()) {
            log.debug((Object)"iterator.hasNext()");
            HeaderCell headerCell = (HeaderCell)iterator.next();
            String columnHeader = headerCell.getTitle();
            if (columnHeader == null) {
                columnHeader = StringUtils.capitalize((String)headerCell.getBeanPropertyName());
            }
            buffer.append(CELL_START);
            buffer.append(this.escapeColumnValue(columnHeader));
            if (!ALWAYS_APPEND_CELL_END && !iterator.hasNext()) continue;
            buffer.append(CELL_END);
        }
        buffer.append(ROW_END);
        return buffer.toString();
    }

    public String doExport() throws JspException {
        StringBuffer buffer = new StringBuffer(8000);
        String DOCUMENT_START = this.getDocumentStart();
        String DOCUMENT_END = this.getDocumentEnd();
        String ROW_START = this.getRowStart();
        String ROW_END = this.getRowEnd();
        String CELL_START = this.getCellStart();
        String CELL_END = this.getCellEnd();
        boolean ALWAYS_APPEND_CELL_END = this.getAlwaysAppendCellEnd();
        boolean ALWAYS_APPEND_ROW_END = this.getAlwaysAppendRowEnd();
        buffer.append(DOCUMENT_START);
        if (this.header) {
            buffer.append(this.doHeaders());
        }
        RowIterator rowIterator = this.model.getRowIterator(this.exportFull);
        while (rowIterator.hasNext()) {
            String stringStartRow;
            log.debug((Object)"rowIterator.hasNext()");
            Row row = rowIterator.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("row=" + row));
            }
            if (this.model.getTableDecorator() != null && (stringStartRow = this.model.getTableDecorator().startRow()) != null) {
                buffer.append(stringStartRow);
            }
            ColumnIterator columnIterator = row.getColumnIterator(this.model.getHeaderCellList());
            buffer.append(ROW_START);
            while (columnIterator.hasNext()) {
                Column column = columnIterator.nextColumn();
                Object value = column.getValue(this.decorated);
                buffer.append(CELL_START);
                buffer.append(this.escapeColumnValue(value));
                if (!ALWAYS_APPEND_CELL_END && !columnIterator.hasNext()) continue;
                buffer.append(CELL_END);
            }
            if (!ALWAYS_APPEND_ROW_END && !rowIterator.hasNext()) continue;
            buffer.append(ROW_END);
        }
        buffer.append(DOCUMENT_END);
        return buffer.toString();
    }

    protected abstract Object escapeColumnValue(Object var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

