/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import org.apache.commons.lang.StringUtils;
import org.displaytag.export.BaseExportView;
import org.displaytag.model.TableModel;

public class ExcelView
extends BaseExportView {
    public ExcelView(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        super(tableModel, exportFullList, includeHeader, decorateValues);
    }

    public String getMimeType() {
        return "application/vnd.ms-excel";
    }

    protected String getRowStart() {
        return "";
    }

    protected String getRowEnd() {
        return "\n";
    }

    protected String getCellStart() {
        return "";
    }

    protected String getCellEnd() {
        return "\t";
    }

    protected String getDocumentStart() {
        return "";
    }

    protected String getDocumentEnd() {
        return "";
    }

    protected boolean getAlwaysAppendCellEnd() {
        return false;
    }

    protected boolean getAlwaysAppendRowEnd() {
        return false;
    }

    protected Object escapeColumnValue(Object value) {
        if (value != null) {
            return "\"" + StringUtils.replace((String)StringUtils.trim((String)value.toString()), (String)"\"", (String)"\"\"") + "\"";
        }
        return null;
    }
}

