/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import org.displaytag.export.BaseExportView;
import org.displaytag.export.CsvView;
import org.displaytag.export.ExcelView;
import org.displaytag.export.XmlView;
import org.displaytag.model.TableModel;
import org.displaytag.properties.MediaTypeEnum;

public final class ExportViewFactory {
    private ExportViewFactory() {
    }

    public static BaseExportView getView(MediaTypeEnum exportType, TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        if (exportType == MediaTypeEnum.CSV) {
            return new CsvView(tableModel, exportFullList, includeHeader, decorateValues);
        }
        if (exportType == MediaTypeEnum.EXCEL) {
            return new ExcelView(tableModel, exportFullList, includeHeader, decorateValues);
        }
        if (exportType == MediaTypeEnum.XML) {
            return new XmlView(tableModel, exportFullList, includeHeader, decorateValues);
        }
        throw new IllegalArgumentException("Unknown export type: " + exportType);
    }
}

