/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.filter;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class BufferedResponseWrapper
implements HttpServletResponse {
    private CharArrayWriter outputWriter;
    private SimpleServletOutputStream servletOutputStream;
    private String contentType = "text/html";
    private HttpServletResponse response;

    public BufferedResponseWrapper(HttpServletResponse httpServletResponse) {
        if (httpServletResponse == null) {
            throw new IllegalArgumentException("Response cannot be null");
        }
        this.response = httpServletResponse;
        this.outputWriter = new CharArrayWriter();
        this.servletOutputStream = new SimpleServletOutputStream();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String theContentType) {
        this.contentType = theContentType;
    }

    public PrintWriter getWriter() {
        return new PrintWriter(this.outputWriter);
    }

    public void flushBuffer() throws IOException {
        this.outputWriter.flush();
        this.servletOutputStream.outputStream.reset();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.servletOutputStream;
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public void setContentLength(int len) {
        this.response.setContentLength(len);
    }

    public void setBufferSize(int size) {
        this.response.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void reset() {
        this.response.reset();
    }

    public void resetBuffer() {
        this.response.resetBuffer();
    }

    public void setLocale(Locale loc) {
        this.response.setLocale(loc);
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public String encodeURL(String url) {
        return this.response.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.response.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.response.encodeUrl(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.response.encodeRedirectUrl(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.response.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.response.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.response.sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        if (!"Expires".equalsIgnoreCase(name)) {
            this.response.setDateHeader(name, date);
        }
    }

    public void addDateHeader(String name, long date) {
        if (!"Expires".equalsIgnoreCase(name)) {
            this.response.addDateHeader(name, date);
        }
    }

    public void setHeader(String name, String value) {
        if (!("Cache-Control".equalsIgnoreCase(name) || "Pragma".equalsIgnoreCase(name) || "Expires".equalsIgnoreCase(name))) {
            this.response.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (!("Cache-Control".equalsIgnoreCase(name) || "Pragma".equalsIgnoreCase(name) || "Expires".equalsIgnoreCase(name))) {
            this.response.addHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        this.response.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.response.addIntHeader(name, value);
    }

    public void setStatus(int sc) {
        this.response.setStatus(sc);
    }

    public void setStatus(int sc, String sm) {
        this.response.setStatus(sc, sm);
    }

    public String toString() {
        return this.outputWriter.toString() + this.servletOutputStream.toString();
    }

    private class SimpleServletOutputStream
    extends ServletOutputStream {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        private SimpleServletOutputStream() {
        }

        public void write(int b) {
            this.outputStream.write(b);
        }

        public String toString() {
            return this.outputStream.toString();
        }
    }
}

