/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.RowSorter;
import org.displaytag.properties.TableProperties;

public class TableModel {
    private static Log log = LogFactory.getLog((Class)(class$org$displaytag$model$TableModel == null ? (class$org$displaytag$model$TableModel = TableModel.class$("org.displaytag.model.TableModel")) : class$org$displaytag$model$TableModel));
    private List headerCellList;
    private List rowListFull = new ArrayList(20);
    private List rowListPage;
    private boolean sortOrderAscending = true;
    private boolean sortFullTable = true;
    private int sortedColumn = -1;
    private TableDecorator tableDecorator;
    private String id;
    private TableProperties properties;
    static /* synthetic */ Class class$org$displaytag$model$TableModel;

    public TableModel(TableProperties tableProperties) {
        this.headerCellList = new ArrayList(20);
        this.properties = tableProperties;
    }

    public void setId(String tableId) {
        this.id = tableId;
    }

    public List getRowListFull() {
        return this.rowListFull;
    }

    public List getRowListPage() {
        return this.rowListPage;
    }

    public void addRow(Row row) {
        row.setParentTable(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.id + "] adding row " + row));
        }
        this.rowListFull.add(row);
    }

    public void setSortFullTable(boolean sortFull) {
        this.sortFullTable = sortFull;
    }

    public boolean isSortFullTable() {
        return this.sortFullTable;
    }

    public boolean isSortOrderAscending() {
        return this.sortOrderAscending;
    }

    public void setSortOrderAscending(boolean isSortOrderAscending) {
        this.sortOrderAscending = isSortOrderAscending;
    }

    public void setRowListPage(List rowList) {
        this.rowListPage = rowList;
    }

    public TableDecorator getTableDecorator() {
        return this.tableDecorator;
    }

    public void setTableDecorator(TableDecorator decorator) {
        this.tableDecorator = decorator;
    }

    public boolean isSorted() {
        return this.sortedColumn != -1;
    }

    public HeaderCell getSortedColumnHeader() {
        if (this.sortedColumn < 0 || this.sortedColumn > this.headerCellList.size() - 1) {
            return null;
        }
        return (HeaderCell)this.headerCellList.get(this.sortedColumn);
    }

    public int getNumberOfColumns() {
        return this.headerCellList.size();
    }

    public boolean isEmpty() {
        return this.headerCellList.size() == 0;
    }

    public int getSortedColumnNumber() {
        return this.sortedColumn;
    }

    public void setSortedColumnNumber(int sortIndex) {
        this.sortedColumn = sortIndex;
    }

    public void addColumnHeader(HeaderCell headerCell) {
        if (this.sortedColumn == this.headerCellList.size()) {
            headerCell.setAlreadySorted();
        }
        headerCell.setColumnNumber(this.headerCellList.size());
        this.headerCellList.add(headerCell);
    }

    public List getHeaderCellList() {
        return this.headerCellList;
    }

    public RowIterator getRowIterator(boolean full) {
        RowIterator iterator = new RowIterator(full ? this.rowListFull : this.rowListPage, this.headerCellList, this.tableDecorator);
        iterator.setId(this.id);
        return iterator;
    }

    private void sortRowList(List list) {
        HeaderCell sortedHeaderCell;
        if (this.isSorted() && (sortedHeaderCell = this.getSortedColumnHeader()) != null && (sortedHeaderCell.getBeanPropertyName() != null || this.sortedColumn != -1 && this.sortedColumn < this.headerCellList.size())) {
            Collections.sort(list, new RowSorter(this.sortedColumn, sortedHeaderCell.getBeanPropertyName(), this.getTableDecorator(), this.sortOrderAscending));
        }
    }

    public void sortPageList() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.id + "] sorting page list"));
        }
        this.sortRowList(this.rowListPage);
    }

    public void sortFullList() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.id + "] sorting full data"));
        }
        this.sortRowList(this.rowListFull);
    }

    public TableProperties getProperties() {
        return this.properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

