/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.pagination;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.pagination.NumberedPage;
import org.displaytag.util.Href;

public class Pagination {
    private static Log log = LogFactory.getLog((Class)(class$org$displaytag$pagination$Pagination == null ? (class$org$displaytag$pagination$Pagination = Pagination.class$("org.displaytag.pagination.Pagination")) : class$org$displaytag$pagination$Pagination));
    private Href href;
    private String pageParam;
    private Integer firstPage;
    private Integer lastPage;
    private Integer previousPage;
    private Integer nextPage;
    private List pages = new ArrayList();
    static /* synthetic */ Class class$org$displaytag$pagination$Pagination;

    public Pagination(Href baseHref, String pageParameter) {
        this.href = baseHref;
        this.pageParam = pageParameter;
    }

    public void addPage(int number, boolean isSelected) {
        log.debug((Object)("addpage " + number));
        this.pages.add(new NumberedPage(number, isSelected));
    }

    public boolean isFirst() {
        return this.firstPage == null;
    }

    public boolean isLast() {
        return this.lastPage == null;
    }

    public boolean isOnePage() {
        return this.pages == null || this.pages.size() <= 1;
    }

    public Integer getFirst() {
        return this.firstPage;
    }

    public void setFirst(Integer first) {
        this.firstPage = first;
    }

    public Integer getLast() {
        return this.lastPage;
    }

    public void setLast(Integer last) {
        this.lastPage = last;
    }

    public Integer getPrevious() {
        return this.previousPage;
    }

    public void setPrevious(Integer previous) {
        this.previousPage = previous;
    }

    public Integer getNext() {
        return this.nextPage;
    }

    public void setNext(Integer next) {
        this.nextPage = next;
    }

    public String getFormattedBanner(String numberedPageFormat, String numberedPageSelectedFormat, String numberedPageSeparator, String fullBanner) {
        StringBuffer buffer = new StringBuffer(100);
        Iterator pageIterator = this.pages.iterator();
        while (pageIterator.hasNext()) {
            NumberedPage page = (NumberedPage)pageIterator.next();
            Integer pageNumber = new Integer(page.getNumber());
            String urlString = ((Href)this.href.clone()).addParameter(this.pageParam, pageNumber).toString();
            Object[] pageObjects = new Object[]{pageNumber, urlString};
            if (page.getSelected()) {
                buffer.append(MessageFormat.format(numberedPageSelectedFormat, pageObjects));
            } else {
                buffer.append(MessageFormat.format(numberedPageFormat, pageObjects));
            }
            if (!pageIterator.hasNext()) continue;
            buffer.append(numberedPageSeparator);
        }
        String numberedPageString = buffer.toString();
        Object[] pageObjects = new Object[]{numberedPageString, ((Href)this.href.clone()).addParameter(this.pageParam, this.getFirst()), ((Href)this.href.clone()).addParameter(this.pageParam, this.getPrevious()), ((Href)this.href.clone()).addParameter(this.pageParam, this.getNext()), ((Href)this.href.clone()).addParameter(this.pageParam, this.getLast())};
        return MessageFormat.format(fullBanner, pageObjects);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("firstPage", (Object)this.firstPage).append("lastPage", (Object)this.lastPage).append("nextPage", (Object)this.nextPage).append("previousPage", (Object)this.previousPage).append("pages", (Object)this.pages).append("href", (Object)this.href).append("pageParam", (Object)this.pageParam).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

