/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.properties;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.exception.FactoryInstantiationException;
import org.displaytag.exception.TablePropertiesLoadException;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.util.RequestHelperFactory;

public final class TableProperties {
    public static final String DEFAULT_FILENAME = "TableTag.properties";
    public static final String LOCAL_PROPERTIES = "displaytag";
    public static final String PROPERTY_STRING_EXPORTBANNER = "export.banner";
    public static final String PROPERTY_STRING_EXPORTBANNER_SEPARATOR = "export.banner.sepchar";
    public static final String PROPERTY_BOOLEAN_EXPORTDECORATED = "export.decorated";
    public static final String PROPERTY_STRING_EXPORTAMOUNT = "export.amount";
    public static final String PROPERTY_STRING_SORTAMOUNT = "sort.amount";
    public static final String PROPERTY_BOOLEAN_SHOWHEADER = "basic.show.header";
    public static final String PROPERTY_STRING_EMPTYLIST_MESSAGE = "basic.msg.empty_list";
    public static final String PROPERTY_STRING_EMPTYLISTROW_MESSAGE = "basic.msg.empty_list_row";
    public static final String PROPERTY_BOOLEAN_EMPTYLIST_SHOWTABLE = "basic.empty.showtable";
    public static final String PROPERTY_STRING_BANNER_PLACEMENT = "paging.banner.placement";
    public static final String PROPERTY_STRING_PAGING_INVALIDPAGE = "error.msg.invalid_page";
    public static final String PROPERTY_STRING_PAGING_ITEM_NAME = "paging.banner.item_name";
    public static final String PROPERTY_STRING_PAGING_ITEMS_NAME = "paging.banner.items_name";
    public static final String PROPERTY_STRING_PAGING_NOITEMS = "paging.banner.no_items_found";
    public static final String PROPERTY_STRING_PAGING_FOUND_ONEITEM = "paging.banner.one_item_found";
    public static final String PROPERTY_STRING_PAGING_FOUND_ALLITEMS = "paging.banner.all_items_found";
    public static final String PROPERTY_STRING_PAGING_FOUND_SOMEITEMS = "paging.banner.some_items_found";
    public static final String PROPERTY_INT_PAGING_GROUPSIZE = "paging.banner.group_size";
    public static final String PROPERTY_STRING_PAGING_BANNER_ONEPAGE = "paging.banner.onepage";
    public static final String PROPERTY_STRING_PAGING_BANNER_FIRST = "paging.banner.first";
    public static final String PROPERTY_STRING_PAGING_BANNER_LAST = "paging.banner.last";
    public static final String PROPERTY_STRING_PAGING_BANNER_FULL = "paging.banner.full";
    public static final String PROPERTY_STRING_PAGING_PAGE_LINK = "paging.banner.page.link";
    public static final String PROPERTY_STRING_PAGING_PAGE_SELECTED = "paging.banner.page.selected";
    public static final String PROPERTY_STRING_PAGING_PAGE_SPARATOR = "paging.banner.page.separator";
    public static final String PROPERTY_CLASS_REQUESTHELPERFACTORY = "factory.requestHelper";
    public static final String PROPERTY_CSS_TR_EVEN = "css.tr.even";
    public static final String PROPERTY_CSS_TR_ODD = "css.tr.odd";
    public static final String PROPERTY_CSS_TABLE = "css.table";
    public static final String PROPERTY_CSS_TH_SORTABLE = "css.th.sortable";
    public static final String PROPERTY_CSS_TH_SORTED = "css.th.sorted";
    public static final String PROPERTY_CSS_TH_SORTED_ASCENDING = "css.th.ascending";
    public static final String PROPERTY_CSS_TH_SORTED_DESCENDING = "css.th.descending";
    public static final String PROPERTY_EXPORT_PREFIX = "export";
    public static final String EXPORTPROPERTY_STRING_LABEL = "label";
    public static final String EXPORTPROPERTY_BOOLEAN_EXPORTHEADER = "include_header";
    public static final String EXPORTPROPERTY_STRING_FILENAME = "filename";
    private static Log log = LogFactory.getLog((Class)(class$org$displaytag$properties$TableProperties == null ? (class$org$displaytag$properties$TableProperties = TableProperties.class$("org.displaytag.properties.TableProperties")) : class$org$displaytag$properties$TableProperties));
    private static Properties userProperties = new Properties();
    private static Properties defaultProperties;
    private Properties properties;
    static /* synthetic */ Class class$org$displaytag$properties$TableProperties;

    private TableProperties() throws TablePropertiesLoadException {
        if (defaultProperties == null) {
            defaultProperties = new Properties();
            try {
                defaultProperties.load(this.getClass().getResourceAsStream(DEFAULT_FILENAME));
            }
            catch (IOException e) {
                throw new TablePropertiesLoadException(this.getClass(), DEFAULT_FILENAME, e);
            }
            this.loadUserProperties();
        }
        this.properties = (Properties)((Hashtable)defaultProperties).clone();
    }

    private void loadUserProperties() {
        String key;
        Enumeration<String> keys;
        ResourceBundle bundle;
        block5: {
            bundle = null;
            try {
                bundle = ResourceBundle.getBundle(LOCAL_PROPERTIES);
            }
            catch (MissingResourceException e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("Was not able to load a custom displaytag.properties; " + e.getMessage()));
            }
        }
        Properties mixedProperties = new Properties(defaultProperties);
        if (bundle != null) {
            keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                mixedProperties.setProperty(key, bundle.getString(key));
            }
        }
        keys = ((Hashtable)userProperties).keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            if (key == null) continue;
            mixedProperties.setProperty(key, (String)((Hashtable)userProperties).get(key));
        }
        defaultProperties = mixedProperties;
    }

    public static TableProperties getInstance() {
        return new TableProperties();
    }

    public static void setUserProperties(Properties overrideProperties) {
        userProperties = overrideProperties;
        if (defaultProperties != null) {
            Enumeration keys = ((Hashtable)userProperties).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key == null) continue;
                defaultProperties.setProperty(key, (String)((Hashtable)userProperties).get(key));
            }
        }
    }

    public String getPagingInvalidPage() {
        return this.getProperty(PROPERTY_STRING_PAGING_INVALIDPAGE);
    }

    public String getPagingItemName() {
        return this.getProperty(PROPERTY_STRING_PAGING_ITEM_NAME);
    }

    public String getPagingItemsName() {
        return this.getProperty(PROPERTY_STRING_PAGING_ITEMS_NAME);
    }

    public String getPagingFoundNoItems() {
        return this.getProperty(PROPERTY_STRING_PAGING_NOITEMS);
    }

    public String getPagingFoundOneItem() {
        return this.getProperty(PROPERTY_STRING_PAGING_FOUND_ONEITEM);
    }

    public String getPagingFoundAllItems() {
        return this.getProperty(PROPERTY_STRING_PAGING_FOUND_ALLITEMS);
    }

    public String getPagingFoundSomeItems() {
        return this.getProperty(PROPERTY_STRING_PAGING_FOUND_SOMEITEMS);
    }

    public int getPagingGroupSize(int defaultValue) {
        return this.getIntProperty(PROPERTY_INT_PAGING_GROUPSIZE, defaultValue);
    }

    public String getPagingBannerOnePage() {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_ONEPAGE);
    }

    public String getPagingBannerFirst() {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_FIRST);
    }

    public String getPagingBannerLast() {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_LAST);
    }

    public String getPagingBannerFull() {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_FULL);
    }

    public String getPagingPageLink() {
        return this.getProperty(PROPERTY_STRING_PAGING_PAGE_LINK);
    }

    public String getPagingPageSelected() {
        return this.getProperty(PROPERTY_STRING_PAGING_PAGE_SELECTED);
    }

    public String getPagingPageSeparator() {
        return this.getProperty(PROPERTY_STRING_PAGING_PAGE_SPARATOR);
    }

    public boolean getAddExport(MediaTypeEnum exportType) {
        return this.getBooleanProperty("export." + exportType.getName());
    }

    public boolean getExportHeader(MediaTypeEnum exportType) {
        return this.getBooleanProperty("export." + exportType + "." + EXPORTPROPERTY_BOOLEAN_EXPORTHEADER);
    }

    public String getExportLabel(MediaTypeEnum exportType) {
        return this.getProperty("export." + exportType + "." + EXPORTPROPERTY_STRING_LABEL);
    }

    public String getExportFilename(MediaTypeEnum exportType) {
        return this.getProperty("export." + exportType + "." + EXPORTPROPERTY_STRING_FILENAME);
    }

    public String getExportFileName(MediaTypeEnum exportType) {
        return this.getProperty("export." + exportType + "." + EXPORTPROPERTY_STRING_FILENAME);
    }

    public boolean getExportDecorated() {
        return this.getBooleanProperty(PROPERTY_BOOLEAN_EXPORTDECORATED);
    }

    public String getExportBanner() {
        return this.getProperty(PROPERTY_STRING_EXPORTBANNER);
    }

    public String getExportBannerSeparator() {
        return this.getProperty(PROPERTY_STRING_EXPORTBANNER_SEPARATOR);
    }

    public boolean getShowHeader() {
        return this.getBooleanProperty(PROPERTY_BOOLEAN_SHOWHEADER);
    }

    public String getEmptyListMessage() {
        return this.getProperty(PROPERTY_STRING_EMPTYLIST_MESSAGE);
    }

    public String getEmptyListRowMessage() {
        return this.getProperty(PROPERTY_STRING_EMPTYLISTROW_MESSAGE);
    }

    public boolean getEmptyListShowTable() {
        return this.getBooleanProperty(PROPERTY_BOOLEAN_EMPTYLIST_SHOWTABLE);
    }

    public boolean getExportFullList() {
        return "list".equals(this.getProperty(PROPERTY_STRING_EXPORTAMOUNT));
    }

    public boolean getSortFullList() {
        return "list".equals(this.getProperty(PROPERTY_STRING_SORTAMOUNT));
    }

    public boolean getAddPagingBannerTop() {
        String placement = this.getProperty(PROPERTY_STRING_BANNER_PLACEMENT);
        return "top".equals(placement) || "both".equals(placement);
    }

    public boolean getAddPagingBannerBottom() {
        String placement = this.getProperty(PROPERTY_STRING_BANNER_PLACEMENT);
        return "bottom".equals(placement) || "both".equals(placement);
    }

    public String getCssRow(int rowNumber) {
        if (rowNumber % 2 == 0) {
            return this.getProperty(PROPERTY_CSS_TR_ODD);
        }
        return this.getProperty(PROPERTY_CSS_TR_EVEN);
    }

    public String getCssOrder(boolean ascending) {
        if (ascending) {
            return this.getProperty(PROPERTY_CSS_TH_SORTED_ASCENDING);
        }
        return this.getProperty(PROPERTY_CSS_TH_SORTED_DESCENDING);
    }

    public String getCssSorted() {
        return this.getProperty(PROPERTY_CSS_TH_SORTED);
    }

    public String getCssTable() {
        return this.getProperty(PROPERTY_CSS_TABLE);
    }

    public String getCssSortable() {
        return this.getProperty(PROPERTY_CSS_TH_SORTABLE);
    }

    public RequestHelperFactory getRequestHelperFactoryInstance() throws FactoryInstantiationException {
        Object loadedObject = this.getClassPropertyInstance(PROPERTY_CLASS_REQUESTHELPERFACTORY);
        try {
            return (RequestHelperFactory)loadedObject;
        }
        catch (ClassCastException e) {
            throw new FactoryInstantiationException(this.getClass(), PROPERTY_CLASS_REQUESTHELPERFACTORY, loadedObject.getClass().getName(), e);
        }
    }

    private String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    private boolean getBooleanProperty(String key) {
        return Boolean.TRUE.toString().equals(this.getProperty(key));
    }

    private Object getClassPropertyInstance(String key) throws FactoryInstantiationException {
        String className = this.getProperty(key);
        try {
            Class<?> classProperty = Class.forName(className);
            return classProperty.newInstance();
        }
        catch (Exception e) {
            throw new FactoryInstantiationException(this.getClass(), key, className, e);
        }
    }

    private int getIntProperty(String key, int defaultValue) {
        int intValue = defaultValue;
        try {
            intValue = Integer.parseInt(this.getProperty(key));
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Invalid value for \"" + key + "\" property: value=\"" + this.getProperty(key) + "\"; using default \"" + defaultValue + "\""));
        }
        return intValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

