/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.tags;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.DecoratorFactory;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ExportException;
import org.displaytag.exception.FactoryInstantiationException;
import org.displaytag.exception.InvalidTagAttributeValueException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.export.BaseExportView;
import org.displaytag.export.ExportViewFactory;
import org.displaytag.model.Cell;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;
import org.displaytag.pagination.SmartListHelper;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.SortOrderEnum;
import org.displaytag.properties.TableProperties;
import org.displaytag.tags.HtmlTableTag;
import org.displaytag.util.Anchor;
import org.displaytag.util.CollectionUtil;
import org.displaytag.util.DependencyChecker;
import org.displaytag.util.Href;
import org.displaytag.util.ParamEncoder;
import org.displaytag.util.RequestHelper;
import org.displaytag.util.RequestHelperFactory;

public class TableTag
extends HtmlTableTag {
    public static final String PAGE_ATTRIBUTE_MEDIA = "mediaType";
    public static final String FILTER_CONTENT_OVERRIDE_BODY = "org.displaytag.filter.ResponseOverrideFilter.CONTENT_OVERRIDE_BODY";
    public static final String FILTER_CONTENT_OVERRIDE_TYPE = "org.displaytag.filter.ResponseOverrideFilter.CONTENT_OVERRIDE_TYPE";
    public static final String FILTER_CONTENT_OVERRIDE_FILENAME = "org.displaytag.filter.ResponseOverrideFilter.CONTENT_OVERRIDE_FILENAME";
    private static Log log = LogFactory.getLog((Class)(class$org$displaytag$tags$TableTag == null ? (class$org$displaytag$tags$TableTag = TableTag.class$("org.displaytag.tags.TableTag")) : class$org$displaytag$tags$TableTag));
    private static RequestHelperFactory rhf;
    protected Object list;
    private int rowNumber = 1;
    private String name;
    private String property;
    private String scope;
    private int length;
    private String decoratorName;
    private int pagesize;
    private boolean export;
    private int offset;
    private Boolean sortFullTable;
    private String requestUri;
    private int defaultSortedColumn = -1;
    private SortOrderEnum defaultSortOrder;
    private Map previousRow;
    private TableModel tableModel;
    private Row currentRow;
    private Map nextRow;
    private SmartListHelper listHelper;
    private Href baseHref;
    private TableProperties properties;
    private int pageNumber = 1;
    private Iterator tableIterator;
    private MediaTypeEnum currentMediaType;
    private int previousSortedColumn;
    private boolean previousOrder;
    private boolean doAfterBodyExecuted;
    private ParamEncoder paramEncoder;
    private String footer;
    private String caption;
    static /* synthetic */ Class class$org$displaytag$tags$TableTag;

    public void setFooter(String string) {
        this.footer = string;
    }

    public void setCaption(String string) {
        this.caption = string;
    }

    protected boolean isEmpty() {
        return this.currentRow == null;
    }

    public void setSort(String value) throws InvalidTagAttributeValueException {
        if ("page".equals(value)) {
            this.sortFullTable = Boolean.FALSE;
        } else if ("list".equals(value)) {
            this.sortFullTable = Boolean.TRUE;
        } else {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "sort", value);
        }
    }

    public void setRequestURI(String value) {
        String contextPath = ((HttpServletRequest)((TagSupport)this).pageContext.getRequest()).getContextPath();
        this.requestUri = !StringUtils.isEmpty((String)contextPath) && value != null && value.startsWith("/") && !value.startsWith(contextPath) ? contextPath + value : value;
    }

    public void setList(Object value) {
        this.list = value;
    }

    public void setName(Object value) {
        if (value instanceof String) {
            this.name = (String)value;
        } else {
            this.list = value;
        }
    }

    public void setNameString(String value) {
        this.name = value;
    }

    public void setProperty(String value) {
        this.property = value;
    }

    public void setDefaultorder(String value) throws InvalidTagAttributeValueException {
        this.defaultSortOrder = SortOrderEnum.fromName(value);
        if (this.defaultSortOrder == null) {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "defaultorder", value);
        }
    }

    public void setScope(String value) {
        this.scope = value;
    }

    public void setDecorator(String decorator) {
        this.decoratorName = decorator;
    }

    public void setExport(boolean value) {
        this.export = value;
    }

    public void setLength(int value) {
        this.length = value;
    }

    public void setDefaultsort(int value) {
        this.defaultSortedColumn = value - 1;
    }

    public void setPagesize(int value) {
        this.pagesize = value;
    }

    public void setOffset(int value) {
        this.offset = value < 1 ? 0 : value - 1;
    }

    public PageContext getPageContext() {
        return ((TagSupport)this).pageContext;
    }

    protected TableProperties getProperties() {
        return this.properties;
    }

    public void addColumn(HeaderCell column) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] addColumn " + column));
        }
        this.tableModel.addColumnHeader(column);
    }

    public void addCell(Cell cell) {
        if (this.currentRow != null) {
            this.currentRow.addCell(cell);
        }
    }

    protected boolean isFirstIteration() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] first iteration=" + (this.rowNumber == 1) + " (row number=" + this.rowNumber + ")"));
        }
        return this.rowNumber == 1;
    }

    public int doStartTag() throws JspException {
        DependencyChecker.check();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] doStartTag called"));
        }
        this.properties = TableProperties.getInstance();
        this.tableModel = new TableModel(this.properties);
        this.tableModel.setId(this.getId());
        this.initParameters();
        if (this.currentMediaType != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getId() + "] setting media [" + this.currentMediaType + "] in this.pageContext"));
            }
            ((TagSupport)this).pageContext.setAttribute(PAGE_ATTRIBUTE_MEDIA, (Object)this.currentMediaType);
        }
        this.doIteration();
        return 2;
    }

    public int doAfterBody() {
        this.doAfterBodyExecuted = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] doAfterBody called - iterating on row " + this.rowNumber));
        }
        ++this.rowNumber;
        return this.doIteration();
    }

    protected int doIteration() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] doIteration called"));
        }
        if (this.currentRow != null) {
            this.tableModel.addRow(this.currentRow);
            this.currentRow = null;
        }
        if (this.tableIterator.hasNext()) {
            Object iteratedObject = this.tableIterator.next();
            if (this.getId() != null) {
                if (iteratedObject != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[" + this.getId() + "] setting attribute \"" + this.getId() + "\" in pageContext"));
                    }
                    ((TagSupport)this).pageContext.setAttribute(this.getId(), iteratedObject);
                } else {
                    ((TagSupport)this).pageContext.removeAttribute(this.getId());
                }
                ((TagSupport)this).pageContext.setAttribute(((TagSupport)this).id + "_rowNum", (Object)new Integer(this.rowNumber));
            }
            this.currentRow = new Row(iteratedObject, this.rowNumber);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getId() + "] doIteration() returning EVAL_BODY_TAG"));
            }
            return 2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] doIteration() - iterator ended after " + (this.rowNumber - 1) + " rows"));
        }
        return 0;
    }

    private void initParameters() throws ObjectLookupException, FactoryInstantiationException {
        String fullName;
        if (rhf == null) {
            rhf = this.properties.getRequestHelperFactoryInstance();
        }
        RequestHelper requestHelper = rhf.getRequestHelperInstance(((TagSupport)this).pageContext);
        this.initHref(requestHelper);
        Integer pageNumberParameter = requestHelper.getIntParameter(this.encodeParameter("p"));
        this.pageNumber = pageNumberParameter == null ? 1 : pageNumberParameter;
        Integer sortColumnParameter = requestHelper.getIntParameter(this.encodeParameter("s"));
        int sortColumn = sortColumnParameter == null ? this.defaultSortedColumn : sortColumnParameter;
        this.tableModel.setSortedColumnNumber(sortColumn);
        boolean finalSortFull = this.properties.getSortFullList();
        if (this.sortFullTable != null) {
            finalSortFull = this.sortFullTable;
        }
        this.tableModel.setSortFullTable(finalSortFull);
        SortOrderEnum paramOrder = SortOrderEnum.fromIntegerCode(requestHelper.getIntParameter(this.encodeParameter("o")));
        if (paramOrder == null) {
            paramOrder = this.defaultSortOrder;
        }
        boolean order = SortOrderEnum.DESCENDING != paramOrder;
        this.tableModel.setSortOrderAscending(order);
        if (finalSortFull && sortColumn != -1) {
            this.baseHref.addParameter(this.encodeParameter("xs"), sortColumn);
            this.baseHref.addParameter(this.encodeParameter("xo"), paramOrder);
            Integer previousSortColumnParameter = requestHelper.getIntParameter(this.encodeParameter("s"));
            this.previousSortedColumn = previousSortColumnParameter == null ? -1 : previousSortColumnParameter;
            SortOrderEnum previousParamOrder = SortOrderEnum.fromIntegerCode(requestHelper.getIntParameter(this.encodeParameter("xo")));
            this.previousOrder = SortOrderEnum.DESCENDING != previousParamOrder;
        }
        Integer exportTypeParameter = requestHelper.getIntParameter(this.encodeParameter("e"));
        this.currentMediaType = MediaTypeEnum.fromIntegerCode(exportTypeParameter);
        if (this.currentMediaType == null) {
            this.currentMediaType = MediaTypeEnum.HTML;
        }
        if ((fullName = this.getFullObjectName()) != null) {
            this.list = this.evaluateExpression(fullName);
        }
        this.tableIterator = IteratorUtils.getIterator((Object)this.list);
    }

    private String getFullObjectName() {
        if (this.name == null) {
            return null;
        }
        StringBuffer fullName = new StringBuffer();
        if (StringUtils.isNotBlank((String)this.scope)) {
            fullName.append(this.scope).append("Scope.");
        }
        fullName.append(this.name);
        if (StringUtils.isNotBlank((String)this.property)) {
            fullName.append('.').append(this.property);
        }
        return fullName.toString();
    }

    protected void initHref(RequestHelper requestHelper) {
        Href normalHref = requestHelper.getHref();
        if (this.requestUri != null) {
            String encodedURI = ((HttpServletResponse)((TagSupport)this).pageContext.getResponse()).encodeURL(this.requestUri);
            this.baseHref = new Href(encodedURI);
            Map parameterMap = normalHref.getParameterMap();
            this.baseHref.addParameterMap(parameterMap);
        } else {
            this.baseHref = normalHref;
        }
    }

    public int doEndTag() throws JspException {
        TableDecorator tableDecorator;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] doEndTag called"));
        }
        if (!this.doAfterBodyExecuted) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getId() + "] tag body is empty."));
            }
            if (this.currentRow != null) {
                this.tableModel.addRow(this.currentRow);
            }
            while (this.tableIterator.hasNext()) {
                Object iteratedObject = this.tableIterator.next();
                ++this.rowNumber;
                this.currentRow = new Row(iteratedObject, this.rowNumber);
                this.tableModel.addRow(this.currentRow);
            }
        }
        if (this.tableModel.isEmpty()) {
            this.describeEmptyTable();
        }
        if ((tableDecorator = DecoratorFactory.loadTableDecorator(this.decoratorName)) != null) {
            tableDecorator.init(((TagSupport)this).pageContext, this.list);
            this.tableModel.setTableDecorator(tableDecorator);
        }
        List pageData = this.getViewableData();
        this.tableModel.setRowListPage(pageData);
        if (!this.tableModel.isSortFullTable()) {
            this.tableModel.sortPageList();
        }
        StringBuffer buffer = new StringBuffer(8000);
        int returnValue = 6;
        if (MediaTypeEnum.HTML.equals(this.currentMediaType)) {
            buffer.append(this.getHTMLData());
            this.write(buffer);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getId() + "] doEndTag - exporting"));
            }
            returnValue = this.doExport();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] doEndTag - end"));
        }
        this.cleanUp();
        return returnValue;
    }

    private void cleanUp() {
        this.currentMediaType = null;
        this.baseHref = null;
        this.caption = null;
        this.currentRow = null;
        this.doAfterBodyExecuted = false;
        this.footer = null;
        this.listHelper = null;
        this.nextRow = null;
        this.pageNumber = 0;
        this.paramEncoder = null;
        this.previousOrder = false;
        this.previousRow = null;
        this.previousSortedColumn = 0;
        this.properties = null;
        this.rowNumber = 1;
        this.tableIterator = null;
        this.tableModel = null;
    }

    private void describeEmptyTable() {
        this.tableIterator = IteratorUtils.getIterator((Object)this.list);
        if (this.tableIterator.hasNext()) {
            Object iteratedObject = this.tableIterator.next();
            Map objectProperties = new HashMap();
            if (iteratedObject instanceof String) {
                return;
            }
            if (iteratedObject instanceof Map) {
                objectProperties = (Map)iteratedObject;
            } else {
                try {
                    objectProperties = BeanUtils.describe(iteratedObject);
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to automatically add columns: " + e.getMessage()), (Throwable)e);
                }
            }
            Iterator propertiesIterator = objectProperties.keySet().iterator();
            while (propertiesIterator.hasNext()) {
                String propertyName = (String)propertiesIterator.next();
                if ("class".equals(propertyName)) continue;
                HeaderCell headerCell = new HeaderCell();
                headerCell.setBeanPropertyName(propertyName);
                this.tableModel.addColumnHeader(headerCell);
            }
        }
    }

    protected int doExport() throws JspException {
        BaseExportView exportView = null;
        boolean exportFullList = this.properties.getExportFullList();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] currentMediaType=" + this.currentMediaType));
        }
        boolean exportHeader = this.properties.getExportHeader(this.currentMediaType);
        boolean exportDecorated = this.properties.getExportDecorated();
        exportView = ExportViewFactory.getView(this.currentMediaType, this.tableModel, exportFullList, exportHeader, exportDecorated);
        String mimeType = exportView.getMimeType();
        String exportString = exportView.doExport();
        String filename = this.properties.getExportFileName(this.currentMediaType);
        return this.writeExport(mimeType, exportString, filename);
    }

    protected int writeExport(String mimeType, String exportString, String filename) throws JspException {
        HttpServletResponse response = (HttpServletResponse)((TagSupport)this).pageContext.getResponse();
        JspWriter out = ((TagSupport)this).pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)((TagSupport)this).pageContext.getRequest();
        StringBuffer bodyBuffer = (StringBuffer)request.getAttribute(FILTER_CONTENT_OVERRIDE_BODY);
        if (bodyBuffer != null) {
            StringBuffer contentTypeOverride = (StringBuffer)request.getAttribute(FILTER_CONTENT_OVERRIDE_TYPE);
            contentTypeOverride.append(mimeType);
            bodyBuffer.append(exportString);
            if (StringUtils.isNotEmpty((String)filename)) {
                StringBuffer filenameOverride = (StringBuffer)request.getAttribute(FILTER_CONTENT_OVERRIDE_FILENAME);
                filenameOverride.append(filename);
            }
        } else {
            if (response.isCommitted()) {
                throw new ExportException(((Object)((Object)this)).getClass());
            }
            if (response.containsHeader("Cache-Control")) {
                response.setHeader("Cache-Control", "public");
            }
            if (response.containsHeader("Expires")) {
                response.setHeader("Expires", "Thu, 01 Dec 2069 16:00:00 GMT");
            }
            if (response.containsHeader("Pragma")) {
                response.setHeader("Pragma", "");
            }
            try {
                out.clear();
            }
            catch (Exception e) {
                throw new ExportException(((Object)((Object)this)).getClass());
            }
            response.setContentType(mimeType);
            if (StringUtils.isNotEmpty((String)filename)) {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
            }
            try {
                out.write(exportString);
            }
            catch (IOException e) {
                throw new JspException("IOException while writing data.");
            }
        }
        return 5;
    }

    public List getViewableData() {
        List fullList = new ArrayList();
        if (this.tableModel.isSortFullTable()) {
            this.tableModel.sortFullList();
        }
        List originalData = this.tableModel.getRowListFull();
        fullList = CollectionUtil.getListFromObject(originalData, this.offset, this.length);
        if (this.pagesize > 0) {
            this.listHelper = new SmartListHelper(fullList, this.pagesize, this.properties);
            this.listHelper.setCurrentPage(this.pageNumber);
            fullList = this.listHelper.getListForCurrentPage();
        }
        return fullList;
    }

    private String getHTMLData() throws JspException {
        String css;
        boolean noItems;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] getHTMLData called for table [" + this.getId() + "]"));
        }
        boolean bl = noItems = this.tableModel.getRowListPage().size() == 0;
        if (noItems && !this.properties.getEmptyListShowTable()) {
            return this.properties.getEmptyListMessage();
        }
        StringBuffer buffer = new StringBuffer(8000);
        this.previousRow = new Hashtable(10);
        this.nextRow = new Hashtable(10);
        if (this.properties.getAddPagingBannerTop()) {
            buffer.append(this.getSearchResultAndNavigation());
        }
        if (StringUtils.isNotBlank((String)(css = this.properties.getCssTable()))) {
            this.addClass(css);
        }
        buffer.append(this.getOpenTag());
        if (this.caption != null) {
            buffer.append(this.caption);
        }
        if (this.properties.getShowHeader()) {
            buffer.append(this.getTableHeader());
        }
        if (this.footer != null) {
            buffer.append("\n<tfoot>");
            buffer.append(this.footer);
            buffer.append("</tfoot>");
            this.footer = null;
        }
        buffer.append("\n<tbody>");
        buffer.append(this.getTableBody());
        buffer.append("</tbody>");
        buffer.append(this.getCloseTag());
        buffer.append(this.getTableFooter());
        if (this.tableModel.getTableDecorator() != null) {
            this.tableModel.getTableDecorator().finish();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] getHTMLData end"));
        }
        return buffer.toString();
    }

    private String getTableHeader() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] getTableHeader called"));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n<thead>");
        buffer.append("\n<tr>");
        if (this.tableModel.isEmpty()) {
            buffer.append("\n<th>");
            buffer.append("</th>");
        }
        Iterator iterator = this.tableModel.getHeaderCellList().iterator();
        while (iterator.hasNext()) {
            HeaderCell headerCell = (HeaderCell)iterator.next();
            if (headerCell.getSortable()) {
                String cssSortable = this.properties.getCssSortable();
                headerCell.addHeaderClass(cssSortable);
            }
            if (headerCell.isAlreadySorted()) {
                headerCell.addHeaderClass(this.properties.getCssSorted());
                headerCell.addHeaderClass(this.properties.getCssOrder(this.tableModel.isSortOrderAscending()));
            }
            buffer.append(headerCell.getHeaderOpenTag());
            String header = headerCell.getTitle();
            if (headerCell.getSortable()) {
                Anchor anchor = new Anchor(this.getSortingHref(headerCell), header);
                header = anchor.toString();
            }
            buffer.append(header);
            buffer.append(headerCell.getHeaderCloseTag());
        }
        buffer.append("</tr>");
        buffer.append("</thead>");
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] getTableHeader end"));
        }
        return buffer.toString();
    }

    private Href getSortingHref(HeaderCell headerCell) {
        boolean nowOrderAscending;
        Href href = new Href(this.baseHref);
        href.addParameter(this.encodeParameter("s"), headerCell.getColumnNumber());
        boolean bl = nowOrderAscending = !headerCell.isAlreadySorted() || !this.tableModel.isSortOrderAscending();
        if (nowOrderAscending) {
            href.addParameter(this.encodeParameter("o"), SortOrderEnum.ASCENDING.getCode());
        } else {
            href.addParameter(this.encodeParameter("o"), SortOrderEnum.DESCENDING.getCode());
        }
        if (this.tableModel.isSortFullTable() && (headerCell.getColumnNumber() != this.previousSortedColumn || nowOrderAscending ^ this.previousOrder)) {
            href.addParameter(this.encodeParameter("p"), 1);
        }
        return href;
    }

    private String groupColumns(String value, int group) {
        if (group == 1 & this.nextRow.size() > 0) {
            this.previousRow.clear();
            this.previousRow.putAll(this.nextRow);
            this.nextRow.clear();
        }
        if (!this.nextRow.containsKey(new Integer(group))) {
            this.nextRow.put(new Integer(group), new String(value));
        }
        if (this.previousRow.containsKey(new Integer(group))) {
            for (int j = 1; j <= group; ++j) {
                if (((String)this.previousRow.get(new Integer(j))).equals(this.nextRow.get(new Integer(j)))) continue;
                return value;
            }
        }
        if (this.previousRow.size() == 0) {
            return value;
        }
        return "";
    }

    private String getTableBody() throws ObjectLookupException, DecoratorException {
        StringBuffer buffer = new StringBuffer();
        RowIterator rowIterator = this.tableModel.getRowIterator(false);
        while (rowIterator.hasNext()) {
            String endRow;
            String stringStartRow;
            Row row = rowIterator.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getId() + "] rowIterator.next()=" + row));
            }
            if (this.tableModel.getTableDecorator() != null && (stringStartRow = this.tableModel.getTableDecorator().startRow()) != null) {
                buffer.append(stringStartRow);
            }
            buffer.append(row.getOpenTag());
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getId() + "] creating ColumnIterator on " + this.tableModel.getHeaderCellList()));
            }
            ColumnIterator columnIterator = row.getColumnIterator(this.tableModel.getHeaderCellList());
            while (columnIterator.hasNext()) {
                Column column = columnIterator.nextColumn();
                buffer.append(column.getOpenTag());
                String value = column.getChoppedAndLinkedValue();
                if (column.getGroup() != -1) {
                    value = this.groupColumns(value.toString(), column.getGroup());
                }
                buffer.append((Object)value);
                buffer.append(column.getCloseTag());
            }
            if (this.tableModel.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[" + this.getId() + "] table has no columns"));
                }
                buffer.append("\n<td>").append(row.getObject().toString()).append("</td>");
            }
            buffer.append(row.getCloseTag());
            if (this.tableModel.getTableDecorator() == null || (endRow = this.tableModel.getTableDecorator().finishRow()) == null) continue;
            buffer.append(endRow);
        }
        if (this.tableModel.getRowListPage().size() == 0) {
            buffer.append(MessageFormat.format(this.properties.getEmptyListRowMessage(), new Integer(this.tableModel.getNumberOfColumns())));
        }
        return buffer.toString();
    }

    private String getTableFooter() {
        StringBuffer buffer = new StringBuffer(1000);
        if (this.properties.getAddPagingBannerBottom()) {
            buffer.append(this.getSearchResultAndNavigation());
        }
        if (this.export && this.tableModel.getRowListPage().size() != 0) {
            buffer.append(this.getExportLinks());
        }
        return buffer.toString();
    }

    private String getSearchResultAndNavigation() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] starting getSearchResultAndNavigation"));
        }
        if (this.pagesize != 0 && this.listHelper != null) {
            Href navigationHref = new Href(this.baseHref);
            StringBuffer buffer = new StringBuffer().append(this.listHelper.getSearchResultsSummary()).append(this.listHelper.getPageNavigationBar(navigationHref, this.encodeParameter("p")));
            return buffer.toString();
        }
        return "";
    }

    private String getExportLinks() {
        Href exportHref = new Href(this.baseHref);
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = MediaTypeEnum.iterator();
        while (iterator.hasNext()) {
            MediaTypeEnum currentExportType = (MediaTypeEnum)iterator.next();
            if (!this.properties.getAddExport(currentExportType)) continue;
            if (buffer.length() > 0) {
                buffer.append(this.properties.getExportBannerSeparator());
            }
            exportHref.addParameter(this.encodeParameter("e"), currentExportType.getCode());
            exportHref.addParameter("6578706f7274", "1");
            Anchor anchor = new Anchor(exportHref, this.properties.getExportLabel(currentExportType));
            buffer.append(anchor.toString());
        }
        Object[] exportOptions = new String[]{buffer.toString()};
        return MessageFormat.format(this.properties.getExportBanner(), exportOptions);
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.properties.setProperty(propertyName, propertyValue);
    }

    public void release() {
        super.release();
        this.decoratorName = null;
        this.defaultSortedColumn = -1;
        this.defaultSortOrder = null;
        this.export = false;
        this.length = 0;
        this.list = null;
        this.name = null;
        this.offset = 0;
        this.pagesize = 0;
        this.property = null;
        this.requestUri = null;
        this.scope = null;
        this.sortFullTable = null;
    }

    public String getName() {
        return this.name;
    }

    private String encodeParameter(String parameterName) {
        if (this.paramEncoder == null) {
            this.paramEncoder = new ParamEncoder(((TagSupport)this).id);
        }
        return this.paramEncoder.encodeParameterName(parameterName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

