/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Href
implements Cloneable {
    private String url;
    private Map parameters;
    private String anchor;

    public Href(String baseUrl) {
        String noAnchorUrl;
        this.parameters = new HashMap();
        int anchorposition = baseUrl.indexOf("#");
        if (anchorposition != -1) {
            noAnchorUrl = baseUrl.substring(0, anchorposition);
            this.anchor = baseUrl.substring(anchorposition + 1);
        } else {
            noAnchorUrl = baseUrl;
        }
        if (noAnchorUrl.indexOf("?") == -1) {
            this.url = noAnchorUrl;
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(noAnchorUrl, "?");
        this.url = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        StringTokenizer paramTokenizer = new StringTokenizer(tokenizer.nextToken(), "&");
        while (paramTokenizer.hasMoreTokens()) {
            String escapedValue;
            String[] keyValue = StringUtils.split((String)paramTokenizer.nextToken(), (String)"=");
            String escapedKey = StringEscapeUtils.escapeHtml((String)keyValue[0]);
            String string = escapedValue = keyValue.length > 1 ? StringEscapeUtils.escapeHtml((String)keyValue[1]) : "";
            if (!this.parameters.containsKey(escapedKey)) {
                this.parameters.put(escapedKey, escapedValue);
                continue;
            }
            Object previousValue = this.parameters.get(escapedKey);
            if (previousValue != null && previousValue.getClass().isArray()) {
                Object[] previousArray = (Object[])previousValue;
                Object[] newArray = new Object[previousArray.length + 1];
                for (int j = 0; j < previousArray.length; ++j) {
                    newArray[j] = previousArray[j];
                }
                newArray[j] = escapedValue;
                this.parameters.put(escapedKey, newArray);
                continue;
            }
            this.parameters.put(escapedKey, new Object[]{previousValue, escapedValue});
        }
    }

    public Href(Href href) {
        this.url = href.url;
        this.anchor = href.anchor;
        this.parameters = href.getParameterMap();
    }

    public Href addParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public Href addParameter(String name, int value) {
        this.parameters.put(name, new Integer(value));
        return this;
    }

    public Map getParameterMap() {
        HashMap copyMap = new HashMap(this.parameters.size());
        copyMap.putAll(this.parameters);
        return copyMap;
    }

    public void setParameterMap(Map parametersMap) {
        this.parameters = new HashMap(parametersMap.size());
        this.addParameterMap(parametersMap);
    }

    public void addParameterMap(Map parametersMap) {
        if (parametersMap == null) {
            return;
        }
        Iterator mapIterator = parametersMap.entrySet().iterator();
        while (mapIterator.hasNext()) {
            Map.Entry entry = mapIterator.next();
            String key = StringEscapeUtils.escapeHtml((String)((String)entry.getKey()));
            if (this.parameters.containsKey(key)) continue;
            Object value = entry.getValue();
            if (value != null) {
                if (value.getClass().isArray()) {
                    String[] values = (String[])value;
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = StringEscapeUtils.escapeHtml((String)values[i]);
                    }
                } else {
                    value = StringEscapeUtils.escapeHtml((String)value.toString());
                }
            }
            this.parameters.put(key, value);
        }
    }

    public String getBaseUrl() {
        return this.url;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String name) {
        this.anchor = name;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(30);
        buffer.append(this.url);
        if (this.parameters.size() > 0) {
            buffer.append('?');
            Set parameterSet = this.parameters.entrySet();
            Iterator iterator = parameterSet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) {
                    buffer.append(key).append('=').append("");
                } else if (value.getClass().isArray()) {
                    Object[] values = (Object[])value;
                    for (int i = 0; i < values.length; ++i) {
                        if (i > 0) {
                            buffer.append("&amp;");
                        }
                        buffer.append(key).append('=').append(values[i]);
                    }
                } else {
                    buffer.append(key).append('=').append(value);
                }
                if (!iterator.hasNext()) continue;
                buffer.append("&amp;");
            }
        }
        if (this.anchor != null) {
            buffer.append("#");
            buffer.append(this.anchor);
        }
        return buffer.toString();
    }

    public Object clone() {
        Href href = null;
        try {
            href = (Href)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        href.parameters = new HashMap(this.parameters);
        return href;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Href)) {
            return false;
        }
        Href rhs = (Href)object;
        return new EqualsBuilder().append((Object)this.parameters, (Object)rhs.parameters).append((Object)this.url, (Object)rhs.url).append((Object)this.anchor, (Object)rhs.anchor).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(1313733113, -431360889).append((Object)this.parameters).append((Object)this.url).append((Object)this.anchor).toHashCode();
    }
}

