/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.jetspeed.portlet.PortletResponse;
import org.apache.jetspeed.portlet.PortletURI;
import org.displaytag.util.DefaultRequestHelper;
import org.displaytag.util.Href;

public class WpsRequestHelper
extends DefaultRequestHelper {
    private static final String REFRESH_ACTION = "refresh";
    private static final String PORTLET_RESPONSE = "portletResponse";
    private PageContext pageContext;

    public WpsRequestHelper(PageContext context) {
        super((HttpServletRequest)context.getRequest(), (HttpServletResponse)context.getResponse());
        this.pageContext = context;
    }

    public Href getHref() {
        Href standardHref = super.getHref();
        Map parameterMap = standardHref.getParameterMap();
        Href portalHref = new Href(this.getRefreshUri());
        portalHref.setParameterMap(parameterMap);
        return portalHref;
    }

    private String getRefreshUri() {
        PortletURI portletURI = this.getPortletURI();
        portletURI.addAction(REFRESH_ACTION + Math.random());
        portletURI.addParameter("init", "init");
        return portletURI.toString();
    }

    public PortletURI getPortletURI() {
        PortletResponse portletResponse = this.getPortletResponse();
        PortletURI portletURI = portletResponse.createURI();
        return portletURI;
    }

    protected PortletResponse getPortletResponse() {
        PortletResponse portletResponse = (PortletResponse)this.pageContext.getAttribute(PORTLET_RESPONSE);
        if (portletResponse == null) {
            throw new RuntimeWpsSupportException();
        }
        return portletResponse;
    }

    public class RuntimeWpsSupportException
    extends RuntimeException {
        public RuntimeWpsSupportException() {
            super("Portlet response couldn't be found. Be sure to have the portletAPI:init tag at the beginning of the page");
        }
    }
}

